/*ScianWindows.h
  Routines for windows in scian
  Eric Pepke
  March 8, 1990
*/

#ifndef _H_WINDOWS
#define _H_WINDOWS

/*Flags for a window*/
#define WINRGB		1		/*Window wants to be RGB*/
#define WINDBUF		2		/*Window wants to be double buffered*/
#define WINZBUF		4		/*Window wants to be Z-buffered*/
#define WINFIXEDLOC	8		/*Fixed location*/
#define WINFIXEDSIZE	16		/*Fixed size window*/
#ifdef NOHIDEFRAME
#define WINNOFRAME	0		/*Must have window frame*/
#else
#define WINNOFRAME	32		/*No window frame*/
#endif
#define WINCENTERED	64		/*Center the window*/

extern Bool hasRGB;		/*Has RGB mode*/
extern Bool hasCmap;		/*Has color map mode*/
extern Bool hasRGBDouble;	/*Has RGB double buffer*/
extern Bool hasCmapDouble;	/*Has Cmap double buffer*/
extern Bool hasZbuf;		/*Has Z-buffer*/
extern Bool hasTransparency;	/*Has hardware transparency*/
extern Bool hasTwoSided;	/*Has two-sided lighting model*/
extern Bool hasOverDraw;	/*Has overdraw planes*/
extern Bool pupForOverDraw;	/*PUP planes are used for over draw, else overlay*/
extern Bool rgbGoodForUI;	/*RGB mode good for user interface*/
extern int cmapBitPlanes;		/*# color map bit planes*/
extern Bool scavengeColors;	/*Whether to scavenge for colors*/
extern int rBitPlanes, gBitPlanes, bBitPlanes;
					/*r, g, b bit planes*/
extern Bool showConfig;			/*True iff want to show configuration*/
extern Bool hasDithering;		/*True iff system has dithering*/

/*Macro to determine if a window is double buffered currently*/
#define AreFlagsDoubleBuf(flags)  ( (((flags) & WINRGB) && hasRGB) ?	\
	(hasRGBDouble && ((flags) & WINDBUF) ? true : false) :		\
	(hasCmapDouble && ((flags) & WINDBUF) ? true : false))
#define IsDoubleBuf(window) AreFlagsDoubleBuf(((WinInfoPtr) (window)) -> flags)
/*Menus, must go from 0 to NMENUS - 1*/
#define FILEMENU	0		/*"File" menu*/
#define NETWORKMENU	1		/*"Network" menu*/
#define DATASETSMENU	2		/*"Datasets" menu*/
#define OBJECTMENU	3		/*"Object" menu*/
#define COLORMENU	4		/*"Color" menu*/
#define TEXTMENU	5		/*"Text" menu*/
#define DEUSMENU	6		/*"Deus" menu*/
#define WINSIZEMENU	7		/*"Window Size" submenu*/
#define WINDOWSMENU	8		/*"Windows" menu*/
#define ARRANGEMENU	9		/*"Arrange" submenu*/
#define EFFECTSMENU	10		/*"Effects" submenu*/
#define COLORMODELMENU	11		/*"Color model" submenu*/
#define NMENUS		13		/*Number of menus*/

/*Values for drawingQuality*/
#define DQ_SKELETON     0               /*Draw as skeleton*/
#define DQ_WIREFRAME    1               /*Draw as a wire frame*/
#define DQ_FULL         2               /*Draw with full quality*/
#define DQ_NQUALITIES	3		/*Number of qualities*/

extern int drawingQuality;              /*Current drawing quality*/
extern int movingDrawingQuality;        /*Current moving drawing quality*/

typedef struct				/*Menu item within window*/
    {
	int menu;			/*Which menu the item is in*/
	char name[256];			/*Name of the menu item*/
	void (*action)();		/*Action of the menu item*/
    } MenuItem;

#define MAXNMENUITEMS	50		/*Maximum number of menu items per window*/

typedef struct win			/*Window information structure*/
    {
	Thing thing;			/*Thing part of the window*/
	long id;			/*Window identifier*/
	long flags;			/*Flags for the window*/
	struct win *next;		/*Next window record in the list*/
	long mainMenu;			/*Main menu, or 0 for none*/
	long subMenus[NMENUS];		/*Submenus*/
	int ol, or, ot, ob;		/*Old bounds*/
	int nl, nr, nt, nb;		/*New bounds*/
	char winTitle[256];		/*Title of the window*/
	int nMenuItems;			/*Number of menu items*/
	MenuItem menuItems[MAXNMENUITEMS];
	int minWidth, maxWidth;
	int minHeight, maxHeight;
    } WinInfo, *WinInfoPtr;

extern char *menuName[NMENUS];
extern WinInfoPtr inputWindow;		/*Current window for input or 0*/
extern WinInfoPtr selWinInfo;           /*Info for currently selected window*/
#ifdef GRAPHICS
#define SelectWindow(i) selWinInfo = GetWinInfo(i); if (selWinInfo) {winset(i);\
		curDisplayMode = getdisplaymode();\
		rgbp = (curDisplayMode == DMSINGLE || curDisplayMode == DMDOUBLE) ? false : true;}

#if 1
#define SelWindow(w) selWinInfo = w; if (w && ((WinInfoPtr) w) -> id) {winset(((WinInfoPtr) w) -> id);\
		curDisplayMode = getdisplaymode();\
		rgbp = (curDisplayMode == DMSINGLE || curDisplayMode == DMDOUBLE) ? false : true;}
#else
void SelWindow(WinInfoPtr w);
#endif
#else
#define SelectWindow(i) selWinInfo = GetWinInfo(i); if (selWinInfo) { \
		rgbp = true; }
#define SelWindow(w) selWinInfo = w;
#endif

extern int curDisplayMode;		/*Display mode of current window*/
extern Bool rgbp;			/*rgb predicate*/
extern ObjPtr windowClass;		/*Class of all windows*/
typedef int WindowID;			/*Machine-specific window identifier*/
extern WinInfoPtr allWindows;		/*All the windows*/
extern int updateBatch;			/*Current batch of updates*/
extern int recScrWidth, recScrHeight;	/*Width and height of recording screen*/
extern short curCursor;			/*Current cursor*/
extern Bool showControlPanels;		/*Show subsequent control panels*/

#ifdef PROTO
void ResetMovingQuality(void);
WinInfoPtr NewWinInfo(ObjPtr, long, long, char *, int, int, int, int);
WinInfoPtr GetWinInfo(long);
WinInfoPtr GetWinFromTitle(char *);
Bool DisposeAllWindows(void);
Bool IdleAllWindows(void);
void DrawWindow(long);
void ArrowWindow(long, long);
void DoToggleColorMode(void);
void DoToggleShrinkMode(void);
void DoMaxScreen(void);
void DoVideoScreen(void);
void Do2VideoScreen(void);
void DoPhscoScreen(void);
int ReshapeWindow(ObjPtr);
void InitWindows(void);
void KillWindows(void);
WindowID NewOpenedWindow(char *, int, int, int, int, long);
void BuildMenu(WinInfoPtr);
void DefineMenuItem(ObjPtr, int, char *, void (*action)());
void SetWindowTitle(ObjPtr, char *);
void MySetCursor(int);
void DeleteMenus(WinInfoPtr);
void SetMode(WinInfoPtr);
void LocateWindow(int, int, int, int);
void SetShrink(WinInfoPtr, Bool);
void SetMinSize(WinInfoPtr, int, int);
void PopWindow(WinInfoPtr);
void PushWindow(WinInfoPtr);
void SaveScreen(WinInfoPtr, int);
void GetWindowBounds(int *, int *, int *, int *);
void GetWindowOrigin(int *, int *);
void SetWindowPosition(int, int, int, int);
void ForAllWindows(void (*routine)());
Bool IsValidWindow(WinInfoPtr);
void PopDatasetsWindow(void);
WinInfoPtr WhichWindow(int x, int y);
WinInfoPtr TopWindow(void);
WinInfoPtr BottomWindow(void);
Bool BelowAllBut(WinInfoPtr, WinInfoPtr);
Bool AboveAllMainWindows(WinInfoPtr);
void GetConfiguration(void);
void CloseWindow(WinInfoPtr);
void ContentsExpectWindowSize(WinInfoPtr, int, int);
#else
void ResetDrawingQuality();
WinInfoPtr NewWinInfo();
WinInfoPtr GetWinInfo();
WinInfoPtr GetWinFromTitle();
Bool DisposeAllWindows();
Bool IdleAllWindows();
void DoToggleShrinkMode();
void DrawWindow();
void ArrowWindow();
void DoMaxScreen();
void DoVideoScreen();
void Do2VideoScreen();
void DoPhscoScreen();
int ReshapeWindow();
void InitWindows();
void KillWindows();
WindowID NewOpenedWindow();
void BuildMenu();
void DefineMenuItem();
void SetWindowTitle();
void MySetCursor();
void DeleteMenus();
void SetMode();
void LocateWindow();
void SetShrink();
void SetMinSize();
void PopWindow();
void PushWindow();
void SaveScreen();
void GetWindowBounds();
void GetWindowOrigin();
void SetWindowPosition();
void ForAllWindows();
Bool IsValidWindow();
void PopDatasetsWindow();
WinInfoPtr WhichWindow();
WinInfoPtr TopWindow();
WinInfoPtr BottomWindow();
Bool BelowAllBut();
Bool AboveAllMainWindows();
void GetConfiguration();
void CloseWindow();
void ContentsExpectWindowSize();
#endif

#endif
