/* ScianTypes.h: header file for ScianTypes.c structures. requires
		that Scian.h be included prior to this file.
	This file contains, in order, what was once ScianObjects.h,
	the old ScianTypes.h, and ScianArrays.h
*/

typedef unsigned long FlagsTyp;		/*Type for thing*/
#define HTON_FLAGSTYP(x) htonl(x)	/* for NetObjects stuff */
#define NTOH_FLAGSTYP(x) ntohl(x)	/* must be updated if type changes */

typedef unsigned long NameTyp;		/*Name defining things and variables*/
#define HTON_NAMETYP(x) htonl(x)	/* for NetObjects stuff */
#define NTOH_NAMETYP(x) ntohl(x)

/*Object types*/
typedef struct VarsNode {
	NameTyp		name;		/*ID # of this variable association */
	struct Obj	*value;		/*(ThingPtr) value of this var. assoc.*/
	struct VarsNode	*left;		/*internal pointers to subtrees */
	struct VarsNode	*right;
	long		chCount;	/*count number of changes to this var*/
} Vars, *VarsPtr;

typedef struct DependListEl {
	NameTyp	indirectVar;
	NameTyp var;
	struct DependListEl *next;
} *DLPtr;

typedef struct DependNode {
	NameTyp		  var;
	DLPtr		  dependList;
	int		  longestBranch;
	struct DependNode *left;
	struct DependNode *right;
} Depend, *DependPtr;

typedef struct Obj {
	FlagsTyp	flags;		/*Type flags of the thing*/
	struct Obj	*class;		/*pointer to class of object */
	VarsPtr		vars;		/*pointer to top node of Vars bintree*/
	struct MethNode	*methods;	/* " to top node of Methods bintree */
	DependPtr	depends;	/* " to top node of Dependencies tree */
	int		garbageFlag;	/*flags for deletion record-keeping */
        struct Obj	*gNext;		/*next node in garbage list*/
} Thing, *ThingPtr, Obj, *ObjPtr;

#define NULLOBJ ((ObjPtr) 0)
typedef ObjPtr (* FuncTyp)();		/*typedef Methods function pointers */
extern ObjPtr ObjTrue;
extern ObjPtr ObjFalse;

typedef struct MethNode {
	NameTyp		name;		/*ID # of Method association */
	FuncTyp		method;		/*pointer to Method function */
	struct MethNode	*left;		/*internal pointers to subtrees */
	struct MethNode *right;
} Method, *MethodPtr;

extern long globalThingCount;	/* number of things in the world */

#define IncGlobalThingCount() (++globalThingCount)

/* EMP method declarations */
ObjPtr		SetObjValue();
ObjPtr		GetObjValue();

/*** former ScianObjects functions definitions */

#ifdef	PROTO
Bool		IsTrue(ObjPtr);
void		InitObjects();
void		KillObjects();
ObjPtr		NewObject(ObjPtr class,NameTyp name);
ObjPtr		ClassOf(ObjPtr);
unsigned long	GetVarChangeCount(ObjPtr, NameTyp);
int		SetVarChangeCount(ObjPtr, NameTyp);
ObjPtr		SetVar(ObjPtr object,NameTyp varname,ThingPtr value);
Bool		ChangeVar(ObjPtr, NameTyp, ObjPtr);
void		TurnOnStatistics();
void		ClearStatistics();
void		PrintStatistics();
void		TurnOffStatistics();
ThingPtr	GetVar(ObjPtr object,NameTyp varname);
ThingPtr	Get1Var(ObjPtr, NameTyp);
void		PrintObject(ObjPtr object);
void		PrintVarNodes(VarsPtr vp, int indent);
void		PrintVarTree(ObjPtr object);
void		DeleteThing(ObjPtr thing);
void		DecGlobalThingCount();
FuncTyp		GetMethod(ObjPtr object, NameTyp methname);
FuncTyp		Get1Method(ObjPtr, NameTyp);
Bool		SetMethod(ObjPtr obj, NameTyp methname, FuncTyp value);
void		AddDependency(DLPtr *, NameTyp, NameTyp);
DependPtr	NewDependNode(NameTyp);
Bool		SetIndirectDependency(ObjPtr, NameTyp, NameTyp, NameTyp);
Bool		SetDependency(ObjPtr, NameTyp, NameTyp);
void		GetDependencies(ObjPtr, NameTyp, void (*) (ObjPtr, NameTyp, NameTyp, NameTyp));
void		PrintDependencies(ObjPtr, NameTyp);
Bool		SanityCheckObject(ObjPtr);
void		PrintAllDependencies(ObjPtr);
#else
Bool		IsTrue();
void		InitObjects();
void		KillObjects();
ObjPtr		NewObject();
ObjPtr		ClassOf();
unsigned long	GetVarChangeCount();
int		SetVarChangeCount();
ObjPtr		SetVar();
Bool		ChangeVar();
void		TurnOnStatistics();
void		ClearStatistics();
void		PrintStatistics();
void		TurnOffStatistics();
ThingPtr	GetVar();
ThingPtr	Get1Var();
void		PrintObject();
void		PrintVarNodes();
void		PrintVarTree();
void		DeleteThing();
void		DecGlobalThingCount();
FuncTyp		GetMethod();
FuncTyp		Get1Method();
Bool		SetMethod();
void		AddDependency();
DependPtr	NewDependNode();
Bool		SetIndirectDependency();
Bool		SetDependency();
DLPtr		GetDependencies();
void		PrintDependencies();
Bool		SanityCheckObject();
#endif

#define GetRefCount(thingp) ((thingp) ? (thingp) -> refCount : -1)

/*** former ScianTypes structures and functions */

typedef	struct	RealStruct {
		Thing	thing;			/* flags and stuff */
		real	realpart;		/* the actual Real data */
} RealThing, *RPtr;

typedef ObjPtr RealPtr;

typedef struct	IntStruct {
		Thing	thing;			/* flags and stuff */
		int	intpart;		/* the actual Integer data */
} IntThing, *IPtr;

typedef ObjPtr IntPtr;

typedef struct	StringStruct {
		Thing	thing;			/* flags and stuff */
		char	*stringPtr;		/* the actual String data */
} StringThing, *SPtr;

typedef ObjPtr StringPtr;

#ifdef PROTO
ObjPtr	NewInt(int intno);
int	GetInt(ObjPtr ip);
void	SetInt(ObjPtr ip,int intno);
void	PrintInt(ObjPtr ip);
ObjPtr	NewReal(real realno);
real	GetReal(ObjPtr rp);
void	SetReal(ObjPtr rp,real realno);
void	PrintReal(ObjPtr rp);
ObjPtr	NewString(char *string);
char	*GetString(ObjPtr sp);
Bool	SetString(ObjPtr sp, char *string);
ObjPtr	ConcatStrings(ObjPtr, ObjPtr);
void	PrintString(ObjPtr sp);
Bool	Eql(ObjPtr, ObjPtr);
ObjPtr	Clone(ObjPtr);
#else
ObjPtr	NewInt();
int	GetInt();
void	SetInt();
void	PrintInt();
ObjPtr	NewReal();
real	GetReal();
void	SetReal();
void	PrintReal();
ObjPtr	NewString();
char	*GetString();
Bool	SetString();
ObjPtr	ConcatStrings();
void	PrintString();
Bool	Eql();
void	Clone();
#endif

/* Network things added to ScianTypes.c */

extern ObjPtr NetworkStub;	/* special object indicating a remote object */
extern ObjPtr NetworkUpdated;	/* " " remote object needs updating */
extern ObjPtr NetworkWaiting;	/* " " remote object waiting for communication */

#define IsNetworkStub(x) ((void *) (x) == (void *) NetworkStub)
#define IsNetworkUpdated(x) ((void *) (x) == (void *) NetworkUpdated)
#define IsNetworkWaiting(x) ((void *) (x) == (void *) NetworkWaiting)

#define IsNetwork(x) ((void *) (x) == (void *) NetworkStub || \
		      (void *) (x) == (void *) NetworkUpdated || \
		      (void *) (x) == (void *) NetworkWaiting)

#define IsRemote(x) ((x) && (((ObjPtr)(x)) -> flags & ISREMOTE))
#define IsPublished(x) ((x) && (((ObjPtr)(x)) -> flags & ISPUBLISHED))
#define IsWaiting(x) ((x) && (((ObjPtr)(x)) -> flags & ISWAITING))

#define ISREMOTE	0x40000000L	/* it was received from some process */
#define ISPUBLISHED	0x20000000L	/* it was sent to some remote process */
#define ISWAITING	0x10000000L	/* some remote communication will fill this */

extern ObjPtr objClass;		/* so NetObjects.c can get to these */
extern ObjPtr stringClass;

extern unsigned long anotherDamnReferenceCount;

extern char *whatsMyName;
