/*ScianTemplates.h
  Template stuff for SciAn controls
  Eric Pepke
  August 10, 1992
*/

typedef struct
    {
	char *name;
	int l, r, b, t;
    } Template, *TemplatePtr;

#include "ScianTemplateHelper.h"

#ifdef PROTO
Bool GetTemplateBounds(TemplatePtr, char *, int *l, int *r, int *b, int *t);
ObjPtr TemplateTitleBox(TemplatePtr, char *);
ObjPtr TemplateRadioButton(TemplatePtr, char *);
ObjPtr TemplateCheckBox(TemplatePtr, char *, Bool);
ObjPtr TemplateTextBox(TemplatePtr, char *, int, char *);
ObjPtr TemplatePanel(TemplatePtr, char *);
#else
Bool GetTemplateBounds();
ObjPtr TemplateTitleBox();
ObjPtr TemplateRadioButton();
ObjPtr TemplateCheckBox();
ObjPtr TemplateTextBox();
ObjPtr TemplatePanel();
#endif