/*ScianWindows.h
  Routines for windows in scian
  Eric Pepke
  March 8, 1990
*/

/*Flags for a window*/
#ifdef GL4D
#define WINRGB		1		/*Window wants to be RGB*/
#endif
#define WINDBUF		2		/*Window wants to be double buffered*/
#define WINZBUF		4		/*Window wants to be Z-buffered*/
#define WINSHRINK	8		/*Anti-alias shrink*/
#define WINFIXEDSIZE	16		/*Fixed size window*/
#define WINNOFRAME	32		/*No window frame*/
#define WINCENTERED	64		/*Center the window*/

/*Menus, must go from 0 to NMENUS - 1*/
#define FILEMENU	0		/*"File" menu*/
#define EDITMENU	1		/*"Edit" menu*/
#define OBJECTMENU	2		/*"Object" menu*/
#define TEXTMENU	3		/*"Space" menu*/
#define ARRANGEMENU	4		/*"Arrange" menu*/
#define WINDOWSMENU	5		/*"Windows" menu*/
#define NMENUS		6		/*Number of menus*/

/*Values for picState*/
#define FG		2		/*Bit for front good*/
#define BG		1		/*Bit for back good*/
#define FBBB		0		/*Front buffer bad,  back buffer bad */
#define FBBG		BG		/*Front buffer bad,  back buffer good*/
#define FGBB		FG		/*Front buffer good, back buffer bad */
#define FGBG		(FG | BG)	/*Front buffer good, back buffer good*/

/*Values for drawingQuality*/
#define DQ_SKELETON     0               /*Draw as skeleton*/
#define DQ_WIREFRAME    1               /*Draw as a wire frame*/
#define DQ_FULL         2               /*Draw with full quality*/
#define DQ_NQUALITIES	3		/*Number of qualities*/

extern int drawingQuality;              /*Current drawing quality*/

typedef struct				/*Menu item within window*/
    {
	int menu;			/*Which menu the item is in*/
	char name[256];			/*Name of the menu item*/
	void (*action)();		/*Action of the menu item*/
    } MenuItem;

#define MAXNMENUITEMS	20		/*Maximum number of menu items per window*/

typedef struct win			/*Window information structure*/
    {
	Thing thing;			/*Thing part of the window*/
	long id;			/*Window identifier*/
	long flags;			/*Flags for the window*/
	Bool open;			/*True iff open*/
	struct win *next;		/*Next window record in the list*/
	long mainMenu;			/*Main menu, or 0 for none*/
	long subMenus[NMENUS];		/*Submenus*/
	int ol, or, ot, ob;		/*Old bounds*/
	int nl, nr, nt, nb;		/*New bounds*/
	char winTitle[256];		/*Title of the window*/
	int nMenuItems;			/*Number of menu items*/
	MenuItem menuItems[MAXNMENUITEMS];
	int minWidth, maxWidth;
	int minHeight, maxHeight;
    } WinInfo, *WinInfoPtr;

extern WinInfoPtr curIntWindow;		/*The current window being interacted*/
extern int selWindow;                   /*Currently selected window*/
extern WinInfoPtr selWinInfo;           /*Info for currently selected window*/
#ifdef GRAPHICS
#if 1
#define SelectWindow(i) selWinInfo = GetWinInfo(i); if (selWinInfo) {selWindow = i; winset(i);\
		curDisplayMode = getdisplaymode();\
		rgbp = (curDisplayMode == DMSINGLE || curDisplayMode == DMDOUBLE) ? false : true;}
#else
void SelectWindow(int);
#endif
#else
#define SelectWindow(i) selWinInfo = GetWinInfo(i); if (selWinInfo) {selWindow = i; \
		rgbp = true; }
#endif

extern int curDisplayMode;		/*Display mode of current window*/
extern Bool rgbp;			/*rgb predicate*/
extern ObjPtr windowClass;		/*Class of all windows*/
typedef int WindowID;			/*Machine-specific window identifier*/
extern WinInfoPtr allWindows;		/*All the windows*/
extern int updateBatch;			/*Current batch of updates*/
extern int recScrWidth, recScrHeight;	/*Width and height of recording screen*/
extern short curCursor;			/*Current cursor*/

#ifdef PROTO
void ResetMovingQuality(void);
WinInfoPtr NewWinInfo(ObjPtr, long, long, char *, int, int, int, int);
WinInfoPtr GetWinInfo(long);
WinInfoPtr GetWinFromTitle(char *);
Bool DisposeWindow(long);
Bool DisposeAllWindows(void);
Bool IdleAllWindows(void);
void DrawWindow(long);
void ArrowWindow(long, long);
void DoToggleColorMode(void);
void DoToggleShrinkMode(void);
void DoClose(void);
void DoMaxScreen(void);
void DoVideoScreen(void);
void Do2VideoScreen(void);
void DoPhscoScreen(void);
int ReshapeWindow(ObjPtr, int, int, int, int);
void InitWindows(void);
void KillWindows(void);
WindowID NewOpenedWindow(char *, int, int, int, int, long);
void BuildMenu(WinInfoPtr);
void DefineMenuItem(ObjPtr, int, char *, void (*action)());
void SetWindowTitle(ObjPtr, char *);
void MySetCursor(int);
void DeleteMenus(WinInfoPtr);
void SetMode(WinInfoPtr);
void LocateWindow(int, int, int, int);
void SetShrink(WinInfoPtr, Bool);
void SetMinSize(WinInfoPtr, int, int);
void PopWindow(WinInfoPtr);
void SaveScreen(WinInfoPtr, int);
void GetWindowBounds(int *, int *, int *, int *);
void GetWindowOrigin(int *, int *);
#else
void ResetDrawingQuality();
WinInfoPtr NewWinInfo();
WinInfoPtr GetWinInfo();
WinInfoPtr GetWinFromTitle();
Bool DisposeWindow();
Bool DisposeAllWindows();
Bool IdleAllWindows();
void DoToggleShrinkMode();
void DrawWindow();
void ArrowWindow();
void DoClose();
void DoMaxScreen();
void DoVideoScreen();
void Do2VideoScreen();
void DoPhscoScreen();
int ReshapeWindow();
void InitWindows();
void KillWindows();
WindowID NewOpenedWindow();
void BuildMenu();
void DefineMenuItem();
void SetWindowTitle();
void MySetCursor();
void DeleteMenus();
void SetMode();
void LocateWindow();
void SetShrink();
void SetMinSize();
void PopWindow();
void SaveScreen();
void GetWindowBounds();
void GetWindowOrigin();
#endif
