/*ScianErrors.h
  Public routines for ScianErrors.c
*/

/*Errors*/
#define VARNOTFOUND		1	/*Variable is not found*/
#define VARNOTOBJECT		2	/*Variable is not an object*/
#define VARNOTARRAY		3	/*Variable is not an array*/
#define VARBADRANK		4	/*Rank of an array is bad*/
#define VARBADDIM		5	/*A dimension of an array is bad*/
#define VARNOTPICTURE		6	/*Variable is not a picture*/
#define VARNOTINT		7	/*Variable is not an integer*/
#define VARNOTREAL		8	/*Variable is not a real number*/
#define NOCORRAL		9	/*There is no corral*/
#define VARNOTPALETTE		10	/*Var is not a palette*/
#define VARNOTLIST		11	/*Var is not a list*/
#define NOPANEL			12	/*There is no panel*/
#define VARNOTMATRIX		13	/*Var is not a matrix*/
#define METHODNOTFOUND		14	/*Method is not found*/
#define VARNOTWINDOW		15	/*Var is not a window*/
#define VARNOTSTRING		16	/*Var is not a string*/
#define CREATEFILEERROR		17	/*Error creating a file*/
#define OPENFILEERROR		18	/*Error opening a file*/
#define NOCANVIS		19	/*Cannot visualize object*/
#define NOPARENT		20	/*No parent to an object*/
#define ARRAYEXP		21	/*An array was expected*/
#define PALNOTSAMESIZE		22	/*Palettes were not the same size*/

#ifdef PROTO
void OMErr(void);
void Error(char *, int, ...);
FuncTyp GetMethodSurely(char *, ObjPtr, NameTyp);
ObjPtr GetObjectVar(char *, ObjPtr, NameTyp);
ObjPtr GetListVar(char *, ObjPtr, NameTyp);
ObjPtr GetPictureVar(char *, ObjPtr, NameTyp);
ObjPtr GetWindowVar(char *, ObjPtr, NameTyp);
ObjPtr GetArrayVar(char *, ObjPtr, NameTyp);
ObjPtr GetMatrixVar(char *, ObjPtr, NameTyp);
ObjPtr GetIntVar(char *, ObjPtr, NameTyp);
ObjPtr GetRealVar(char *, ObjPtr, NameTyp);
ObjPtr GetPaletteVar(char *, ObjPtr, NameTyp);
ObjPtr GetStringVar(char *, ObjPtr, NameTyp);
ObjPtr GetFixedArrayVar(char *, ObjPtr, NameTyp, int, ...);
ObjPtr GetTimedVar(ObjPtr, NameTyp);
Bool GetPredicate(ObjPtr, NameTyp);
char *IDName(NameTyp);
#else
void OMErr();
void Error();
FuncTyp GetMethodSurely();
ObjPtr GetObjectVar();
ObjPtr GetListVar();
ObjPtr GetPictureVar();
ObjPtr GetWindowVar();
ObjPtr GetArrayVar();
ObjPtr GetMatrixVar();
ObjPtr GetIntVar();
ObjPtr GetRealVar();
ObjPtr GetFixedArrayVar();
ObjPtr GetPaletteVar();
ObjPtr GetStringVar();
ObjPtr GetTimedVar();
Bool GetPredicate();
char *IDName();
#endif
