/*ScianDepend.c
  Eric Pepke
  May 22, 1991
  Dependencies system for SciAn
*/

#include "Scian.h"
#include "ScianTypes.h"
#include "ScianLists.h"
#include "ScianIDs.h"
#include "ScianErrors.h"
#include "ScianMethods.h"

Bool IsDependent(object, destVar, sourceVar)
ObjPtr object;
int destVar, sourceVar;
/*Returns true if destVar is already dependent on sourceVar.  Only works
  on direct dependencies*/
{
    do
    {
	ObjPtr dependList;
	dependList = Get1Var(object, DEPENDENCIES);
	if (dependList && IsList(dependList))
	{
	    ThingListPtr runner;
	    runner = LISTOF(dependList);
	    while (runner)
	    {
		ObjPtr d, s;
		d = runner -> thing;
		do
		{
		    s = runner -> thing;
		    runner = runner -> next;
		} while (runner -> thing);
		if (IsInt(d) && IsInt(s) &&
			GetInt(d) == destVar && GetInt(s) == sourceVar)
		{
		    return true;
		}
		runner = runner -> next;
	    }
	}
    } while (object = ClassOf(object));
    return false;
}

Bool MakeVar(origObj, destVar)
ObjPtr origObj;
int destVar;
/*Makes destVar within origObj.  Returns true iff it had to make it.*/
{
    ObjPtr class, var;
    FuncTyp method;
    Bool retVal = false;

    if (GetVarChangeCount(origObj, destVar) <= 0)
    {
	retVal = true;
    }

    class = origObj;
    do
    {
	ObjPtr dependList;
	dependList = Get1Var(class, DEPENDENCIES);
	if (dependList && IsList(dependList))
	{
	    register ThingListPtr runner;
	    runner = LISTOF(dependList);
	    while (runner)
	    {
		ObjPtr d, s;
		d = runner -> thing;
		runner = runner -> next;
		if (runner)
		{
		    s = runner -> thing;
		    if (IsInt(d) && IsInt(s) &&
			GetInt(d) == destVar)
		    {
			/*The destination is this variable.  Follow indirections*/
			int var;

			ObjPtr indObject;

			indObject = origObj;

			runner = runner -> next;
			while (runner -> thing)
			{
			    int var;
			    /*It's an indirect reference*/
			    var = GetInt(s);

			    MakeVar(indObject, var);
			    indObject = GetVar(indObject, var);
			    
			    if (!indObject)
			    {
				/*Skip to next dependency*/
				while (runner -> thing)
				{
				    runner = runner -> next;
				}
				
				/*ReportError("MakeVar", "No indirect object found");*/
				goto nextRunner;
			    }

			    s = runner -> thing;
			    runner = runner -> next;
			}
			var = GetInt(s);

			/*See if it needs to be made*/
			MakeVar(indObject, var);

			if (GetVarChangeCount(indObject, var) >
			    GetVarChangeCount(origObj, destVar))
			{
			    /*Yes, it needs to be made*/
			    retVal = true;
			}
		    }
		    else
		    {
			/*Skip to next dependency*/
			while (runner -> thing)
			{
			    runner = runner -> next;
			}
		    }
nextRunner:
		    runner = runner -> next;
		}
	    }
	}
    } while (class = ClassOf(class));

    if (retVal)
    {
	FuncTyp method;

	method = GetMethod(origObj, destVar);
	if (method)
	{
#ifdef DEBUG
	    ObjPtr name;
	    char out[256];
	    name = GetVar(origObj, NAME);

	    sprintf(out, "Making object %lx ", origObj);
	    if (name)
	    {
		sprintf(tempStr, "(%s) ", GetString(name));
		strcat(out, tempStr);
	    }
	    sprintf(tempStr, "variable %s", IDName(destVar));
	    strcat(out, tempStr);

	    puts(out);
#endif
	    (*method)(origObj);
	}
	else
	{
	    /*ReportError("MakeVar", "No make method found");*/
	}
    }

    return retVal;
}

void DeclareDependency(object, destVar, sourceVar)
ObjPtr object;
int destVar, sourceVar;
/*Declares a variable dependency within object of destVar on sourceVar*/
{
    ObjPtr dependList;

    if (IsDependent(object, destVar, sourceVar))
    {
	return;
    }

    dependList = Get1Var(object, DEPENDENCIES);
    if (!dependList || !IsList(dependList))
    {
	dependList = NewList();
	SetVar(object, DEPENDENCIES, dependList);
    }
    PrefixList(dependList, NULLOBJ);	/*End of dependency*/
    PrefixList(dependList, NewInt(sourceVar));
    PrefixList(dependList, NewInt(destVar));
}

void DeclareIndirectDependency(object, destVar, indirectObject, sourceVar)
ObjPtr object;
int destVar, indirectObject, sourceVar;
/*Declares a variable dependency within object of destVar on sourceVar
  within object indirectObject*/
{
    ObjPtr dependList;

    dependList = Get1Var(object, DEPENDENCIES);
    if (!dependList || !IsList(dependList))
    {
	dependList = NewList();
	SetVar(object, DEPENDENCIES, dependList);
    }
    PrefixList(dependList, NULLOBJ);	/*End of dependency*/
    PrefixList(dependList, NewInt(sourceVar));
    PrefixList(dependList, NewInt(indirectObject));
    PrefixList(dependList, NewInt(destVar));
}
