/*ScianArrays.h
  Eric Pepke
  February 9, 1990
  Externally available stuff for arrays.
*/

#ifndef SCIANARRAYS
#define SCIANARRAYS
/*Array type*/

typedef ObjPtr ArrayPtr;

typedef struct
    {
        Thing thing;		/*The thing part, containing flags*/
	void *elements;		/*Pointer to the elements of the array*/
        int rank;		/*The rank of the array*/
        long *dims;		/*Dimensions start here--rank # of longs*/
    } Array, *APtr;

#define RANK(a) (((APtr) (a)) -> rank)
#define DIMS(a) (((APtr) (a)) -> dims)
#define ELEMENTS(a) (((APtr) (a)) -> elements)
#define ArrayMeat(ar) ((real *) ELEMENTS(ar))

typedef struct
    {
	Thing thing;		/*The thing part, containing flags*/
	Matrix matrix;		/*The matrix*/
    } *MPtr;

#define MATRIXOF(a) (((MPtr) (a)) -> matrix)
#define MATCOPY(d, s) {int i, j; for (i = 0; i < 4; ++i) for (j = 0; j < 4; ++j) d[i][j] = s[i][j];}
#define CROSS(A, B, C) C[0]=A[1]*B[2]-A[2]*B[1]; C[1]=A[2]*B[0]-A[0]*B[2]; C[2]=A[0]*B[1]-A[1]*B[0];
#define NORMALIZE(A) {register double f; f = 1.0 / sqrt(A[0]*A[0] + A[1]*A[1] +A[2]*A[2]); A[0] *= f; A[1]*=f; A[2]*=f;}
#define VECCOPY(d, s) d[0] = s[0], d[1] = s[1], d[2] = s[2]

typedef real twoArray[2];
typedef real threeArray[3];

/*Array types*/
#define AT_REAL		1	/*Array of reals*/
#define AT_OBJECT	2	/*Array of objects*/

#ifdef PROTO
ObjPtr NewRealArray(int, ...);
ObjPtr NewMatrix(void);
void ArrayMinMax(real *, real *, ObjPtr);
ObjPtr InterpArray(ObjPtr, ObjPtr, real);
void CArray2Array(/*ObjPtr, *void *pointer*/);
void Array2CArray(/*void *pointer, ObjPtr*/);
void InitArrays(void);
void KillArrays(void);
ObjPtr NewArray(int arrayType, int rank, long *dimensions);
ObjPtr ListToArray(ObjPtr);
ObjPtr SortArrayByStringVar(ObjPtr, int);
ObjPtr SortArray(ObjPtr);
ObjPtr Uniq(ObjPtr);
long SearchReal(ObjPtr, real);
ObjPtr InsertInArray(ObjPtr, ObjPtr, long);
ObjPtr MergeRealArrays(ObjPtr, ObjPtr);
ObjPtr RealArrayDeltas(ObjPtr);
#else
ObjPtr NewRealArray();
ObjPtr NewMatrix();
void ArrayMinMax();
ObjPtr InterpArray();
void CArray2Array();
void Array2CArray();
void InitArrays();
void KillArrays();
ObjPtr NewArray();
ObjPtr ListToArray();
ObjPtr SortArrayByStringVar();
ObjPtr SortArray();
ObjPtr Uniq();
long SearchReal();
ObjPtr InsertInArray();
ObjPtr MergeRealArrays();
ObjPtr RealArrayDeltas();
#endif

#endif
