/*ScianColors.h
  Color management info for scian
  Eric Pepke
  March 15, 1990
*/

/*User interface color ID's and indices into palette*/
#define UIBLACK		0		/*Black				*/
#define UIGRAY12	1		/*12.5 % Gray			*/
#define UIGRAY25	2		/*25 % Gray			*/
#define UIGRAY37	3		/*37.5 % Gray			*/
#define UIGRAY50	4		/*50 % Gray			*/
#define UIGRAY62	5		/*62.5 % Gray			*/
#define UIGRAY75	6		/*75 % Gray			*/
#define UIGRAY87	7		/*87.5 % Gray			*/
#define UIWHITE		8		/*White				*/
#define UIRED		9		/*Bright red			*/
#define UIGREEN		10		/*Bright green			*/
#define UIBLUE		11		/*Bright blue			*/
#define UIMAGENTA	12		/*Bright magenta		*/
#define UIYELLOW	13		/*Bright yellow			*/
#define UICYAN		14		/*Bright cyan			*/
#define UIORANGE	15		/*Bright orange			*/
#define UIPRED		16		/*Pastel red (pink)		*/
#define UIPINK		16		/*Another name for pink		*/
#define UIPGREEN	17		/*Pastel green			*/
#define UIPBLUE		18		/*Pastel blue			*/
#define UIPMAGENTA	19		/*Pastel magenta		*/
#define UIPYELLOW	20		/*Pastel yellow			*/
#define UIPCYAN		21		/*Pastel cyan			*/
#define UIPURPLE	22		/*Bright purple			*/
#define UIGOLD		23		/*Gold, as in garnet and        */
#define NUICOLORS	24

#define DEFPALSIZE	64		/*Default number of colors in palette*/

/*Do not contrast any of the pastel colors with UIBACKGROUND*/

/*Derived colors*/
#define UIBACKGROUND	UIGRAY50	/*Panel background*/
#define UIHIBACKGROUND	UIWHITE		/*Hilighted panel background*/
#define UITEXT		UIBLACK		/*Color to draw unhilited text*/
#define UIGREYTEXT	UIGRAY12	/*Color of greyed text*/

#define UITOPEDGE	UIWHITE		/*Top edge of a projection*/
#define UILEFTEDGE	UIGRAY75	/*Left edge of a projection*/
#define UIRIGHTEDGE	UIGRAY25	/*Right edge of a projection*/
#define UIBOTTOMEDGE	UIGRAY12	/*Bottom edge of a projection*/
#define UISHADOW	UIGRAY12	/*Icon shadow*/
#define UIICONBACK	UIGRAY87	/*Unhilighted icon background color*/
#define UIICONGREYFORE	UIGRAY25	/*Grey icon foreground*/
#define UIICONGREYBACK	UIGRAY75	/*Grey icon background*/
#define UIICONFORE	UIBLACK		/*Icon foreground color*/
#define UIICONPIT	UIPCYAN		/*Icon Pit color*/
#define UITEXTPIT	UIPRED		/*Text Pit color*/
#define UIICONHIBACK	UIWHITE		/*Highlighted icon background*/
#define UIICONSELBACK	UIYELLOW	/*Selected icon background*/

extern Bool hasRGB;		/*Has RGB mode*/
extern Bool hasCmap;		/*Has color map mode*/
extern Bool hasDouble;		/*Has double buffer*/
extern Bool hasZbuf;		/*Has Z-buffer*/
extern Bool hasTransparency;	/*Has hardware transparency*/

typedef short short3[3];

extern short uiColors[NUICOLORS][3];

typedef struct pal
    {
	Thing thing;
	struct pal *next;		/*Next palette in list of active palettes*/
	int beg;			/*Beginning of color, or -1 if not allocated*/
	int nColors;
	real min, max;			/*Minimum and maximum that map to palette*/
	short3 *colors;			/*The colors in the palette*/ 
    } Palette, *PPtr;

extern short3 *curColors;		/*The current colors*/
extern int curNColors;			/*Current number of colors*/
extern real curMin, curMax;		/*Current min and max values*/
extern int curBeg;			/*Current beginning*/
extern PPtr curPalette;			/*Current palette*/
extern real diffMult;			/*Amount to multiply to get difference*/

#define SetColor(p, c) 							\
	if (rgbp)							\
	    c3s(((PPtr) p) -> colors[c]);				\
	else								\
	    color(((PPtr) p) -> beg + (c));
#define SetRealColor(c)	/*Sets real color c in current palette*/	\
	if (c == missingData)						\
	{								\
	    if (rgbp)							\
	        c3s(curPalette -> colors[0]);				\
	    else							\
	        color((int) curBeg - 2);				\
	}								\
	else if (c < curMin)						\
	{								\
	    if (rgbp)							\
	        c3s(curPalette -> colors[1]);				\
	    else							\
	        color((int) (curBeg - 1));				\
	}								\
	else if (c > curMax)						\
	{								\
	    if (rgbp)							\
	        c3s(curPalette -> colors[curNColors - 1]);	\
	    else							\
	        color((int) (curBeg + curNColors - 3));	\
	}								\
	else								\
	{								\
	    if (rgbp)							\
		c3s(curPalette -> colors[2 + (int) (diffMult * (c - curMin))]);\
	    else							\
		color((int) (curBeg + diffMult * (c - curMin)));	\
	}

#define GetRealColorIndex(c)	/*Gets index or real color for data c in current palette*/\
	c == missingData ?						\
	    -2 :							\
	c < curMin ?							\
	    -1 :							\
	c > curMax ?							\
	    curNColors - 3 :							\
	(int) (diffMult * (c - curMin))				\


#define GREYPAT		1		/*Grey pattern*/
#define SOLIDPAT	0		/*System pattern, solid*/

extern Bool rgbp;

#ifdef PROTO
void InitColors();
void SetUIColor(int);
ObjPtr NewPalette(int);
void DisposePalette(ObjPtr);
void InterpPalette(ObjPtr, int, int, int, int, int, int);
ObjPtr ClonePalette(ObjPtr);
ObjPtr NewColorWheel(int, int, int, int, char *);
void HSV2RGB(real *, real *, real *, real, real, real);
void RGB2HSV(real *, real *, real *, real, real, real);
void SetPalette(ObjPtr);
void SetPaletteMinMax(ObjPtr, real, real);
void CopyPalette(ObjPtr, ObjPtr);
void CopyAttenuatedPalette(ObjPtr, ObjPtr, real);
void BlueToRedPalette(ObjPtr);
void GreenToRedPalette(ObjPtr);
int ClosestUIColor(float clr[3]);
ObjPtr NewColorBar(int, int, int, int, char *);
void ActivateColorWheel(ObjPtr, Bool);
real GetColorValue(ObjPtr, int);
ObjPtr SetFunctionBox(ObjPtr, ObjPtr);
ObjPtr SetColorBarColor(ObjPtr, int, int, int, int);
void LogColorChange(ObjPtr, short3 *colors, int);
ObjPtr ImposeColorFunction(ObjPtr);
void DoNumberError(void);
void DoRangeError(void);
void CalcGoodSteps(double, int, int, double *majorWidth, int *nMinorSteps);
void CopyColorsToPalette(ObjPtr, short3 *);
ObjPtr NewPaletteDisplay(int, int, int, int, char *name, ObjPtr palette);
void SetObjectColor(ObjPtr);
ObjPtr ChangeTextColorWheel(ObjPtr);
ObjPtr ChangeTextColorSlider(ObjPtr);
ObjPtr ChangeBackgroundColorWheel(ObjPtr);
ObjPtr ChangeBackgroundColorSlider(ObjPtr);
ObjPtr ChangeNoBackground(ObjPtr);
#else
void InitColors();
void SetUIColor();
ObjPtr NewPalette();
void DisposePalette();
void InterpPalette();
ObjPtr ClonePalette();
ObjPtr NewColorWheel();
void HSV2RGB();
void RGB2HSV();
void SetPalette();
void SetPaletteMinMax();
void CopyPalette();
void CopyAttenuatedPalette();
void BlueToRedPalette();
void GreenToRedPalette();
int ClosestUIColor();
ObjPtr NewColorBar();
void ActivateColorWheel();
real GetColorValue();
ObjPtr SetFunctionBox();
ObjPtr SetColorBarColor();
void LogColorChange();
ObjPtr ImposeColorFunction();
void DoNumberError();
void DoRangeError();
void CalcGoodSteps();
void CopyColorsToPalette();
ObjPtr NewPaletteDisplay();
void SetObjectColor();
ObjPtr ChangeTextColorWheel();
ObjPtr ChangeTextColorSlider();
ObjPtr ChangeBackgroundColorWheel();
ObjPtr ChangeBackgroundColorSlider();
ObjPtr ChangeNoBackground();
#endif
