/*ScianSpaces.h
  Public stuff for ScianSpace.c
*/

extern Matrix Identity;

extern ObjPtr curSpace, spaceClass, observerClass;
extern real spaceTime;			/*Time of the current space*/
extern ObjPtr controllerClass, spacePanelClass, spaceBackPanelClass;
extern Bool oneObserver, oneClock, oneLights, oneRenderer;
extern Bool drawingTransparent;
extern long curZMin, curZMax;
extern ObjPtr spacePickedObject;

/*Is space predicate*/
#define IsSpace(object) IntVarEql(object, CLASSID, CLASS_SPACE)

/*Values for drawing*/
#define DRAWSPACE	1		/*Drawing in a space*/
#define PICKSPACE	2		/*Picking in a space*/
#define OVERDRAWSPACE	3		/*Over draw a space*/

/*Running controls*/
#define RC_FAST_REVERSE	4		/*Fast reverse*/
#define RC_REVERSE	2		/*Reverse*/
#define RC_STOP		0		/*Stop*/
#define RC_FORWARD	1		/*Forward*/
#define RC_FAST_FORWARD	3		/*Fast forward*/

/*Values for whichview*/
#define VIEW_CENTER	1		/*Draw from center*/
#define VIEW_XLEFT	2		/*Crosseyed left*/
#define VIEW_XRIGHT	3		/*Crosseyed right*/
#define VIEW_RCLEFT	4		/*Red/scian left*/
#define VIEW_RCRIGHT	5		/*Red/scian right*/
#define VIEW_ORTHO	6		/*Orthographic center view*/
#define VIEW_CLEFT	7		/*Crystal eyes left*/
#define VIEW_CRIGHT	8		/*Crystal eyes right*/

/*Values for renderer type, 0 through whatever*/
#define RT_NONE		0		/*No renderer*/
#define RT_RGB_HARDWARE	1		/*RGB hardware renderer*/
#define RT_CMAP_HARDWARE 2		/*Color map hardware renderer*/

/*Valued for filter type, 0 through whatever*/
#define FT_NONE		0		/*No filter*/
#define FT_SHRINK	1		/*Shrink filter*/
#define FT_4AVERAGE	2		/*Average 4 neighbors*/		

/*Values for view type*/
#define VT_PERSPECTIVE	0		/*Perspective view*/
#define VT_ORTHOGRAPHIC	1		/*Orthographic view*/
#define VT_CROSSEYED	2		/*Crosseyed stereo*/
#define VT_REDCYAN	3		/*Red/Cyan stereo*/
#define VT_LEFTONTOP	4		/*Left eye on top*/
#define VT_WALLEYED	5		/*Wall-eyed stereo*/

/*Values for space tool.*/
#define ST_FINGER	0		/*Finger.*/
#define ST_FLYING	1		/*Flying tool*/
#define ST_METER	3		/*Data meter*/
#define ST_EYEDROPPER	4		/*Eye dropper tool*/
#define ST_ANNOTATION	5		/*Annotation*/
#define ST_RECTANGLE	6		/*Rectangle*/
#define ST_LINE		7		/*Line*/
#define ST_TIME_READOUT	8		/*Clock*/

#define AIRSPEEDFACTOR	0.005		/*Airspeed of eye per throttle stop*/
#define MAXROLL		(M_PI / 10.0)	/*Pi/10 of roll max*/
#define MAXDPITCH	0.1		/*Maximum delta percentage pitch*/
#define ROLLYAWFACTOR	1.0		/*Roll into yaw per unit time*/
#define ROLLDSPFACTOR	(900.0 / M_PI)
#define MOVEFACTOR	0.35		/*Move per D unit * distance*/

/*Predicates*/
#define IsController(object) GetPredicate(object, CONTROLLERP)
#define IsObserver(object) IntVarEql(object, CLASSID, CLASS_OBSERVER)
#define IsClock(object) IntVarEql(object, CLASSID, CLASS_CLOCK)
#define IsRenderer(object) IntVarEql(object, CLASSID, CLASS_RENDERER)

extern int qualityDrawnSoFar;		/*Max quality drawn so far*/
extern int minDrawingQuality;		/*Minimum quality to draw*/
extern int maxDrawingQuality;		/*Maximum quality to draw*/

void ChangeClockForDataset();

#ifdef PROTO
ObjPtr NewSpace(int, int, int, int);
Bool AddObjToSpace(ObjPtr, ObjPtr, ObjPtr, ObjPtr, ObjPtr);
Bool AddControllerToSpace(ObjPtr, ObjPtr, ObjPtr, ObjPtr);
Bool SetFocus(ObjPtr);
ObjPtr NewClock(void);
ObjPtr NewObserver(void);
ObjPtr NewRenderer(void);
void SetClock(ObjPtr, real);
void ReinitController(ObjPtr);
ObjPtr ShowIconControls(ObjPtr);
ObjPtr MakeClockDatasets(ObjPtr);
void MatrixToQuaternion(real m[3][3], Quaternion q);
void QMult(Quaternion q1, Quaternion q2, Quaternion r);
void PrintClock(char *, char *, real);
void GetSliderRange(ObjPtr slider, real *loValue, real *hiValue);
void SetRotationMotor(real, real, real, real);
Bool RotateObserver(ObjPtr, real axis[3], real, Bool);
Bool RotateLights(ObjPtr, real axis[3], real, Bool, ObjPtr, ObjPtr);
void GetUpVector(real upVector[3], ObjPtr observer);
void GetForwardVector(real forwardVector[3], ObjPtr observer);
void GetFocusPoint(real forwardVector[3], ObjPtr observer);
void GetObserverLocation(real location[3], ObjPtr observer);
void GetAdjustedVectors(real forwardVector[3], real upVector[3], ObjPtr observer);
void StartSpace(ObjPtr space, int left, int right, int bottom, int top,
	int action, int whichView);
void StopSpace(int);
ObjPtr MoveSpace(ObjPtr object, int x, int y, long flags);
ObjPtr RotateSpace(ObjPtr object, int x, int y, long flags);
void QRot(real v[3], Quaternion q, real r[3]);
void RotToQuaternion(real axis[3], real amount, Quaternion r);
#else
ObjPtr NewSpace();
Bool AddObjToSpace();
Bool SetFocus();
Bool AddControllerToSpace();
ObjPtr NewClock();
ObjPtr NewObserver();
ObjPtr NewRenderer();
void SetClock();
void ReinitController();
ObjPtr ShowIconControls();
ObjPtr MakeClockDatasets();
void MatrixToQuaternion();
void QMult();
void PrintClock();
void GetSliderRange();
void SetRotationMotor();
Bool RotateObserver();
Bool RotateLights();
void GetUpVector();
void GetForwardVector();
void GetFocusPoint();
void GetObserverLocation();
void GetAdjustedVectors();
void StartSpace();
void StopSpace();
ObjPtr MoveSpace();
ObjPtr RotateSpace();
void QRot();
void RotToQuaternion();
#endif
