/*ScianDatasets.h
  Eric Pepke
  August 17, 1990
  External stuff for Datasets window
*/

extern ObjPtr data3DScalar, data2DScalar, data1DVector, data3DUnstructSurface;
extern ObjPtr dataFormClass, datasetClass, filterClass;
extern ObjPtr geometryClass;			/*Class for geometry object*/
extern ObjPtr globalDataset;

extern ObjPtr iconDataset;
extern ObjPtr icon1DVector, icon2DVector, icon3DVector, icon4DVector;
extern ObjPtr icon1DScalar, icon2DScalar, icon3DScalar, icon4DScalar;

extern Bool onePalette;

/*Is dataset predicate*/
#define IsDataset(object) IntVarEql(object, CLASSID, CLASS_DATASET)


/*Flags for dataset info*/
#define DS_HASFORM		1	/*Dataset has a dataform*/
#define DS_HASFIELD		2	/*Dataset has a field*/
#define DS_HASGEOMETRY		4	/*Dataset has geometry*/
#define DS_UNSTRUCTURED		8	/*The data form is unstructured*/
#define DS_TIMEDEPENDENT	16	/*Dataset is time-dependent*/
#define DS_VECTOR		32	/*Field is a vector field, not scalar*/
#define DS_HASNEWGEOMETRY	64	/*Has new geometry*/

#define FORMFIELD		0	/*Default number for a data form dataset*/
#define FIELD1			1
#define FIELD2			2
#define FIELD3			3
#define FIELD4			4
#define DEFORMFIELD		5	/*Field for deformation*/
#define DEFORMFORM		6	/*Form for deformation*/
#define FIELD5			7
#define MAXNCURFIELDS		9	/*Maximum number of current fields*/

/*Component flags*/
#define CF_MONOTONIC		1	/*Component is monotonic*/
#define CF_NOTMONOTONIC		2	/*Component is not monotonic*/

#define MAXBUCKETSIZE		10000	/*Maximum size of bucket array*/
#define BUCKETSIZEFACTOR	1	/*Factor of bucket size vs. data size*/
#define ADDBUCKETS		5	/*Number of buckets to add when needed*/

typedef real TwoReals[2];

typedef struct
    {
	int nIndices;		/*Number of sets of indices*/
	long *indices;		/*Pointer to array of indices*/
	real *samples;		/*Sample at a given index*/
    } Bucket;

typedef struct
    {
	union
	{
	    real *unComp;	/*Pointer to uncompressed data*/
	    unsigned char *comp;/*Pointer to compressed data*/
	} data;

	Bool dataCompressed;	/*True iff data is compressed*/
	real cTable[256];	/*Compression table*/
	long dataSize;		/*Length of data, used for comparison*/
	int nIndices;		/*Number of topological indices*/
	int *indices;		/*Numbers of the indices required*/
	long *dimensions;	/*Dimensions of the component*/
	long *steps;		/*Steps into the indices*/
	int flags;		/*Flags for the component*/
    } Component;

typedef struct
    {
	int topDim;		/*Topological dimension of this field*/
	int nComponents;	/*Number of components of this field*/
	Component *components;	/*Components in the field*/
	ObjPtr fieldObj;	/*Field obj for quick comparison later*/
	Bool idiotFlag;		/*Idiot flag for quick access of plain datasets*/
	int nBucketIndices;	/*# of indices per bucket, raw (not indirect)*/
	long *bucketDim;	/*The size of each bucket dimension.  0 == missing dimension!*/
	TwoReals *bucketMinMax;	/*The array of min and max values for each component*/
	Bucket *buckets;	/*Buckets for backward search, as many dims as nComponents*/
	Bool substMissing;	/*Substitute missing data*/
	real missingVal;	/*Value to subsitute for missing data*/
	Bool groupInterp;	/*True iff this is group interpolation*/
	real weight; 		/*Weight of this sample, if we need to interp*/
	ObjPtr objectInfo;	/*Other info in object form*/
    } DatasetBuffer;

extern Bool timedDatasets;	/*Flag for timed datasets*/
extern DatasetBuffer curFields[MAXNCURFIELDS * 2];

#define SELECTFIELDCOMPONENT(whichField, whichComponent, indices)	\
    (curFields[whichField] . idiotFlag ?				\
	curFields[whichField] . components[whichComponent] . data . unComp[*(indices)] :\
	SelectFieldComponent(whichField, whichComponent, indices))

ObjPtr VisualizeDatasetAs();

#define NewStructuredDataset(a, b, c, d) NewDataset(a, b, c, d)

#ifdef PROTO
ObjPtr NewGeometryDataset(char *name);
WinInfoPtr NewDatasetsWindow(void);
void InitDataSets(void);
void KillDataSets(void);
Bool RegisterComponent(int, int, ObjPtr);
real GetClosest3Sample(real x, real y, real z);
Bool RegisterDataset(ObjPtr);
Bool RegisterNewDataset(ObjPtr dataset);
int GetTopDim(ObjPtr);
long GetDatasetInfo(ObjPtr);
int GetSpatialDim(ObjPtr);
ObjPtr GetDatasetKEdges(ObjPtr, int);
ObjPtr GetDatasetFormBounds(ObjPtr);
ObjPtr GetDatasetFormDims(ObjPtr);
void ReportFileFormatError(void);
WinInfoPtr DatasetsWindow(void);
Bool SetCurField(int, ObjPtr);
Bool SetCurForm(int, ObjPtr);
real SelectFieldComponent(int, int, long *);
real SelectFieldScalar(int, long *);
real InterpolateFieldComponent(int, int, real *);
real InterpolateFieldScalar(int, real *);
long GetComponentOffset(int, int, long indices[]);
void PutFieldComponent(int, int, long *, real);
void PutCompressedFieldComponent(int, int, long *, unsigned char);
void StuffIJPlane(real *dest, int whichField, int whichComponent, long indices[]);
void DatasetChanged(ObjPtr);
int GetNComponents(int);
int CountComponentDims(int, int);
long *GetComponentDims(int, int);
Bool FindClosestSample(int, int, long indices[], int, real sample[]);
Bool SampleToTopIndex(int, int, real indices[], int, real sample[]);
Bool SampleSpatComponent(int, int, int, real resultComp[], int, real spatIndices[], Bool);
real SampleSpatScalar(int, int, int, real spatIndices[], Bool);
ObjPtr GetLongName(ObjPtr);
ObjPtr NewDataset(char *name, int rank, long *dims, int nComponents);
ObjPtr NewCompressedDataset(char *name, int rank, long *dims, int nComponents, real cTable[256]);
ObjPtr NewSeparableDataForm(char *name, int rank, long *dims, real *scales[]);
void SetDatasetForm(ObjPtr dataset, ObjPtr dataForm);
void SetDatasetPalette(ObjPtr dataset, ObjPtr palette);
ObjPtr NewRegularDataForm(char *name, int rank, long *dims, real *bounds);
int MaxComponentIndices(int, int);
ObjPtr NewCurvilinearDataForm(char *name, int rank, long *dims, real *bounds, ObjPtr dataset);
ObjPtr NewUnstructuredDataForm(char *name, int rank, long *dims, real *bounds, ObjPtr dataset);
Bool InsertDatasetTimeStep(ObjPtr masterDataset, ObjPtr timeSlice, real tm);
Bool RegisterTimeDataset(ObjPtr dataset, real tm);
void SetDatasetTimeFormat(ObjPtr dataset, int format);
int CountTraversalDims(int whichField);
void GetTraversalDims(int whichField, long dims[]);
Bool IdenticalFields(int, int);
void SetAllDatasetTimes(real);
#else
ObjPtr NewGeometryDataset();
WinInfoPtr NewDatasetsWindow();
void InitDataSets();
void KillDataSets();
Bool RegisterComponent();
real GetClosest3Sample();
Bool RegisterDataset();
Bool RegisterNewDataset();
long GetDatasetInfo();
ObjPtr GetDatasetKEdges();
ObjPtr GetDatasetFormBounds();
ObjPtr GetDatasetFormDims();
void ReportFileFormatError();
WinInfoPtr DatasetsWindow();
Bool SetCurField();
Bool SetCurForm();
real SelectFieldComponent();
real SelectFieldScalar();
real InterpolateFieldComponent();
real InterpolateFieldScalar();
long GetComponentOffset();
void StuffScalarIJSquare();
void StuffIJPlane();
void PutFieldComponent();
void PutCompressedFieldComponent();
void DatasetChanged();
int GetNComponents();
int CountComponentDims();
long *GetComponentDims();
int GetDatasetSpatialDim();
Bool FindClosestSample();
Bool SampleSpatComponent();
real SampleSpatScalar();
ObjPtr GetLongName();
ObjPtr NewDataset();
ObjPtr NewCompressedDataset();
ObjPtr NewSeparableDataForm();
ObjPtr SetDatasetForm();
void SetDatasetPalette();
ObjPtr NewRegularDataForm();
int MaxComponentIndices();
ObjPtr NewCurvilinearDataForm();
ObjPtr NewUnstructuredDataForm();
Bool InsertDatasetTimeStep();
Bool RegisterTimeDataset();
void SetDatasetTimeFormat();
int CountTraversalDims();
void GetTraversalDims();
Bool IdenticalFields();
void SetAllDatasetTimes();
#endif
