/*ScianSciences.c
  Eric Pepke
  September 27, 1992

  Contains information on conventions and common knowledge in various sciences.
  (Right now, just Chemistry.)

  Note: I couldn't find canonical colors for atoms, so I made most of them
  up.
*/

#include "Scian.h"
#include "ScianTypes.h"
#include "ScianIDs.h"
#include "ScianLists.h"
#include "ScianArrays.h"
#include "ScianSciences.h"
#include "ScianPeriodicTable.h"
#include "ScianColors.h"
#include "ScianErrors.h"

ObjPtr unitsClass, allUnits;

#ifdef PROTO
int AtomNameToNumber(char *name)
#else
int AtomNameToNumber(name)
char *name;
#endif
/*Finds the atomic number for atom name.  Returns it or 0*/
{
    int k;
    for (k = 0; k < N_ATOMS; ++k)
    {
	if (0 == strcmp2(name, atomInfo[k] . shortName))
	{
	    return k + 1;
	}
    }
    return 0;
}

ObjPtr MakeDefaultPalette(units, min, max)
ObjPtr units;
real min, max;
/*Makes a default palette for units from min to max*/
{
    ObjPtr palette;

    palette = NewPalette(DEFPALSIZE);
    BlueToRedPalette(palette);
    SetPaletteMinMax(palette, min, max);

    return palette;
}

ObjPtr MakeAtomicPalette(units, min, max)
ObjPtr units;
real min, max;
/*Makes a default palette for units from min to max*/
{
    ObjPtr palette;

    palette = NewAtomicPalette();

    return palette;
}

#ifdef PROTO
ObjPtr UnitsNameToPalette(char *name, real min, real max)
#else
ObjPtr UnitsNameToPalette(name, min, max)
char *name;
real min, max;
#endif
/*Takes a units name and makes a palette*/
{
    ObjPtr unitsToView;
    FuncTyp method;
    ObjPtr var;

    unitsToView = unitsClass;

    if (name && *name)
    {
	ThingListPtr runner;

	/*Search through list of units for one that matches*/
	runner = LISTOF(allUnits);
	while (runner)
	{
	    var = GetVar(runner -> thing, NAME);
	    if (var)
	    {
		if (0 == strcmp2(GetString(var), name))
		{
		    unitsToView = runner -> thing;
		}
	    }
	    runner = runner -> next;
	}
    }

    method = GetMethodSurely("UnitsNameToPalette", unitsToView, UNITSPALETTE);
    if (method)
    {
	return (*method)(unitsToView, min, max);
    }
    else
    {
	return NULLOBJ;
    }
}

void InitSciences()
{
    ObjPtr unit;

    /*Initialize the units*/
    unitsClass = NewObject(NULLOBJ, 0L);
    AddToReferenceList(unitsClass);
    SetMethod(unitsClass, UNITSPALETTE, MakeDefaultPalette);

    allUnits = NewList();
    AddToReferenceList(allUnits);

    /*Make atomic number units*/
    unit = NewObject(unitsClass, 0L);
    SetVar(unit, NAME, NewString("Atomic number"));
    SetMethod(unit, UNITSPALETTE, MakeAtomicPalette);
    PrefixList(allUnits, unit);
}

void KillSciences()
{
    RemoveFromReferenceList(allUnits);
    RemoveFromReferenceList(unitsClass);
}
