#include "salem.h"

/*
 *  commands that operate on the object hierarchy
 */

int    make_object();
int    remove_object();
int    group_objects();
int    ls();
int	display_portion();
int	obj_chmod();

initialize_object_commands()
{
	register_client("mkobj",    make_object,    "mkobj object-list");
	register_client("rm",	    remove_object,  "rm [objname]");
	register_client("nuke",   	remove_object,  "nuke [objname]");
	register_client("ln",	    group_objects,  "ln members parent_object");
	register_client("ls",       ls,		    "ls [-lr] [object-list]" );
	register_client("display",  display_portion,"display percent [object-list]" );
	register_client("chmod",  obj_chmod, "chmod +flag|-flag [object-list]");
}

make_object(argc,argv)
int	argc;
char	**argv;
{
	int	i;
	if (argc < 2) ERR_RET("Usage: mkobj object-list")

	argc = argsort(argc,argv);
	for (i = 1; i < argc; i++) {
		if (get_object(argv[i]) == NULL)
			new_object(argv[i],argc,argv);
		}
}

remove_object(argc,argv)
int	argc;
char	**argv;
{
	object_t 	*obj;
	int		i, nuke = !strcmp(argv[0],"nuke");
	
	argc = argsort(argc,argv);
	if (argc <= 1) {
		if (Selected.object == NULL)	ERR_RET("no object selected")
		else	if (nuke) {
			fprintf(stderr," deleting selected object %s\n",
				Selected.object->name);
			delete_object(Selected.object);
			}
		}
	else for (i = 1; i < argc; i++) {
		obj = get_object(argv[i]);
		if (obj == NULL)
			fprintf(stderr,"no such object %s to delete\n",argv[i]);
		else {
			if (nuke) delete_object(obj);
			else {
				char		*p,buf[MAXLINE];
				object_t	*parent;
				objlink_t	*link;
				strcpy(buf,argv[i]);
				if (p = strrchr(buf,'/')) {
					*p = '\0';
					parent = get_object(buf);
				}
				else parent = World;
				link = get_link(parent,obj);
				if (link) delete_link(link);
				}
			}
		}
}

static int	Mark;

static int r_search(here,there)
object_t	*here,*there;
{
	objlink_t	*link;
	here->mark = Mark;
	if (here == there) return TRUE;
	for (link = here->child_list; link; link = link->c_next)
		if ((link->child->mark != Mark) && r_search(link->child,there))
			return TRUE;
	return FALSE;
}

static int reachable(here,there)
object_t	*here,*there;
{
	Mark++;
	return r_search(here,there);
}

group_objects(argc,argv)
int argc;
char **argv;
{
	object_t	*par,*obj;
	int		i;
	if (argc < 3) ERR_RET("Usage: ln members parentobj")

	par = get_object( argv[argc - 1], Root);
	if (par == NULL) {
		fprintf(stderr,"creating %s\n",argv[argc - 1]);
		par = new_object( argv[argc - 1], argc,argv);
		}
	for (i = 1; i < argc - 1; i++) {
		obj = get_object(argv[i]);
		if (obj == NULL) 
			fprintf(stderr,"no such object as %s\n",argv[i]);
		else {
			if (get_link(par,obj) == NULL) {
				if (reachable(obj,par))
				  fprintf(stderr,"%s reaches %s, link ignored\n",
					par->name,obj->name);
				else make_link(par,obj);
				}
			}
		}
}

#define SHORT_FORMAT	1
#define LONG_FORMAT	2

ls_obj(obj,format,reclevel,indent)
object_t	*obj;
int		format;
int		reclevel;
int		indent;
{
	int		i;
	objlink_t	*link;

	for (i = indent; i > 0; i--) putchar('\t');
	switch(format) {
		case SHORT_FORMAT: printf("%s\n",obj->name); break;
		case LONG_FORMAT: printf("%s\t%d,%d\t%s\n",
			obj->name,obj->n_vertices,obj->n_polygons,obj->creation_string);
			
		}
	if (reclevel > 1) {
		for (link = obj->child_list; link; link = link->c_next)
			ls_obj(link->child,format,reclevel -1,indent+1);
	}
}

ls(argc, argv)
int	argc;
char	**argv;
{
	int		format 		= SHORT_FORMAT;
	int		reclevel	= 1;
	int		did_something	= FALSE;
	object_t	*obj;
	objlink_t	*link;
	int		i,j;

	argc = argsort(argc,argv);
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			for (j = 1; argv[i][j]; j++) 
				switch (argv[i][j]) {
					case 'l': format = LONG_FORMAT; break;
					case 'r': reclevel = MAXINT;
						if (isdigit(argv[i][j+1])) {
							sscanf(&argv[i][++j],"%d",&reclevel);
							while (isdigit(argv[i][++j + 1]));
						}
						break;
					default: printf("-%c unknown option\n",
						argv[i][j]);
					}
			}
		}

	for (i = 1; i < argc; i++) {
		if (argv[i][0] != '-') {
			did_something = TRUE;
			obj = get_object(argv[i]);
			if (!obj) fprintf(stderr,"%s:no such object\n",argv[i]);
			else ls_obj(obj,format,reclevel,(format == SHORT_FORMAT) && (obj->child_list != NULL));
			}
		}
	if (did_something == FALSE) {
		for (link = World->child_list; link; link = link->c_next)
			ls_obj(link->child,format,reclevel,0);
		}
}

display_portion(argc,argv)
int	argc;
char	**argv;
{
	int			i;
	double		disp;
	object_t	*obj;

	if (argc < 2) ERR_RET("Usage: display percentage [objects]");
	disp = atof(argv[1]);
	if (argc > 2) for (i = 2; i < argc; i++) {
		if (obj = get_object(argv[i])) obj->displayed = disp;
		else fprintf(stderr,"can't find %s\n",argv[i]);
	}
	else World->displayed = disp;
	redraw_all_windows();
}

static struct {
	char	*name;
	long	mask;
} T[] = {
	{"label",	SL_SHOWNAME},
	{"move",	SL_MOVABLE},
	{"delete",	SL_REMOVABLE},
	{"run",		SL_RUNNABLE},
	{(char*)0,	0}
};

static obj_chmod_err(argc,argv)
int	argc;
char	**argv;
{
	int		i;
	fprintf(stderr,"Usage: %s +flag|-flag [objects]\n",argv[0]);
	fprintf(stderr,"flags are: ");
	for (i = 0; T[i].name; i++) fprintf(stderr,"%s ",T[i].name);
	fprintf(stderr,"\n");
	return 0;
}

obj_chmod(argc,argv) 
int	argc;
char	**argv;
{
	int		i,state;
	long		mask;
	object_t	*obj;

	if (argc < 2) return obj_chmod_err(argc,argv);
	if (argv[1][0] == '-') state = 0;
	else if (argv[1][0] == '+') state = 1;
	else return obj_chmod_err(argc,argv);

	for (i = 0; T[i].name && strcmp(T[i].name,argv[1]+1); i++);
	if (T[i].name == NULL) return obj_chmod_err(argc,argv);
	mask = T[i].mask;

	for (i = 2; i < argc; i++) {
		if (obj = get_object(argv[i])) {
			if (state) obj->flags |= mask;
			else obj->flags &= ~mask;
		}
		else fprintf(stderr,"can't find %s\n",argv[i]);
	}
}
