#include "Default_utils_def.h"

int make_torusknot();
int make_partial_torusknot();

int
initialize_torusknot()
{
	register_client("tknot", make_torusknot, "tknot s c r(torus) R(tube) l L [objname]");
	register_client("Ptknot", make_partial_torusknot, "Ptknot s c r(torus) R(tube) l L s e [objname]");
}

int make_torusknot(argc,argv)
int argc;
char **argv;
{
	int 		a = 1, s = 35, c = 5, l = 2, L = 3 ;
	double 		r = 2.0, R = 0.5;
	char 		tname[127];

	(void) strcpy(tname, "torusknot");
	if (argc > a) s = atoi(argv[a++]);
	if (argc > a) c = atoi(argv[a++]);
	if (argc > a) r = atof(argv[a++]);
	if (argc > a) R = atof(argv[a++]);
	if (argc > a) l = atoi(argv[a++]);
	if (argc > a) L = atoi(argv[a++]);
	if (argc > a) (void) strcpy(tname, argv[a++]);

	tknot(tname,s,c,r,R,l,L,0,s-1,argc,argv);
}

int make_partial_torusknot(argc,argv)
int argc;
char **argv;
{
	int 		a = 1, s = 35, c = 5, l = 2, L = 3, is = -1, ie = -1 ;
	double 		r = 2.0, R = 0.5;
	char 		tname[127];

	(void) strcpy(tname, "torusknot");
	if (argc > a) s = atoi(argv[a++]);
	if (argc > a) c = atoi(argv[a++]);
	if (argc > a) r = atof(argv[a++]);
	if (argc > a) R = atof(argv[a++]);
	if (argc > a) l = atoi(argv[a++]);
	if (argc > a) L = atoi(argv[a++]);
	if (argc > a) is = atoi(argv[a++]);
	if (argc > a) ie = atoi(argv[a++]);
	if (argc > a) (void) strcpy(tname, argv[a++]);

	tknot(tname,s,c,r,R,l,L,is,ie,argc,argv);
}

tknot(tname,sv,cv,r,R,l,L,is,ie,argc,argv)
char*       tname;
int sv,cv,l,L,is,ie;
double r,R;
int argc;
char **argv;
{
	int nverts,nedges,nfaces,i,j,k,iend;
	double theta1, theta2, theta1del, theta2del, twopi = 8.0 * atan(1.0);
	double xax[3], yax[3], v[3], d[3], cl1, cL1, sl1, sL1, tmp[3] ;
	int j1,i1;

	set_int(sv,&sv,7,1500,15);
	set_int(cv,&cv,3,30,5); 
	set_double(r,&r,.5,5.0,2.0);
	set_double(R,&R,.01,1.0,.25);
	set_int(l,&l,1,30,2); 
	set_int(L,&L,1,70,3); 
	set_int(is,&is,0,sv-1,0);
	set_int(ie,&ie,0,sv-1,sv-1);
	if (is > ie) ie += sv;


	iend = ie-is+1;
	nverts = cv * iend;

	if (iend != sv) iend-- ;  /* if not closed, fewer edges and faces */
	nedges = cv * iend * 3 ;
	nfaces = cv * iend * 2 ;

	sl_create_object(tname, nverts, nfaces, argc, argv);

	theta1del = twopi/((double) sv);
	theta2del = twopi/((double) cv);

	for (i = is, theta1 = is*theta1del ; i <= ie ;i++ , theta1 += theta1del){
		cl1 = cos(l*theta1); cL1 = cos(L*theta1);
		sl1 = sin(l*theta1); sL1 = sin(L*theta1);

		v[0] = sl1 * (r + cL1); v[1] = cl1 * (r + cL1); v[2] = sL1 ;

		d[0] = l*cl1*(r+cL1) - L * sl1*sL1 ; 
		d[1] = - ( l*sl1*(r+cL1) + L*cl1*sL1 ) ;
		d[2] = L*cL1 ;

		d_normalize(d);
		xax[0] = -d[1]; xax[1] = d[0]; d_normalize(xax);
		yax[0] = d[1]*xax[2] - xax[1]*d[2];
		yax[1] = d[2]*xax[0] - xax[2]*d[0];
		yax[2] = d[0]*xax[1] - xax[0]*d[1];
		d_normalize(yax);
		for (theta2 = 0.0, j = 0 ; j < cv ; j++ , theta2 += theta2del) {
			for (k = 0 ; k < 3 ; k++ ) {
				tmp[k] = xax[k]*cos(theta2) ;
				tmp[k] += yax[k]*sin(theta2);
				tmp[k] *= R;
				tmp[k] += v[k];
				}
			sl_vertex(tmp[0],tmp[1],tmp[2]);
			}
		}

	for (i = 0 ; i < iend ; i++ )	{
		i1 =  (i == (sv-1)) ? 0 : (i+1) ;
		for (j = 0 ; j < cv ; j++ )	{
			j1 = (j+1)%cv;
			sl_triangle((i*cv)+j, (i*cv)+j1, (i1*cv)+j);
			sl_triangle((i*cv)+j1, (i1*cv)+j, (i1*cv)+j1);
			}
		}
	sl_color_object();
	sl_close_object();
}

d_normalize(v)
double *v;
{
	int i;
	double t;
	t = sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2]) ;
	for (i = 0 ; i < 3 ; i++ ) v[i] /= t;
}
