#include "2D-DT_defines.h"

/****************************************************************/
/*	Sorting Routines
/*	These are pretty ugly but much faster than the system sort.
/****************************************************************/
vpsortx(low, high, lowkey, highkey)
int low, high;
double lowkey, highkey;
{
    if (((low==0) || (high==num_vertices-1)) && (high - low > 5)) {
	register int p,  pmax, pmin,t,u;
	double xmax, xmin, xp;
	pmax = pmin = p = low;
	xmax = VX(pmax); xmin = VX(pmin);

	for (p++; p<=high; p++) {
	    xp = VX(p);
	    if (xp < xmin) { xmin=xp; pmin=p;}
	    else if (xp > xmax) { xmax=xp; pmax = p;}
	}
	if (low == pmax)	{
		t = vp[high];
		vp[high] = vp[low];
		if (high == pmin) vp[low] = t;
		else	{ vp[low] = vp[pmin]; vp[pmin] = t; }
		}
	else	{
		t = vp[low];
		u = vp[high];
		vp[low] = vp[pmin];
		vp[high] = vp[pmax];
		vp[pmax] = t;
		if (high != pmin) vp[pmin] = u;
		}
		
	low++; high--;
    }
    vpsortxh(&(vp[low]), &(vp[high]), lowkey, highkey);
}

vpsortxh(lowp, highp, lowkey, highkey)
VERTEX_PTR *lowp, *highp;
double lowkey, highkey;
{
    if (highp - lowp <= 5) {
	/* Bubble Sort */
	register VERTEX_PTR *p, *q, *q1, t;
	double maxkey, qkey;
	for (p=highp; p>lowp; p--) {
	    maxkey = VX(*lowp);
	    for (q=lowp+1; q<=p; q++) {
		qkey = VX(*q);
		if (maxkey > qkey) {
		    q1 = q-1;
		    t = *q1; *q1 = *q; *q = t;
		}
		else maxkey = qkey;
	    }
	}
    }
    else {
	/* Quicksort */
	double midkey, savelowx, savehighx;
	register VERTEX_PTR *hip, *lop, t;
	midkey = (highkey + lowkey) / 2.0;
	savelowx = VX(*(lowp-1));
	VX(*(lowp-1)) = lowkey;
	savehighx = VX(*(highp+1));
	VX(*(highp+1)) = highkey;
	for (lop=lowp; VX(*lop) < midkey; lop++);
	for (hip=highp; VX(*hip) > midkey; hip--);
	while (lop < hip) {
	    t = *lop; *lop = *hip; *hip = t;
	    for (lop++; VX(*lop) < midkey; lop++);
	    for (hip--; VX(*hip) > midkey; hip--);
	}
	VX(*(lowp-1)) =  savelowx;
	VX(*(highp+1)) = savehighx;
	vpsortxh(lowp, lop-1, lowkey, midkey);
	vpsortxh(hip+1, highp, midkey, highkey);	
    }
}

vpsorty(low, high, lowkey, highkey)
int low, high;
double lowkey, highkey;
{
    if (((low==0) || (high==num_vertices-1)) && (high - low > 5)) {
	register VERTEX_PTR *p, *hi, *pmax, *pmin,t;
	double ymax, ymin, yp;
	pmax = pmin = p = &(vp[low]);
	hi = &(vp[high]);
	ymax = VY(*pmax); ymin = VY(*pmin);
	for (p++; p<=hi; p++) {
	    yp = VY(*p);
	    if (yp < ymin) { ymin=yp; pmin=p;}
	    else if (yp > ymax) { ymax=yp; pmax = p;}
	}
	t = vp[low]; vp[low] = *pmax; *pmax = t;
	if (pmin == &(vp[low])) pmin = pmax;
	low++;
	t = vp[high]; vp[high] = *pmin; *pmin = t; high--;
    }
    vpsortyh(&(vp[low]), &(vp[high]), lowkey, highkey);
}

vpsortyh(lowp, highp, lowkey, highkey)
VERTEX_PTR *lowp, *highp;
double lowkey, highkey;
{
    if (highp - lowp <= 5) {
	/* Bubble Sort */
	register VERTEX_PTR *p, *q, *q1, t;
	double minkey, qkey;
	for (p=highp; p>lowp; p--) {
	    minkey = VY(*lowp);
	    for (q=lowp+1; q<=p; q++) {
		qkey = VY(*q);
		if (minkey < qkey) {
		    q1 = q-1;
		    t = *q1; *q1 = *q; *q = t;
		}
		else minkey = qkey;
	    }
	}
    }
    else {
	/* Quicksort */
	double midkey, savelowy, savehighy;
	register VERTEX_PTR *hip, *lop, t;
	midkey = (highkey + lowkey) / 2.0;
	savelowy = VY(*(lowp-1));
	VY(*(lowp-1)) = highkey;
	savehighy = VY(*(highp+1));
	VY(*(highp+1)) = lowkey;
	for (lop=lowp; VY(*lop) > midkey; lop++);
	for (hip=highp; VY(*hip) < midkey; hip--);
	while (lop < hip) {
	    t = *lop; *lop = *hip; *hip = t;
	    for (lop++; VY(*lop) > midkey; lop++);
	    for (hip--; VY(*hip) < midkey; hip--);
	}
	VY(*(lowp-1)) =  savelowy;
	VY(*(highp+1)) = savehighy;
	vpsortyh(lowp, lop-1, midkey, highkey);	
	vpsortyh(hip+1, highp, lowkey, midkey);
    }
}

