#ident	"@(#)user_parse.c	1.1"	9/1/88

/*******************************************************************************
Copyright (C) 1988, an unpublished work of Ardent Computer Corporation
        All Rights Reserved
This program is a trade secret of Ardent Computer Corp. and it is not to be
reproduced, published, disclosed to others, copied, adapted, distributed, or
displayed without the prior authorization of Ardent Computer Corp.  Licensee
agrees to attach or embed this Notice on all copies of the program, including 
partial copies or modified versions thereof.
*******************************************************************************/

#include <dore.h>

extern DtInt debug;

/*******************************************************************************
 **************************  u s e r _ p a r s e  ******************************
 *******************************************************************************
 * Module Name: user_parse
 * Module Type: c
 *     Purpose: Give the user the first crack at parsing the string that was
 *		passed to the program from the keyboard, or as a result of 
 *		input from the mouse buttons, the dial box, or the spaceball.
 *		Anything not processed in this function will be passed on to
 *		the default parsing routine for processing.  The format of
 *		the string is either: whatever was typed in from the keyboard,
 *		or whatever is defined in the files 'data.button' & 'data.dial'.
 *   Arguments: str ==> A character string passed as input to this program.
 * ReturnValue: Set to 1 if this routine processed the string; set to 0 if 
 *		the string was not recognized and needs to be parsed by the
 *		default parsing routine.
 ******************************************************************************/
int user_parse(str)
char *str;
{
/*******************************************************************************
 * Declare variables.
 ******************************************************************************/
	char c;
	DtReal value;

/*******************************************************************************
 * The following lines are just an example of how you might want to parse a
 *  command string passed into this routine.  It assumes a command string
 *  with a format similar to "Gn 5.712" was passed in.  It gets the first 
 *  character of the string and tests to see if it is a "G".  If it is, it 
 *  checks to make sure that the second character is an "n" and then reads
 *  the floating point number that follows.  It could then call another user-
 *  written subroutine, or call Dore' routines, or whatever.
 ******************************************************************************/
	if (debug)
		printf("User_parse(%s);\n",str);

	c = *(str++);

	switch (c) {

	case 'G':  /* Parse a command string that starts with a "G" */

		c = *(str++);
		if(c != 'n') break;

		sscanf(str,"%*s %lf",&value);
		if(debug) printf("User 'Gn' value = %lf\n",value);

		return (1);
  
	}

/*******************************************************************************
 * Default return -- didn't recognize or don't care about the string -- let 
 *  the default parser try to decipher it.
 ******************************************************************************/
	return(0);

}  /* End of user_parse function */

#include <X11/Xlib.h>

extern Window dore_window;


/*******************************************************************************
 *************************  u s e r _ x e v e n t  *****************************
 *******************************************************************************
 * Module Name: user_xevent
 * Module Type: c
 *     Purpose: Give the user the first crack at parsing X window events from
 *              the Dore window, as well as allow him/her/it to parse events
 *              from X windows he/she/it may have created.
 *   Arguments: event => an X window event structure
 * ReturnValue: Set to 1 if the event was recognized and processed by this
 *              routine and no further processing is required on it.  Set to
 *              0 if the event was not recognized or processed.
 ******************************************************************************/
int user_xevent(event)
XEvent *event;
{
        if (debug) printf("in user_xevent, x,y=%d,%d\n",
                event->xbutton.x, event->xbutton.y);

        /* Handle dore_window xevents */
        if (event->xany.window == dore_window) {
                return(0);
        }

        /* Handle user-created window xevents */
        else {
                return(1);
        }
}
