/****************************************************************************
 * hfonts.h
 * Author Phil Andrews
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/

#define NO_HFONTS 19		/* no. of hershey fonts */
#define MAX_HCHARS 128		/* max. no. of characters in a font */
/* first the font names */
static char *h_names[NO_HFONTS] = {
"HERSHEY:CARTOGRAPHIC_GREEK",
"HERSHEY:CARTOGRAPHIC_ROMAN",
"HERSHEY:COMPLEX_CYRILLIC",
"HERSHEY:COMPLEX_GREEK",
"HERSHEY:COMPLEX_ITALIC",
"HERSHEY:COMPLEX_ROMAN",
"HERSHEY:COMPLEX_SCRIPT",
"HERSHEY:DUPLEX_ROMAN",
"HERSHEY:GOTHIC_ENGLISH",
"HERSHEY:GOTHIC_GERMAN",
"HERSHEY:GOTHIC_ITALIAN",
"HERSHEY:MATH_SYMBOLS",
"HERSHEY:SIMPLEX_GREEK",
"HERSHEY:SIMPLEX_ROMAN",
"HERSHEY:SIMPLEX_SCRIPT",
"HERSHEY:SYMBOL_SET1",
"HERSHEY:SYMBOL_SET2",
"HERSHEY:TRIPLEX_ITALIC",
"HERSHEY:TRIPLEX_ROMAN"};
/* now the pointers into the index block */
static int h_ptrs[NO_HFONTS][MAX_HCHARS] = { 
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,   199,   214,   217,   233,   219,     0,   234,   216,
    221,   222,   228,   225,   211,   224,   210,   220,   200,   201,
    202,   203,   204,   205,   206,   207,   208,   209,   212,   213,
    229,   226,     0,   215,     0,    27,    28,    48,    30,    31,
     47,    29,    33,    35,     0,    36,    37,    38,    39,    41,
     42,    34,    43,    44,    45,    46,     0,    50,    40,    49,
     32,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,   223,     0,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,   199,   214,   217,   233,   219,     0,   234,   216,
    221,   222,   228,   225,   211,   224,   210,   220,   200,   201,
    202,   203,   204,   205,   206,   207,   208,   209,   212,   213,
    229,   226,     0,   215,     0,     1,     2,     3,     4,     5,
      6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
     16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
     26,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,   223,     0,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  2199,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,  2200,  2201,
   2202,  2203,  2204,  2205,  2206,  2207,  2208,  2209,     0,     0,
      0,  2810,  2910,  2827,  2927,  2801,  2802,  2803,  2804,  2805,
   2806,  2807,  2808,  2809,  2811,  2812,  2813,  2814,  2815,  2816,
   2817,  2818,  2819,  2820,  2821,  2822,  2823,  2824,  2825,  2826,
   2828,  2829,  2830,  2831,  2832,     0,     0,  2901,  2902,  2903,
   2904,  2905,  2906,  2907,  2908,  2909,  2911,  2912,  2913,  2914,
   2915,  2916,  2917,  2918,  2919,  2920,  2921,  2922,  2923,  2924,
   2925,  2926,  2928,  2929,  2930,  2931,  2932,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  2199,  2214,  2217,  2275,  2274,  2271,  2272,  2216,
   2221,  2222,  2219,  2232,  2211,  2231,  2210,  2220,  2200,  2201,
   2202,  2203,  2204,  2205,  2206,  2207,  2208,  2209,  2212,  2213,
   2241,  2238,  2242,  2215,     0,  2027,  2028,  2048,  2030,  2031,
   2047,  2029,  2033,  2035,  2134,  2036,  2037,  2038,  2039,  2041,
   2042,  2034,  2043,  2044,  2045,  2046,  2187,  2050,  2040,  2049,
   2032,  2223,   804,  2224,  2247,     0,  2249,  2127,  2128,  2148,
   2130,  2131,  2186,  2129,  2133,  2135,  2147,  2136,  2137,  2138,
   2139,  2141,  2142,  2185,  2143,  2144,  2145,  2146,  2184,  2150,
   2140,  2149,  2132,  2225,   803,  2226,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  2749,  2764,  2778,     0,  2769,     0,  2768,  2777,
   2771,  2772,  2773,  2775,  2711,  2774,  2760,  2770,  2750,  2751,
   2752,  2753,  2754,  2755,  2756,  2757,  2758,  2759,  2762,  2763,
      0,  2776,     0,  2765,     0,  2051,  2052,  2053,  2054,  2055,
   2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,  2065,
   2066,  2067,  2068,  2069,  2070,  2071,  2072,  2073,  2074,  2075,
   2076,     0,     0,     0,     0,     0,     0,  2151,  2152,  2153,
   2154,  2155,  2156,  2157,  2158,  2159,  2160,  2161,  2162,  2163,
   2164,  2165,  2166,  2167,  2168,  2169,  2170,  2171,  2172,  2173,
   2174,  2175,  2176,     0,     0,     0,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  2199,  2214,  2217,  2275,  2274,  2271,  2272,  2216,
   2221,  2222,  2219,  2232,  2211,  2231,  2210,  2220,  2200,  2201,
   2202,  2203,  2204,  2205,  2206,  2207,  2208,  2209,  2212,  2213,
   2241,  2238,  2242,  2215,     0,  2001,  2002,  2003,  2004,  2005,
   2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,  2015,
   2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,  2024,  2025,
   2026,  2223,   804,  2224,  2247,     0,  2249,  2101,  2102,  2103,
   2104,  2105,  2106,  2107,  2108,  2109,  2110,  2111,  2112,  2113,
   2114,  2115,  2116,  2117,  2118,  2119,  2120,  2121,  2122,  2123,
   2124,  2125,  2126,  2225,  2229,  2226,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  2749,  2764,  2778,     0,  2769,     0,  2768,  2777,
   2771,  2772,  2773,  2775,  2761,  2774,  2760,  2770,  2750,  2751,
   2752,  2753,  2754,  2755,  2756,  2757,  2758,  2759,  2762,  2763,
      0,  2776,     0,  2765,     0,  2551,  2552,  2553,  2554,  2555,
   2556,  2557,  2558,  2559,  2560,  2561,  2562,  2563,  2564,  2565,
   2566,  2567,  2568,  2569,  2570,  2571,  2572,  2573,  2574,  2575,
   2576,     0,     0,     0,     0,     0,     0,  2651,  2652,  2653,
   2654,  2655,  2656,  2657,  2658,  2659,  2660,  2661,  2662,  2663,
   2664,  2665,  2666,  2667,  2668,  2669,  2670,  2671,  2672,  2673,
   2674,  2675,  2676,     0,     0,     0,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  2699,  2714,  2728,     0,  2719,     0,  2718,  2727,
   2721,  2722,  2723,  2725,  2711,  2724,  2710,  2720,  2700,  2701,
   2702,  2703,  2704,  2705,  2706,  2707,  2708,  2709,  2712,  2713,
      0,  2726,     0,  2715,     0,  2501,  2502,  2503,  2504,  2505,
   2506,  2507,  2508,  2509,  2510,  2511,  2512,  2513,  2514,  2515,
   2516,  2517,  2518,  2519,  2520,  2521,  2522,  2523,  2524,  2525,
   2526,     0,     0,     0,     0,     0,     0,  2601,  2602,  2603,
   2604,  2605,  2606,  2607,  2608,  2609,  2610,  2611,  2612,  2613,
   2614,  2615,  2616,  2617,  2618,  2619,  2620,  2621,  2622,  2623,
   2624,  2625,  2626,     0,     0,     0,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  3699,  3714,  3728,     0,  3719,     0,  3718,  3727,
   3721,  3722,  3723,  3725,  3711,  3724,  3710,  3720,  3700,  3701,
   3702,  3703,  3704,  3705,  3706,  3707,  3708,  3709,  3712,  3713,
      0,  3726,     0,  3715,     0,  3501,  3502,  3503,  3504,  3505,
   3506,  3507,  3508,  3509,  3510,  3511,  3512,  3513,  3514,  3515,
   3516,  3517,  3518,  3519,  3520,  3521,  3522,  3523,  3524,  3525,
   3526,     0,     0,     0,     0,     0,     0,  3601,  3602,  3603,
   3604,  3605,  3606,  3607,  3608,  3609,  3610,  3611,  3612,  3613,
   3614,  3615,  3616,  3617,  3618,  3619,  3620,  3621,  3622,  3623,
   3624,  3625,  3626,     0,     0,     0,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  3199,  3214,  3228,     0,  3219,     0,  3218,  3227,
   3221,  3222,  3223,  3225,  3211,  3224,  3210,  3220,  3200,  3201,
   3202,  3203,  3204,  3205,  3206,  3207,  3208,  3209,  3212,  3213,
      0,  3226,     0,  3215,     0,  3301,  3302,  3303,  3304,  3305,
   3306,  3307,  3308,  3309,  3310,  3311,  3312,  3313,  3314,  3315,
   3316,  3317,  3318,  3319,  3320,  3321,  3322,  3323,  3324,  3325,
   3326,     0,     0,     0,     0,     0,     0,  3401,  3402,  3403,
   3404,  3405,  3406,  3407,  3408,  3409,  3410,  3411,  3412,  3413,
   3414,  3415,  3416,  3417,  3418,  3419,  3420,  3421,  3422,  3423,
   3424,  3425,  3426,  3427,  3428,  3429,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  3199,  3214,  3228,     0,  3219,     0,  3218,  3227,
   3221,  3222,  3223,  3225,  3211,  3224,  3210,  3220,  3200,  3201,
   3202,  3203,  3204,  3205,  3206,  3207,  3208,  3209,  3212,  3213,
      0,  3226,     0,  3215,     0,  3801,  3802,  3803,  3804,  3805,
   3806,  3807,  3808,  3809,  3810,  3811,  3812,  3813,  3814,  3815,
   3816,  3817,  3818,  3819,  3820,  3821,  3822,  3823,  3824,  3825,
   3826,     0,     0,     0,     0,     0,     0,  3901,  3902,  3903,
   3904,  3905,  3906,  3907,  3908,  3909,  3900,  3911,  3912,  3913,
   3914,  3915,  3916,  3917,  3918,  3919,  3920,  3921,  3922,  3923,
   3924,  3925,  3926,     0,     0,     0,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  2199,  2214,  2217,  2275,  1402,  2271,  2272,  2216,
   2221,  2222,  2219,  2232,  2211,  2231,  2210,  2220,   700,   701,
    702,   703,   704,   705,   706,   707,   708,   709,  2212,  2213,
   2241,  2238,  2242,  2215,  2273,   738,   739,   740,   751,   798,
    799,   847,   850,  2218,   797,  2243,  2244,  2277,  2278,  2227,
   2228,  2229,  2230,  2233,  2234,  2235,  2236,  2237,  2239,  2240,
   2281,  2223,   804,  2224,  2247,  2279,  2249,  2245,  2246,  2248,
   2250,  2251,  2252,  2253,  2254,  2255,  2256,  2257,  2258,  2259,
   2260,  2261,  2262,  2263,  2264,  2265,  2266,  2267,  2268,  2269,
   2270,  1401,  2276,  2225,  2229,  2226,   765,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,   699,   714,   717,  2275,   719,  2271,   734,   716,
    721,   722,   728,   725,   711,   724,   710,   720,   700,   701,
    702,   703,   704,   705,   706,   707,   708,   709,   712,   713,
   2241,   726,  2242,   715,     0,   527,   528,   548,   530,   531,
    547,   529,   533,   535,   634,   536,   537,   538,   539,   541,
    542,   534,   543,   544,   545,   546,   687,   550,   540,   549,
    532,     0,   804,     0,   832,     0,  2249,   627,   628,   648,
    630,   631,   686,   629,   633,   635,   647,   636,   637,   638,
    639,   641,   642,   685,   643,   644,   645,   646,   684,   650,
    640,   649,   632,     0,   723,     0,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,   699,   714,   717,   733,   719,  2271,   734,   716,
    721,   722,   728,   725,   711,   724,   710,   720,   700,   701,
    702,   703,   704,   705,   706,   707,   708,   709,   712,   713,
   2241,   726,  2242,   715,     0,   501,   502,   503,   504,   505,
    506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
    516,   517,   518,   519,   520,   521,   522,   523,   524,   525,
    526,     0,   804,     0,   832,     0,  2249,   601,   602,   603,
    604,   605,   606,   607,   608,   609,   610,   611,   612,   613,
    614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    624,   625,   626,     0,   723,     0,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,   699,   714,   717,  2275,   719,     0,   734,   716,
    721,   722,   728,   725,   711,   724,   710,   720,   700,   701,
    702,   703,   704,   705,   706,   707,   708,   709,   712,   713,
   2241,   726,  2242,   715,     0,   551,   552,   553,   554,   555,
    556,   557,   558,   559,   560,   561,   562,   563,   564,   565,
    566,   567,   568,   569,   570,   571,   572,   573,   574,   575,
    576,     0,   804,     0,   832,     0,  2249,   651,   652,   653,
    654,   655,   656,   657,   658,   659,   660,   661,   662,   663,
    664,   665,   666,   667,   668,   669,   670,   671,   672,   673,
    674,   675,   676,     0,   723,     0,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  2199,   235,   583,   735,   741,   742,   743,   744,
    745,   746,   753,   754,   755,   756,   757,   758,   759,   760,
    761,   762,   763,   764,   765,   767,   768,   796,   800,   801,
    802,   803,   804,   805,   806,   807,   808,   809,   810,   811,
    812,   813,   814,   817,   818,   819,   820,   821,   822,   823,
    824,   825,   826,   827,   829,   830,   831,   833,   834,   840,
    841,   842,   843,   844,   851,   852,   853,   854,   855,   856,
    857,   860,   861,   862,   863,   864,   865,   866,   867,   868,
    869,   870,   871,   872,   873,   874,   899,   900,   901,   902,
    903,   904,   905,   906,   908,   909,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  2177,  2178,  2179,  2180,  2181,  2182,  2190,  2191,
   2192,  2193,  2194,  2195,  2196,  2282,  2283,  2284,  2285,  2286,
   2287,  2288,  2289,  2290,  2291,  2292,  2293,  2294,  2295,  2301,  
   2302,  2303,  2304,  2305,  2306,  2307,  2308,  2309,  2310,  2311,
   2312,  2317,  2318,  2319,  2320,  2321,  2322,  2323,  2324,  2325, 
   2326,  2327,  2328,  2329,  2330,  2331,  2332,  2367,  2368,  2369,
   2370,  2371,  2372,  2373,  2374,  2375,  2376,  2377,  2382,  2379,
   2381,  2378,  2401,  2402,  2716,  2717,  2729,  2780,  3266,  3267,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  3249,  3264,  3278,     0,  3269,     0,  3268,  3277,
   3271,  3272,  3273,  3275,  3261,  3274,  3260,  3270,  3250,  3251,
   3252,  3253,  3254,  3255,  3256,  3257,  3258,  3259,  3262,  3263,
      0,  3276,     0,  3265,     0,  3051,  3052,  3053,  3054,  3055,
   3056,  3057,  3058,  3059,  3060,  3061,  3062,  3063,  3064,  3065,
   3066,  3067,  3068,  3069,  3070,  3071,  3072,  3073,  3074,  3075,
   3076,     0,     0,     0,     0,     0,     0,  3151,  3152,  3153,
   3154,  3155,  3156,  3157,  3158,  3159,  3160,  3161,  3162,  3163,
   3164,  3165,  3166,  3167,  3168,  3169,  3170,  3171,  3172,  3173,
   3174,  3175,  3176,     0,     0,     0,     0,     0},
{
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,  3199,  3214,  3228,     0,  3219,     0,  3218,  3227,
   3221,  3222,  3223,  3225,  3211,  3224,  3210,  3220,  3200,  3201,
   3202,  3203,  3204,  3205,  3206,  3207,  3208,  3209,  3212,  3213,
      0,  3226,     0,  3215,     0,  3001,  3002,  3003,  3004,  3005,
   3006,  3007,  3008,  3009,  3010,  3011,  3012,  3013,  3014,  3015,
   3016,  3017,  3018,  3019,  3020,  3021,  3022,  3023,  3024,  3025,
   3026,     0,     0,     0,     0,     0,     0,  3101,  3102,  3103,
   3104,  3105,  3106,  3107,  3108,  3109,  3110,  3111,  3112,  3113,
   3114,  3115,  3116,  3117,  3118,  3119,  3120,  3121,  3122,  3123,
   3124,  3125,  3126,     0,     0,     0,     0,     0}
};
