.TH MOVIETOP3D L "7/11/89" "release 1.0"
.SH NAME
movietop3d takes MOVIE.BYU data and emits a P3D metafile containing the same 
information.
.SH SYNOPSIS
.nf
.B "movietop3d [-p parts] [-d displacements] [-m disp_mult]" 
.B "[-c c_table] [-s scalar min max] model.geo"
.fi

.SH DESCRIPTION
MOVIE.BYU is a graphics package developed at Brigham Young University.  It 
takes its input from one to three files - a geometrty file, an optional
displacement file, and an optional scalar file.   The geometry file provides 
the basic shape of the model, the displacement file provides data for 
displacements of that model, and the scalar file provides data for coloring 
vertices of the model.  MOVIE.BYU uses these files to draw a picture of the 
model.  

P3D is the model description language used by the Pittsburgh Supercomputing 
Center.  MOVIETOP3D provides a way of taking MOVIE.BYU data and using it for 
P3D.  Calling movietop3d with MOVIE.BYU data (and other optional data) causes a 
P3D metafile to be written to standard output.  This output can be used to
create 3D images of the model.

Model.geo is the main MOVIE.BYU geometry file, in standard
MOVIE.BYU format.  If a single minus (-)
is given rather than a filename, this data will be taken from 
the standard input.

The following is a brief description of all options:
.TP 8 
.B \-p parts	   
Parts is a file containing color information for the parts of the model.
.TP
.B \-d displacements    
Displacements is a file containing displacement 
information for the model.  Displacements are 
inputted a factor of 10 larger than they will be 
emitted, following MOVIE.BYU format.
.TP
.B \-m disp_mult	    
Disp_mult is a floating point number by which all
displacements are multiplied.  If no multiplying
factor is given, default is 1.0, so no additional 
adjustments are made, and displacements are
emitted at one tenth the size they are entered.
.TP     
.B \-c c_table
C_table is a table of numbers and associated
color values, to be used with the scalar table.
.TP
.B \-s scalar min max	    
Scalar is a table of numbers, one for each vertex
of the model.  These numbers are associated with
colors using the color table, and thus each vertex
is associated with a color.

Min and max are two numbers (floating point or integer)
separated by a space, representing the lower and
upper bounds for scalars, which will map onto the  
lowest and highest entries in the color table.  All
scalars in the scalar file must be within this
range, and will be matched to an appropriate 
color table value by interpolation.	  

.SH FILE DESCRIPTIONS

The 
.I parts 
file will contain data for the color of each part.  It
consists of one information line for each part, in order.  A line
consists of 3 or 4 floating point numbers between 0.0 and 1.0.  The
first number specifies the red coloring, the second specifies green, 
the third specifies blue, and the last (optional) specifies 
opacity (the default value is 1.0).  If no color is desired for a part, the word
NULL (without quotes) should appear on the line corresponding to that part.  
No lines should be left blank.  There should be
exactly as many lines as there are parts in the model.

The 
.I displacement 
file will contain data for the displacement of 
each vertex.  It consists of 
a list of floating point numbers, three for each vertex.  Each group of
three numbers is associated with a vertex, in order.  The numbers may be 
separated by a space or be on separate lines.  The first in each set of three
represents the displacement in the x- direction, the second in the y-
direction, and the third in the z- direction.  These entries should be
10 times larger than the desired displacement, in accordance with 
standard MOVIE.BYU input.  If no displacement is desired for a vertex,
three zeros should be entered for the numbers corresponding to that vertex.
There should be exactly three times as many numbers
as there are vertices in the model.

The 
.I c_table 
file will contain information from which a color table will be 
made.  Each line in the c_table file consists of an integer followed by
three or four floats.  The integer represents the index of the color
table, and the following three or four floats represent the color to be 
associated with that index, as described above for the parts file (red, green, 
blue, and optional opacity).  All indices must lie between 0 and 255 
inclusive, since they will be used to index an array of size 256.  Although 
they need not be inputted in order, they must result in a continous list
between the lowest and highest index.  Gaps between entries in the color table 
will lead to errors when the scalar interpolation is done.

The 
.I scalar 
file is a list of floating point numbers, one for each vertex.
The scalars may be separated by a space or be on separate lines.  Each scalar 
is associated with a vertex (in order) and then a color for that vertex is 
found by interpolating the scalar and mapping it into the color table.  The 
interpolation is done using the min and max values supplied by the -s option.  
The min will map to the first (nonempty) entry in the color table, the max will map
to the last.  The position of a given scalar between the min and max
determines the position of the associated color between the lowest and
highest color of the color table, and that color is assigned to the vertex
associated with the scalar.  There should be exactly as many scalar entries 
as there are verteces in the model.

The format of the main 
.I model.geo 
file is covered extensively in
the MOVIE.BYU manual.              

.SH COPYRIGHT
Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon
University
.nf
.B "Author Julie Roskies"
.fi
