/****************************************************************************
 * colorpart.c
 * Author Julie Roskies
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/

/* Fill in colors for parts of the model, from seperate file with this info */
#include <stdio.h>
#include <ctype.h>
#include "struct_defs.h"
#include "part_defs.h"
#include "err_defs.h"

#define CMAXINP 50 	/* maximum length of color input line */

void fill_part_color (part_col_data, thismodel)
FILE *part_col_data;
Model *thismodel;
{       
	int i;
	int c;		/* tells how many items were read from string s */
	float r,g,b,a;
	Part *thispart;
        char s[CMAXINP];	/* holds a line of color input */

	ger_debug("fill_part_color:");

	/* Initializes thispart pointer to point to first part */
	thispart = thismodel->part_list;
	/* Fills up color for each part */
	for (i = 0; i<thismodel->part_count; i++) {
	 	fgets(s, CMAXINP, part_col_data);
		if (isalpha(s[0]))
	       		thispart++;
		else {
  	                thispart->color= create_color();
			c = sscanf (s, "%f %f %f %f", &r, &g, &b, &a);
	      		thispart->color->r= r;
			thispart->color->g= g;
	      		thispart->color->b= b;
			if (c == 4)
	      		    thispart->color->a= a;
	      		thispart++;
	      		 }
		}
}	
