drawp3d interface routines are creating P_Vlist's without destroying them.
Is this a memory management problem?

It might be a good idea to add support for the vertex types P3D_CNVVVTX,
P3D_CCVNVTX, and P3D_CVVNVTX, as long as we are allowing two values.  Also,
obj_tester currently doesn't test all the object methods for P3D_CVVVTX
vlists.

It is an error to define a GOB while a renderer is open, then shut it
down, then render the GOB.  This will probably cause a crash;  I don't
see an obvious way to prevent it (except never to really shut anything
down?)  It's even an error to free a GOB which was defined when the
renderer was open, I think.

It might be good to make p3d_ren_mthd.c do something with the transformation
and attribute list passed to ren_gob and traverse_lights.  Then again,
maybe not.

Having both pseudospectral and inverted pseudospectral is silly, since
the cmap function can invert the map.

Really should add a 'retain' method to vlists.  This might change the
destroy method of some renderers?  Maybe retain method should also be
on gobs, since several elements of meshes other than the vlist need
to get retained.  Or maybe we need an 'ilist' object?  Vlists already
have a 'retain' element.

Note that ctype info is not being saved in vlists!

There are vector-handling (and vertex-handling) utility functions
in isosurf.c which really should get merged into the general vector
(and ultimately vertex) utilities.  Note that none of these vertex
handling tools know about vertices with color (as opposed to values);
they do maintain a free list and thus have faster memory management
however.

Add access to pg_cmap_color to drawp3d interfaces, and to documents, and
add a test invocation of it to f_tester.f and c_tester.c!

Add provision for background color to the c++ interface.

Add composite routines (bounding box, axis, isosurface, zsurface) to c++ 
interface.

Add access to the material types to the c++ interface.

