SGI GL Renderer Driver
----------------------

File: sgigl_ren.c

Renderer: GL, from Silicon Graphics Inc.

Primitives:
	Intrinsic:
		polygon, polyline, polymarker, triangle strip
	Emulated:
		sphere, cylinder, torus, text, mesh, Bezier patch

Attributes: color, backcull, text-height, material

Lights: light (at infinity for dynamic renderer), ambient light

Camera handling: complete.

Auxiliary functions:  ren_free, ren_dump, ren_setup, ren_reset, ren_shutdown.
	Since traversal takes place in the lisp representation, ren_free
	is a noop.  ren_dump, ren_reset, and ren_shutdown are also noops.

Hooks:  none

Comments:
	This 'renderer' is actually an interface into the SGI GL renderer
	software.

	Traversal of both the model and lighting dags is done within the
	renderer, using the lisp representation.  No model data is saved
	within GL.

	At setup time, if the "open_device" parameter is 0, no window is
	opened (on the assumption that the UI has done so).  Otherwise
	a window is opened.  The actual device specified is ignored;
	GL always opens a window on the console screen.

	If the Lisp variable 'p3d-hints' contains an assoc list which includes
	a pair containing the symbol 'lighting-model and Nil, the GL lighting
	model facility is not used;  i.e. everything appears with its assigned
	color regardless of lighting effects.  This speeds rendering somewhat.

	Sgigl_ren.c also supports transparency, sort of.  Objects with 
	opacities less than 0.5 are drawn with a pattern fill which is
	half-on, so that objects behind them can be seen by 'screen dooring'.
	Ideally one would want to use the alpha facility of some Silicon
	Graphics workstations to support this, but there is no easy way to
	tell if the alpha planes are present by querying the hardware, so
	the 'screen door' facility is always used.

	NURBS are used to produce the Bezier patch primitive.  This is slower
	but produces better results than the alternative method, which uses
	the standard P3D Bezier patch simulator.  The alternative method
	can be selected at compile time by defining AVOID_NURBS.  The 
	degree of refinement is adjustable in the source code via the
	constant NURBS_PIXEL_TOL.
	
	This renderer uses an orthogonal transformation if the fovea is
	less than 1 degree.

Known bugs:

	The IBM AIX GL library (AIX revision 3.1.5) does not seem to
	properly support colors associated with control points of NURBS
	surfaces, and thus of Bezier patches.  See the description of
	the AVOID_NURBS switch above if you need a work-around for this
	problem.
	
