Rayshade Renderer Driver
-----------------------------

Files: rayshade/*.c, rayshade/*.h

Renderer: Craig Kolb's Rayshade ray tracer, version 3.0, with mods.

Primitives:
	Intrinsic:
		polygon, sphere, cylinder, triangle strip
	Emulated:
		polyline (as cylinder), polymarker (as sphere), 
		torus, Bezier patch, mesh, text

Attributes: color, material, text-font, text-stroke-width-fraction,
	text-thickness-fraction, point-diameter, line-diameter

Lights: light, ambient

Camera handling: complete.

Auxiliary functions:  ren_free, ren_dump, ren_setup, ren_reset, ren_shutdown.

Hooks:  none

Comments:
	This renderer is an interface into Craig Kolb's Rayshade ray
	tracer.  The version of Rayshade used is the 3.0 release,
	with patches through patch level 5.  The following changes
	were made to the original renderer code:

	-Many Rayshade data types were renamed to have the prefix
	 ray_ (for example ray_Color), to avoid conflicts with P3D
	 types.

	-The texture mapping facility in texture.c was removed, and
	 intersect.c and object.c were modified to reflect the change.
	 This is a temporary measure, until P3D supports textures.

	-The input file parser (input_lex and input_yacc) was completely
	 replaced with ray_ren.c, which interfaces to the P3D interpreter.

	-outputp.c was modified to link against the PSC's DrawCGM library
	 to produce CGM output files, rather than against the Utah Raster
	 Library.  This can be changed by using an appropriate define in
	 the compilation of outputp.c.

	Objects are defined to the renderer at rendering traversal time;
	traversal takes place within P3D.  The objects are stored either
	in a flat (non-hierarchical) Rayshade list or (see below) in a 
	grid produced from a flat list.  Lighting traversal is handled
	the same way.

	The output file name is taken from the value of 'p3d-outfile'
	as defined in p3d_dflts.lsp or p3d_global.lsp.  If the renderer
	is producing CGM output (the default case), all frames in the
	P3D file are rendered into a single CGM file with the name
	given by the value of 'p3d-outfile'.  Note that in this case
	the variable 'p3d-device' can be used to cause any other form
	of output supported by the DrawCGM library to be produced instead;
	one relevant example might be Postscript.  If the routine outputp.c
	is compiled with appropriate switches to use Utah Raster Library
	format, separate files are produced for each frame rendered and
	file names are of the form name1.rle, where name is the value of
	'p3d-outfile' and 1 is replaced with an appropriate frame number.

	The renderer looks for several attribute-value pairs in the
	'p3d-hints' list defined in p3d_dflts.lsp or p3d_global.lsp.
	They are:

	  x-resolution		integer;  x resolution at which to render,
				defaults to XRESOLUTION as set in defaults.h

	  y-resolution		integer;  y resolution at which to render,
				defaults to YRESOLUTION as set in defaults.h

	  grid-resolution	integer;  if defined a grid of the given
				resolution (in all three dimensions) is
				constructed to accelerate rendering.  If
				grid-resolution is not defined, a list
				representation is used;  this is more
				efficient for simple models.  For complex
				models, Kolb recommends a value of about 20.

	  grid-x-resolution,    integers;  these can be used to define
	  grid-y-resolution,    independent grid resolutions in the x,
	  grid-z-resolution     y, and z directions.  Note that grid-
				resolution must not be specified, as it
				will override the independent settings.
				Otherwise, all comments affecting grid-
				resolution apply to these hints also.

	  ignore-text		boolean;  if true text primitives are
				ignored.  Since text is emulated using
				many cylinders and boxes, this can
				save time when rendering models containing
				lots of extraneous text.

	The following are the limitations of the current implementation.
	Vertex colors are averaged over polygons, and the polygon is
	drawn with an overall color equal to the average.  Triangle
	strips, three-vertex polygons, and three-vertex facets of
	meshes are rendered with proper normals;  polygons and mesh
	elements with more than three vertices do not use normals
	and will have a flat appearance.  Bezier patches and tori
	are emulated as meshes;  tori have four-vertex facets and
	thus will have a flat-faceted appearance.  Spheres and 
	cylinders are rendered correctly.  Polylines are rendered 
	as cylinders with a rather arbitrary diameter;  polymarkers 
	are rendered as spheres with a rather arbitrary diameter.  
	Text is emulated by stroking out the appropriate Hershey font
	using chains of Rayshade 'box' primitives, mitered together
	with cylinders.  Thus a small amount of text can add a
	significant number of primitives.  Transparency works, with
	transparency data associated with vertices treated as described
	above.

	Anti-aliasing is always done by adaptive supersampling with one 
	subdivision.

	The full original source and documents for Rayshade 3.0 are
	available by anonymous FTP from weedeater.math.yale.edu .

Known bugs:
	The Open Software Foundation version of the Gnu C Compiler 'gcc'
	doesn't seem to be able to handle compiling shade.c.  The 
	compilation produces an executable with shading errors.
