Painter Driver
--------------------

Renderer: Painter, developed at PSC

Files: 
	Painter files :  painter.c painter_clip.c painter_util.c 
		         paintr_trans.c painter.h painter_vars.h 
			 paintr_strct.h
	Painter Driver:  painter_ren.c


Primitives:
	Intrinsic:
		polygon, polyline, polymarker
	Emulated:
		mesh emulated as an array of polygons
		triangle strip emulated as mesh
		sphere emulated as mesh of 60 polygons
		torus emulated as mesh of 30 polygons
		cylinder emulated as variable sized mesh polygons
		text emulated as polylines

Attributes: color, backcull, text-height, material

Lights: lighting is always at position (0,0,infinity) with respect
	to the camera location. Ambient light is set to 70%, direct lighting 
	is 30%.

Camera handling: complete.

Auxiliary functions: ren_setup fully implemented.
		     ren_reset is a noop.

Comments:
	Painter is a simplistic renderer meant as a visualization guide.  It 
	does not produce production quality images, and may be quite slow for
	large images (60,000 polygons, or 1,000 spheres, takes about a minute).
	No curve fitting or interpolation of color or normals is performed.
	Also, if the host machine has a limited color table, the shading can 
	be difficult to interpret.  

	It is useful for determining the general aspects of a p3d file to 
	determine if the image is what the user wants before the user makes a 
	large number of them.  These images can later be drawn on a high
	quality renderer for better viewing, or laid onto video.

	Traversal of the model is done at snap time, gobs are transfered to
	the renderer at snap time as well.  Gobs are retained until the next
	snap.

	At setup time, the "device" parameter must be set to the device
	driver ID to be used, from among the set of GPlot device drivers
	installed.  For example, "tek" is tektronix 4014 and "ps" is
	postscript.

	
	
