Display-p3d is a tool for examining models in a P3D model file.  It
provides a renderer to draw pictures of the model, and a user
interface to move the model around between views.  This document will
describe the tool that one gets by combining the Painter renderer with
the Keyboard User Interface; this combination is what goes by the name
of display-p3d at the PSC.  Other combinations of renderer and user
interface also exist; see for example mp3d.t.  However, the basic
function of the program is always the same.

On the PSC machines, display-p3d uses the Painter renderer.  This
renderer uses lines and polygons to draw objects from back to front,
so that near things cover up things which are farther away.  This is
called the Painter's Algorithm, because it is what real painters
supposedly do.  This algorithm is fairly fast and general, but it is
not perfect.  Sometimes, from some angles, display-p3d will show an
object which should be hidden by another object, or vice versa.  We're
sorry about this, but using this simple renderer allows display-p3d to
be used by users with the widest possible range of home equipment.
The algorithm will work best if all the objects (polygons, lines,
etc.) in a model are around the same size.

Display-p3d draws on your terminal or workstation screen using the
same set of device drivers used by our CGM translator, GPlot.
Some of the devices which may be available are:

	xws		X Window System
	xl		X Window System (better for monochrome devices)
	tek4014		tektronix 4014
	tek4010		tektronix 4010
	tek4207		tektronix 4207
	ps		postscript
	cgmb		binary cgm
	cgmc		clear text cgm
	excl		excl page description language
	qms		qms page description language

A number of other devices can also be installed.  You can find the
full list of supported device drivers in the documentation for GPlot.
By default, display-p3d will use the X Window System device driver
"xws".  If you would rather it used another device driver, you can
change it as follows.  If you want to use device "ps" (the Postscript
driver, for example) place a file named p3d_dflts.lsp in the directory
from which you will be running display-p3d.  The file should contain
the following line:

	(setq p3d-device "ps")

When you start up display-p3d, that file will be read and the "ps"
device will be used.  A number of other parameters, for example the
default attributes used by display-p3d, can be changed by the
same mechanism.  We hope to add a more convenient mechanism in
the future.

Once the appropriate display device is set, you can proceed to display
your P3D file.  If the file you want to examine is mymodel.p3d, the
appropriate command under VMS is:

$ display_p3d mymodel.p3d	(note the underscore character)

while on Unix systems it is:

% display-p3d mymodel.p3d

When the command is entered, the lisp code which makes up the model
will be parsed by the lisp interpreter within display-p3d.  (If you
want to use the interpreter directly, give the display-p3d command
without a file name).  A number of words will be printed on the
screen as the various parts of your model are parsed.  Eventually,
and for a large model it may take some time, your model will be drawn.

At this point, you can start changing the view of the model using
the keyboard.  The commands listed below change the position of the
"camera" from whose viewpoint the picture is drawn.  Each time
the camera is moved, the model will be redrawn from the new viewpoint.
The camera movement commands are:

	u	move up
	d	move down
	l	move left
	r	move right
	i	move in
	o	move out

You can prefix any of these commands with an integer, and the camera
will move that number of times as far.  With no prefix, the camera
will move 5 degrees or 10% radially each time a movement key is hit.

The keyboard user interface will also accept the following commands:

	q	quit this model and move on to the next model in the file
	e	exit display-p3d
	h	help
	?	same as h

You should use the q or e commands to exit from display-p3d when you
are finished using it.

If you are using the "xws" device driver and the colors of your model
don't look correct, it may be because the software is having
difficulty controlling the color map of your display.  A quick fix is
to try the Unix command "xstdcmap -all".  If this doesn't work, call
PSC user services or send mail to welling@psc.edu for advice.  Color
map handling is unfortunately rather vendor-dependent and it is not
always easy to convince the display to produce the colors desired.







