! ****************************************************************************
! * descrip.mss for all of P3D software
! * Author Joel Welling
! * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
! *
! * Permission use, copy, and modify this software and its documentation
! * without fee for personal use or use within your organization is hereby
! * granted, provided that the above copyright notice is preserved in all
! * copies and that that copyright and this permission notice appear in
! * supporting documentation.  Permission to redistribute this software to
! * other organizations or individuals is not granted;  that must be
! * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
! * University make any representations about the suitability of this
! * software for any purpose.  It is provided "as is" without express or
! * implied warranty.
! *****************************************************************************
!
!	This descrip.mms controls the construction of all the parts of
!	this release of P3D.  To install P3D on any VMS machine, you
!	should check the descrip.mms files in the various subdirectories
!	for comments which apply to you (for example, regarding the
!	locations of libraries on your system), then run mms from
!	this directory.
!

all : display_p3d.exe,render_p3d.exe,dump_p3d.exe,tdump_p3d.exe, -
	drawp3d.olb,marchp3d.exe,movietop3d.exe,pdbmodel.exe, -
	trace_snaps.exe
	continue

display_p3d.exe :
	set default [.src]
	mms display_p3d.exe
	set default [-]

render_p3d.exe :
	set default [.src]
	mms render_p3d.exe
	set default [-]

dump_p3d.exe :
	set default [.src]
	mms dump_p3d.exe
	set default [-]

tdump_p3d.exe :
	set default [.src]
	mms tdump_p3d.exe
	set default [-]

march_cubes.olb :
	set default [.modelbuilders.marching_cubes]
	mms marchp3d.exe test_march.exe
	set default [-.-]

marchp3d.exe :
	set default [.modelbuilders.marching_cubes]
	mms marchp3d.exe,test_stream.exe
	set default [-.-]

movietop3d.exe :
	set default [.modelbuilders.movietop3d]
	mms
	set default [-.-]

pdbmodel.exe :
	set default [.modelbuilders.pdbmodel]
	mms
	set default [-.-]

trace_snaps.exe :
	set default [.modelbuilders.flyby]
	mms
	set default [-.-]

drawp3d.olb :
	set default [.modelbuilders.drawp3d]
	mms
	set default [-.-]

clean :
	set default [.src]
	mms clean
	set default [-.modelbuilders.marching_cubes]
	mms clean
	set default [-.movietop3d]
	mms clean
	set default [-.pdbmodel]
	mms clean
	set default [-.flyby]
	mms clean
	set default [-.-]

clobber :
	set default [.src]
	mms clobber
	set default [-.modelbuilders.marching_cubes]
	mms clobber
	set default [-.movietop3d]
	mms clobber
	set default [-.pdbmodel]
	mms clobber
	set default [-.flyby]
	mms clobber
	set default [-.-]

