
#include <stdio.h>
#include "df.h"

#define NOPTS 1
#define MINARGS 3

#define PALBUFSIZE 256

main(argc,argv)
int argc;
char *argv[];
{
	char *pname,*pstr;
	float pver;
	unsigned short dev_month,dev_year;
	int err_ret,nopts,nargs;
	char pstat;
	char *opt_array[NOPTS],*opt_desc[NOPTS];
	int opt_loc[NOPTS];

	char *hfile24,*hfile8;
	unsigned char *hbuf8,*hbuf24,*temp_buff;
	unsigned char palette[PALBUFSIZE][3];
	long xsize,ysize,zsize,ispal,pil;
	long num_bytes;
	register int i;

	pname = "r24tor8";
	pver = 1.0;
	dev_month = 5;
	dev_year = 1990;
	pstat = 'P';
	pstr = "public domain software";

	opt_desc[0] = "r24tor8 <hdf_r24_in> <hdf_r8_out>";
	opt_array[0] = opt_desc[0];
	nopts = NOPTS;

	err_ret = prog_title(pname,pver,dev_month,dev_year,pstat,pstr);

	if(argc < MINARGS){
		err_ret = prog_opts(nopts,opt_array,opt_desc);
		exit(1);
	}

	if(argc > MINARGS)
		err_ret = opt_index(argv,opt_array,argc,nopts,opt_loc);

	hfile24 = argv[argc-2];
	hfile8 = argv[argc-1];

/* check to see if input file is mistakingly an HDF r8 file */
	if (!(err_ret = DFR8getdims(hfile24,&xsize,&ysize,&ispal))){
		printf("%s: HDF file is r8, expecting r24\n",hfile24);
		exit(1);
	}

	err_ret = DF24getdims(hfile24,&xsize,&ysize,&pil);
	if(err_ret){
		printf("%s: Cannot read - unknown format\n",hfile24);
		exit(1);
	}

	zsize = 3;
	num_bytes = xsize * ysize * zsize * sizeof(char);
	hbuf24 = (unsigned char *)malloc(num_bytes);
	if(!hbuf24){
		printf("%s: Not enough memory\n",hfile24);
		exit(1);
	}
	if((pil == 1) || (pil == 2)){
		temp_buff = (unsigned char *)malloc(num_bytes);
		if(!temp_buff){
			printf("%s: Not enough memory\n",hfile24);
			exit(1);
		}
		err_ret = DF24getimage(hfile24,temp_buff,xsize,ysize);
		if(err_ret){
			printf("%s: Error with DF24getimage\n",hfile24);
			exit(1);
		}
		ch_seqfmt((pil+1),1,temp_buff,hbuf24,xsize,ysize);
		free(temp_buff);
	}
	else if(pil == 0){
		err_ret = DF24getimage(hfile24,hbuf24,xsize,ysize);
		if(err_ret){
			printf("%s: Error with DF24getimage\n",hfile24);
			exit(1);
		}
	}
	else{
		printf("%d: Unsupported interlace\n",pil);
		exit(1);
	}

	zsize = 1;
	num_bytes = xsize * ysize * zsize * sizeof(char);
	hbuf8 = (unsigned char *)malloc(num_bytes);
	if(!hbuf8){
		printf("%s: Not enough memory\n",hfile8);
		exit(1);
	}
	err_ret = img_quant2(hbuf24,hbuf8,xsize,ysize,palette);
	if(err_ret){
		printf("%s: Error with img_quant2\n",hfile24);
		exit(1);
	}

	DFR8setpalette(palette);
	err_ret = DFR8putimage(hfile8,hbuf8,xsize,ysize,DFTAG_RLE);
	if(err_ret){
		printf("%s: Error with DFR8putimage",hfile8);
		exit(1);
	}
		
}

