
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <stdio.h>
#include <string.h>

#define NOPTS 1
#define MINARGS 3

#define PALBUFSIZE 256

main(argc,argv)
int argc;
char *argv[];
{
	char *pname,*pstr;
	float pver;
	unsigned short dev_month,dev_year;
	int err_ret,nopts,nargs;
	char pstat;
	char *opt_array[NOPTS],*opt_desc[NOPTS];
	int opt_loc[NOPTS];

	char *lfile_in,*lfile_out;
	int num_bytes;
	unsigned char palette[PALBUFSIZE][3];
	register int i;

	pname = "paltohdf";
	pver = 1.01;
	dev_month = 7;
	dev_year = 1990;
	pstat = 'P';
	pstr = "public domain software";

	opt_desc[0] = "paltohdf <seq_pal_in> <hdf_lut_out>";
	opt_array[0] = opt_desc[0];
	nopts = NOPTS;

	err_ret = prog_title(pname,pver,dev_month,dev_year,pstat,pstr);

	if (argc < MINARGS){
		err_ret = prog_opts(nopts,opt_array,opt_desc);
		exit(1);
	}

	if (argc > MINARGS)
		err_ret = opt_index(argv,opt_array,argc,nopts,opt_loc);

	lfile_in  = argv[argc-2];
	lfile_out = argv[argc-1];

	err_ret = DFPgetpal(lfile_in,palette);
	if(!err_ret){
		printf("%s: File already HDF format!\n",lfile_in);
		exit(1);
	}

	err_ret = seqpal_io(lfile_in,"r",palette);
	if(!err_ret) goto gxstart;

	err_ret = seqpal_io(lfile_in,"rb",palette);
	if(!err_ret) goto gxstart;

	printf("%s: Error reading\n",lfile_in);
	exit(1);

gxstart:
	err_ret = gx_putpal(lfile_out,palette);
	if (err_ret){
		printf("%s: Error writing\n",lfile_out);
		exit(1);
	}

}

int gx_putpal(lfile,pal)
char *lfile;
unsigned char *pal;
{
	int err_ret,ret;
	int xdim,ydim,encode;
	int i;
	unsigned char nul_ptr[1];

	err_ret = 0;

	xdim = 1;
	ydim = 1;
	encode = 0;
	DFR8setpalette(pal);
	ret = DFR8putimage(lfile,nul_ptr,xdim,ydim,encode);
	if (ret){
		err_ret = 1;
		printf("%s: Error with DFR8putimage\n",lfile);
		goto error;
	}

error:
	return(err_ret);
}
