
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <gl.h>
#include <device.h>

#include "fvars_ext.com"

int gx_init(win_parms,wname)
long win_parms[];
char *wname;
{

	long x1,x2,y1,y2;
	long win_opt,win_type;

/* win_opt = 0	rubberband open window				*/
/* win_opt = 1  open fixed size window, positioned by cursor	*/
/* win_opt = 2  open fixed size window in fixed location	*/

/* win_type = 0  open pseudo-color window	*/
/* win_type = 1  open true-color window		*/

	win_opt = win_parms[4];
	win_type = win_parms[5];

	switch(win_opt){
		case 0:
			break;
		case 1:	
			x1 = win_parms[0];
			y1 = win_parms[1];
			prefsize(x1,y1);
			break;
		case 2:
			x1 = win_parms[0];
			y1 = win_parms[1];
			x2 = x1 + win_parms[2] - 1;
			y2 = y1 + win_parms[3] - 1;
			prefposition(x1,x2,y1,y2);
			break;
		default:
			break;
	}

	foreground();
	WID=winopen(wname); 
	winconstraints(); 

	switch(win_type){
		case 0:
			cmode();
			onemap();
			break;
		case 1:
			RGBmode();
			break;
		default:
			RGBmode();
			break;
	}

	singlebuffer();
	drawmode(NORMALDRAW);
	gconfig();
	reshapeviewport();

	qdevice(ESCKEY);
	qdevice(REDRAW);

	if (win_type)
		cpack(BLACK);
	else
		color(BLACK);
		
	clear();

	return(0);
}
