/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>

#include "txtUI.h"
#include "netdata.h"
#include "net.h"
#include "view.h"
#include "mode.h"


#ifndef MALLOC
#define MALLOC 	malloc
#define FREE	free
#endif


extern void TextNew();
extern void TextChange();
extern void TextDestroy();

extern TextUI *TextCreate();
extern TextUI *TextSearchByName();
extern int CheckLines();
extern void GetMargins();
extern void RegisterPopup();
extern int NetSendText();


extern NetPort *outP;
extern Display *myDpy;
extern GC drawAreaGC;
extern GC invGC;
extern int Swidth, Sheight, Sascent;



Boolean HaveMargins = False;
int TopMargin, BottomMargin, LeftMargin, RightMargin, Border;

static int TxtCnt = 1;


void TextExposed();


void
CBTextValueChange(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;
	XWindowAttributes attr;
	int val, j1, j2, j3;
	int oldx, oldy;
	int numLines;

	if (V->isUp == False)
	{
		return;
	}

	numLines = CheckLines(V->drawArea);
	if (numLines != V->cData->ydim)
	{
		if (numLines > V->cData->ydim)
		{
			XmTextPosition pos;
			Position x, y;

			V->cData->ydim = numLines;
			XGetWindowAttributes(myDpy, XtWindow(V->drawArea),
				&attr);
			pos = XmTextGetInsertionPosition(V->drawArea);
			XmTextPosToXY(V->drawArea, pos, &x, &y);
			XClearArea(myDpy, XtWindow(V->drawArea), x, y,
				(attr.width - x), (attr.height - y), True);
		}
		else
		{
			V->cData->ydim = numLines;
		}
	}
}


void
TextMaybeScroll(V)
	View *V;
{
	XWindowAttributes attr;
	int val, j1, j2, j3;
	int oldx, oldy;
	int numLines;

	if (V->isUp == False)
	{
		return;
	}

	XmScrollBarGetValues(V->vscroll, &val, &j1, &j2, &j3);
	if ((val * Sheight) != V->Scroll_y)
	{
		oldy = V->Scroll_y;
		V->Scroll_y = (val * Sheight);
		V->text_y = V->text_y + oldy - V->Scroll_y;

/*EJB
		XGetWindowAttributes(myDpy, XtWindow(V->drawArea), &attr);
		if (V->Scroll_y > oldy)
		{
			Arg argList[3];
			Cardinal i;
			short rows;

			i = 0;
			XtSetArg(argList[i], XmNrows, &rows); i++;
			XtGetValues(V->drawArea, argList, i);

			TextExposed(V,
			  0, ((rows * Sheight)+ TopMargin - V->Scroll_y + oldy),
			  attr.width, (V->Scroll_y - oldy));
		}
		else
		{
			TextExposed(V, 0, 0, attr.width,
				(oldy - V->Scroll_y + TopMargin));
		}
*/
	}

	XmScrollBarGetValues(V->hscroll, &val, &j1, &j2, &j3);
	if (val != V->Scroll_x)
	{
		oldx = V->Scroll_x;
		V->Scroll_x = val;
		V->text_x = V->text_x + oldx - V->Scroll_x;
		V->ret_x = V->ret_x + oldx - V->Scroll_x;

/*EJB
		XGetWindowAttributes(myDpy, XtWindow(V->drawArea), &attr);
		if (V->Scroll_x > oldx)
		{
			TextExposed(V,
			  (attr.width - V->Scroll_x - RightMargin + oldx), 0,
			  (V->Scroll_x - oldx + RightMargin), attr.height);
		}
		else
		{
			TextExposed(V, 0, 0, (oldx - V->Scroll_x + LeftMargin),
				attr.height);
		}
*/
	}

/*EJB
	numLines = CheckLines(V->drawArea);
	if (numLines != V->cData->ydim)
	{
		V->cData->ydim = numLines;
		XGetWindowAttributes(myDpy, XtWindow(V->drawArea), &attr);
		XClearArea(myDpy, XtWindow(V->drawArea), 0, 0, 0, 0, True);
		TextExposed(V, LeftMargin, TopMargin,
			(attr.width - LeftMargin - RightMargin),
			(attr.height - TopMargin - BottomMargin));
	}
	else
	{
		XmTextPosition pos;
		Position x, y;

		XGetWindowAttributes(myDpy, XtWindow(V->drawArea), &attr);
		pos = XmTextGetInsertionPosition(V->drawArea);
		XmTextPosToXY(V->drawArea, pos, &x, &y);
		TextExposed(V, x, y,
			(attr.width - x - RightMargin),
			(attr.height - y - BottomMargin));
	}
*/
}


void
CBTextScrollY(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	XmScrollBarCallbackStruct *sc = (XmScrollBarCallbackStruct *)call_data;
	View *V = (View *)client_data;
	XWindowAttributes attr;
	int val, j1, j2, j3;
	int oldx, oldy;

	oldy = V->Scroll_y;
	V->Scroll_y = (sc->value * Sheight);
	V->text_y = V->text_y + oldy - V->Scroll_y;

	XGetWindowAttributes(myDpy, XtWindow(V->drawArea), &attr);
	XmScrollBarGetValues(V->hscroll, &val, &j1, &j2, &j3);
	if (val != V->Scroll_x)
	{
		oldx = V->Scroll_x;
		V->Scroll_x = val;
		V->text_x = V->text_x + oldx - V->Scroll_x;
		V->ret_x = V->ret_x + oldx - V->Scroll_x;

/*EJB
		if (V->Scroll_x > oldx)
		{
			TextExposed(V,
			  (attr.width - V->Scroll_x - RightMargin + oldx), 0,
			  (V->Scroll_x - oldx + RightMargin), attr.height);
		}
		else
		{
			TextExposed(V, 0, 0, (oldx - V->Scroll_x + LeftMargin),
				attr.height);
		}
*/
	}

/*EJB
	if (V->Scroll_y > oldy)
	{
		Arg argList[3];
		Cardinal i;
		short rows;

		i = 0;
		XtSetArg(argList[i], XmNrows, &rows); i++;
		XtGetValues(V->drawArea, argList, i);

		TextExposed(V,
		  0, ((rows * Sheight) + TopMargin - V->Scroll_y + oldy),
		  attr.width, (V->Scroll_y - oldy));
	}
	else
	{
		TextExposed(V, 0, 0, attr.width,
			(oldy - V->Scroll_y + TopMargin));
	}
*/
}


void
CBTextScrollX(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	XmScrollBarCallbackStruct *sc = (XmScrollBarCallbackStruct *)call_data;
	View *V = (View *)client_data;
	XWindowAttributes attr;
	int oldx;

	oldx = V->Scroll_x;
	V->Scroll_x = sc->value;
	V->text_x = V->text_x + oldx - V->Scroll_x;
	V->ret_x = V->ret_x + oldx - V->Scroll_x;

/*EJB
	XGetWindowAttributes(myDpy, XtWindow(V->drawArea), &attr);
	if (V->Scroll_x > oldx)
	{
		TextExposed(V,
		  (attr.width - V->Scroll_x - RightMargin + oldx), 0,
		  (V->Scroll_x - oldx + RightMargin), attr.height);
	}
	else
	{
		TextExposed(V, 0, 0, (oldx - V->Scroll_x + LeftMargin),
			attr.height);
	}
*/
}



void
RealTextExposed(V, x, y, width, height)
	View *V;
	int x, y;
	unsigned int width, height;
{
	int col, xpos, c1, c2;
	int row, ypos, r1, r2;
	int i, val;
	float fval;
	Pixmap dmap;
	Pixmap clipmask;
	Pixmap nopix;
	XWindowAttributes attr;

	if (V->viewOverlay == False)
	{
		return;
	}

	XGetWindowAttributes(myDpy, XtWindow(V->drawArea), &attr);
	if (x < LeftMargin)
	{
		width = width - (LeftMargin - x);
		x = LeftMargin;
	}
	if ((x + width) > (attr.width - RightMargin))
	{
		width = (attr.width - RightMargin) - x;
	}

	if (y < TopMargin)
	{
		height = height - (TopMargin - y);
		y = TopMargin;
	}
	if ((y + height) > (attr.height - BottomMargin))
	{
		height = (attr.height - BottomMargin) - y;
	}

	nopix = (Pixmap)0;
	r1 = (V->Scroll_y + y - TopMargin) / Sheight;
	r2 = (V->Scroll_y + y + height - TopMargin) / Sheight;
	ypos = (r1 * Sheight) - V->Scroll_y + TopMargin;

	c1 = (V->Scroll_x + x - LeftMargin) / Swidth;
	c2 = (V->Scroll_x + x + width - LeftMargin) / Swidth;
	xpos = (c1 * Swidth) - V->Scroll_x + LeftMargin;

	for (row = r1; row <= r2; row++)
	{
		xpos = (c1 * Swidth) - V->Scroll_x + LeftMargin;
		for (col = c1; col <= c2; col++)
		{
			if ((col >= 0)&&(row >= 0))
			{
				dmap = FindDHash(V->Doodles, col, row,
					&clipmask);
			}
			else
			{
				dmap = nopix;
			}
			if ((dmap != (Pixmap)0)&&(V->viewOverlay))
			{
				int cx, cy;
				unsigned int cwidth, cheight;

				if (xpos < LeftMargin)
				{
					cx = LeftMargin - xpos;
					cwidth = Swidth - cx;
				}
				else
				{
					cx = 0;
					cwidth = Swidth;
				}
				if ((xpos + cwidth) > (attr.width - RightMargin))
					cwidth = (attr.width - RightMargin) - xpos;

				if (ypos < TopMargin)
				{
					cy = TopMargin - ypos;
					cheight = Sheight - cy;
				}
				else
				{
					cy = 0;
					cheight = Sheight;
				}
				if ((ypos + cheight) > (y + height))
					cheight = (y + height) - ypos;
				if ((ypos + cheight) > (attr.height - BottomMargin))
					cheight = (attr.height - BottomMargin) - ypos;
				XSetClipMask(myDpy,drawAreaGC,clipmask);
				XSetClipOrigin(myDpy, drawAreaGC,
					(xpos + cx), (ypos + cy));
				XCopyArea(myDpy, dmap,
					XtWindow(V->drawArea),
					drawAreaGC,
					cx, cy, cwidth, cheight,
					(xpos + cx), (ypos + cy));
				XSetClipMask(myDpy, drawAreaGC, None);
			}
			xpos += Swidth;
		}
		ypos += Sheight;
	}
}


void
TextExposed(V, x, y, width, height)
	View *V;
	int x, y;
	unsigned int width, height;
{
	TextMaybeScroll(V);

	RealTextExposed(V, x, y, width, height);

	if (V->Mode == TEXTINSERT)
	{
		RealTextExposed(V, V->text_x, (V->text_y - Sascent),
			Swidth, Sheight);
		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
	}
}


void
CBTextExposed(w, client_data, event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	XExposeEvent *ExEvent = (XExposeEvent *)event;
	View *V = (View *)client_data;
	XWindowAttributes attr;

	if (V->isUp == False)
	{
		V->isUp = True;
	}

	if (!HaveMargins)
	{
	    GetMargins(w, &TopMargin, &BottomMargin,
			&LeftMargin, &RightMargin, &Border);
	    HaveMargins = True;
	}

	XGetWindowAttributes(myDpy, XtWindow(V->drawArea), &attr);
/*
	TextExposed(V, 0, 0, attr.width, attr.height);
*/

/*EJB Text widget is broken, redraws ALL text for any expose event
	TextExposed(V, ExEvent->x, ExEvent->y, ExEvent->width, ExEvent->height);
*/
}

void
NewTextWindow()
{
	char name[256];
	TextUI *text;
	Text t;

	text = NULL;
	sprintf(name, "Text Window %d", TxtCnt);
	while((text = TextSearchByName(name)) != NULL)
	{
		TxtCnt++;
		sprintf(name, "Text Window %d", TxtCnt);
	}
	TxtCnt++;

	if (!(t.title = (char *)MALLOC(strlen(name)+1)))
	{
                ErrMesg("Out of Memory for text title\n");
                return;
	}
	strcpy(t.title, name);
	t.dim = 1;
	if (!(t.textString = (char *)MALLOC(2)))
	{
                ErrMesg("Out of Memory for text\n");
                return;
	}
	t.textString[0] = '\0';
	t.selLeft = 0;
	t.selRight = 0;
	t.insertPt = 0;
	t.numReplace = t.dim;
	t.replaceAll = TRUE;
	t.id = "new";
	NetSendText(outP, &t, TRUE, "NewText");
}


#ifdef MAC_COMPAT
void
StartText(rootWidget)
	Widget rootWidget;
{
	TextUI *text;

	text = TextCreate(rootWidget, "Text", 1);
/*
	if (text)
	{
		XtPopup(text->top, XtGrabNone);
		XtPopdown(text->top);
	}
*/
}
#endif /* MAC_COMPAT */


void
TextSetup(rootWidget)
	Widget rootWidget;
{
TextUI *text;

        NetRegisterModule(TEXT_MODULE_NAME,NETTXT,
                        TextNew,0,
                        TextChange,0,
                        TextDestroy,0);
        TextInit(rootWidget);
/* EJB
	text = TextCreate(rootWidget,"Untitled");
	if (text)
		return(text->top);
	else
		return((Widget)NULL);
*/
}

