/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <Xm/TextP.h>


#define	BLOCK_WIDTH	1

#ifndef MALLOC
#define MALLOC	malloc
#define FREE	free
#endif


extern void TextRedraw();


struct text_area {
	XmTextPosition first, last;
	struct text_area *next;
};

struct text_area *buffList = NULL;



void
Overlap(w, bptr, first, last)
	XmTextWidget w;
	struct text_area *bptr;
	XmTextPosition first, last;
{
	if ((first >= bptr->first)&&(last <= bptr->last))
	{
		return;
	}
	else if (first >= bptr->first)
	{
		bptr->last = last;
		if ((BLOCK_WIDTH)&&(bptr->first + BLOCK_WIDTH) < first)
		{
			TextRedraw(w, bptr->first, first);
			bptr->first = first;
		}
	}
	else if (last <= bptr->last)
	{
		bptr->first = first;
		if ((BLOCK_WIDTH)&&(bptr->last - BLOCK_WIDTH) > last)
		{
			TextRedraw(w, last, bptr->last);
			bptr->last = last;
		}
	}
}


void
AddBuff(w, first, last)
	XmTextWidget w;
	XmTextPosition first, last;
{
	struct text_area *bptr;
	struct text_area *tptr;

	if (buffList == NULL)
	{
		buffList = (struct text_area *)MALLOC(sizeof(struct text_area));
		buffList->first = first;
		buffList->last = last;
		buffList->next = NULL;
		return;
	}
	else if (last < buffList->first)
	{
		bptr = (struct text_area *)MALLOC(sizeof(struct text_area));
		bptr->first = first;
		bptr->last = last;
		bptr->next = buffList;
		buffList = bptr;
		return;
	}
	else
	{
		bptr = buffList;
		while (bptr != NULL)
		{
			if (((first >= bptr->first)&&(first <= bptr->last))||
			    ((last >= bptr->first)&&(last <= bptr->last)))
			{
				Overlap(w, bptr, first, last);
				return;
			}
			if ((bptr->next == NULL)||(last < bptr->next->first))
			{
				tptr = (struct text_area *)
					MALLOC(sizeof(struct text_area));
				tptr->first = first;
				tptr->last = last;
				tptr->next = bptr->next;
				bptr->next = tptr;
				return;
			}
			else
			{
				bptr = bptr->next;
			}
		}
	}
}


void
FlushMinMax(w, min, max)
	XmTextWidget w;
	XmTextPosition min, max;
{
	struct text_area *bptr;
	struct text_area *tptr;

	bptr = buffList;
	while ((bptr != NULL)&&(bptr->last < min))
	{
		tptr = bptr;
		bptr = bptr->next;
		TextRedraw(w, tptr->first, tptr->last);
		FREE((char *)tptr);
	}
	buffList = bptr;
	while ((bptr != NULL)&&(bptr->last <= max))
	{
		tptr = bptr;
		bptr = bptr->next;
	}

	if (bptr == buffList)
	{
		buffList = NULL;
	}
	else
	{
		tptr->next = NULL;
	}

	while (bptr != NULL)
	{
		tptr = bptr;
		bptr = bptr->next;
		TextRedraw(w, tptr->first, tptr->last);
		FREE((char *)tptr);
	}
}

