/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <dtm/dtm.h>

#include "doodle.h"
#include "viewer.h"
#include "view.h"
#include "net.h"


#define ABS(x)  ((x)>0) ? (x): (-1.0*(x))
#define	MAXPTS	5000


extern void FillLine();
extern void ProfileInternalChange();


extern NetPort *outP;
extern GC	selGC;
extern GC	invGC;
extern Display	*myDpy;
extern int SdrawWidth, SdrawHeight, SdrawAscent;



/*
 * Draw a selected line.  Different based on func.
 * func = 0:  Draw only if V is RASTER, don't follow links to SHEET
 * func = 1:  Draw in both, and follow links to the other (Erase if sheet)
 * func = 2:  Draw in both, and follow links to the other (Draw if sheet)
 */
void
RubberLineSelect(V, w, func)
	View *V;
	Widget w;
	int func;
{
	XDrawLine(myDpy, XtWindow(w), selGC, V->line_x1, V->line_y1,
			V->line_x2, V->line_y2);
	XDrawLine(myDpy, XtWindow(w), invGC, V->line_x1, V->line_y1,
			V->line_x2, V->line_y2);

#ifdef LINE_SEL_LINKED
	POINT points[MAXPTS];
	int i, cnt;

	points[0].x = line_x1;
	points[0].y = line_y1;
	points[1].x = line_x2;
	points[1].y = line_y2;
	cnt = 1;
	FillLine(points, &cnt, MAXPTS);
	if (func == 0)
	{
		for (i=0; i <= cnt; i++)
		{
			XFillRectangle(myDpy, XtWindow(w), selGC,
				(points[i].x - 3), (points[i].y - 3), 6, 6);
		}
		XDrawPoints(myDpy, XtWindow(w), selGC, (XPoint *)points,
				(cnt + 1), CoordModeOrigin);
		return;
	}

	if (V->type == V_RASTER)
	{
		for (i=0; i <= cnt; i++)
		{
			XFillRectangle(myDpy, XtWindow(w), selGC,
				(points[i].x - 3), (points[i].y - 3), 6, 6);
		}
		XDrawPoints(myDpy, XtWindow(w), selGC, (XPoint *)points,
				(cnt + 1), CoordModeOrigin);
		if ((V->next != NULL)&&(V->next->type == V_SHEET))
		{
			for (i=0; i <= cnt; i++)
			{
				if (func == 2)
				{
					SheetSelOn(V->next, V->next->drawArea,
						points[i].x, points[i].y);
				}
				else
				{
					SheetSelOff(V->next, V->next->drawArea,
						points[i].x, points[i].y);
				}
			}
		}
	}
	else if (V->type == V_SHEET)
	{
		for (i=0; i <= cnt; i++)
		{
			if (func == 2)
			{
				SheetSelOn(V, w, points[i].x, points[i].y);
			}
			else
			{
				SheetSelOff(V, w, points[i].x, points[i].y);
			}
		}
		if ((V->next != NULL)&&(V->next->type == V_RASTER))
		{
			for (i=0; i <= cnt; i++)
			{
				XFillRectangle(myDpy,
					XtWindow(V->next->drawArea), selGC,
					(points[i].x - 3), (points[i].y - 3), 6, 6);
			}
			XDrawPoints(myDpy, XtWindow(V->next->drawArea), selGC,
					(XPoint *)points, (cnt + 1),
					CoordModeOrigin);
		}
	}
#endif /* LINE_SEL_LINKED */
}


void
InitLineSelect(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	if (V->type == V_SHEET)
	{
		win_x = (win_x + V->Scroll_x) / (SdrawWidth * S_DIGITS);
		win_y = (win_y + V->Scroll_y) / SdrawHeight;
	}

	if (V->lineSelect)
	{
		RubberLineSelect(V, w, 1);
	}
	V->lineSelect = True;

	V->line_x1 = win_x;
	V->line_y1 = win_y;
	V->line_x2 = V->line_x1;
	V->line_y2 = V->line_y1;
	RubberLineSelect(V, w, 2);
}


void
InitXYLineSelect(V, w, win_x, win_y, isVert)
	View *V;
	Widget w;
	int win_x, win_y;
	Boolean isVert;
{
	if (V->type == V_SHEET)
	{
		win_x = (win_x + V->Scroll_x) / (SdrawWidth * S_DIGITS);
		win_y = (win_y + V->Scroll_y) / SdrawHeight;
	}

	if (V->lineSelect)
	{
		RubberLineSelect(V, w, 1);
	}
	V->lineSelect = True;

	if (isVert)
	{
		V->line_x1 = win_x;
		V->line_y1 = 0;
		V->line_x2 = V->line_x1;
		V->line_y2 = V->cData->ydim-1;
	}
	else
	{
		V->line_x1 = 0;
		V->line_y1 = win_y;
		V->line_x2 = V->cData->xdim-1;
		V->line_y2 = V->line_y1;
	}
	RubberLineSelect(V, w, 2);
}


void
LineSelect(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	if (V->type == V_SHEET)
	{
		win_x = (win_x + V->Scroll_x) / (SdrawWidth * S_DIGITS);
		win_y = (win_y + V->Scroll_y) / SdrawHeight;
	}

	if (win_x < 0)
		win_x = 0;
	if (win_y < 0)
		win_y = 0;
	if (win_x >= V->cData->xdim)
		win_x = V->cData->xdim - 1;
	if (win_y >= V->cData->ydim)
		win_y = V->cData->ydim - 1;

	if ((win_x != V->line_x2)||(win_y != V->line_y2))
	{
		RubberLineSelect(V, w, 1);
		V->line_x2 = win_x;
		V->line_y2 = win_y;
		RubberLineSelect(V, w, 2);
	}
}


void
XYLineSelect(V, w, win_x, win_y, isVert)
	View *V;
	Widget w;
	int win_x, win_y;
	Boolean isVert;
{
	if (V->type == V_SHEET)
	{
		win_x = (win_x + V->Scroll_x) / (SdrawWidth * S_DIGITS);
		win_y = (win_y + V->Scroll_y) / SdrawHeight;
	}

	if (isVert)
	{
		if (win_x < 0)
			win_x = 0;
		if (win_x >= V->cData->xdim)
			win_x = V->cData->xdim - 1;
	}
	else
	{
		if (win_y < 0)
			win_y = 0;
		if (win_y >= V->cData->ydim)
			win_y = V->cData->ydim - 1;
	}

	if (((isVert)&&(win_x != V->line_x2))||
		((!isVert)&&(win_y != V->line_y2)))
	{
		RubberLineSelect(V, w, 1);
		if (isVert)
		{
			V->line_x1 = win_x;
			V->line_x2 = win_x;
		}
		else
		{
			V->line_y1 = win_y;
			V->line_y2 = win_y;
		}
		RubberLineSelect(V, w, 2);

		ProfileInternalChange(V->cData->name,
			V->line_x1, V->line_y1, V->line_x2, V->line_y2);
	}
}

/*ARGSUSED*/
void
DoneLineSelect(V, w, win_x, win_y)
        View *V;
        Widget w;
        int win_x, win_y;
{
	if ((V->cData)&&(V->ispub))
	{
		NetSendLineSelect(outP, V->cData->name, "PROFILE",
				V->line_x1, V->line_y1, V->line_x2, V->line_y2);
	}
	ProfileInternalChange(V->cData->name,
		V->line_x1, V->line_y1, V->line_x2, V->line_y2);
}


void
DrawCollabSelectLine(title, id, x1, y1, x2, y2)
	char *title;
	char *id;
	int x1, y1, x2, y2;
{
	Cdata *d;

	d = CdataSearchByName(title);
	if (d)
	{
		if (!(d->V->isUp))
		{
			XtPopup(d->V->shell, XtGrabNone);
			XFlush(myDpy);
		}
		if ((d->V->lineSelect)&&(d->V->isUp))
		{
			RubberLineSelect(d->V, d->V->drawArea, 1);
		}
		d->V->lineSelect = True;

		d->V->line_x1 = x1;
		d->V->line_x2 = x2;
		d->V->line_y1 = y1;
		d->V->line_y2 = y2;
		if (d->V->isUp)
		{
			RubberLineSelect(d->V, d->V->drawArea, 2);
		}
	}
}

