/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: doodle.c,v 1.4 1993/09/01 19:55:49 davet Exp $";
#endif


#include <stdio.h>
#include <math.h>

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <dtm/dtm.h>


#define ABS(x)  ((x)>0) ? (x): (-1.0*(x))

#include "doodle.h"
#include "view.h"
#include "viewer.h"
#include "mode.h"
#include "net.h"


#define DEF_BLACK	BlackPixel(myDpy, DefaultScreen(myDpy))
#define DEF_WHITE	WhitePixel(myDpy, DefaultScreen(myDpy))


POINT	drawDoodle[MAXDRAWDOODLE];
long	lastDoodle;
long	doodleLength;


extern unsigned long BestColor();
extern Pixmap FindDHash();
extern Cdata *CdataSearchByName();
extern void RubberPoint();
extern void RubberSelect();
extern void RubberLineSelect();
extern void DrawSelectLine();
extern void SheetExposed();
extern void ClearDHash();
extern void AddDHash();
extern void SetMode();
extern void UnsetButton();

extern NetPort *outP;
extern XColor systemCCells[256];
extern XFontStruct *drawFont;
extern GC	drawAreaGC;
extern GC	invGC;
extern GC	invtextGC;
extern GC	clipOnGC;
extern GC	clipOffGC;
extern Display	*myDpy;
extern Cdata 	*currentObject;
extern long	textLength;
extern char     textMode;
extern int	Swidth, Sheight, Sascent;
extern int	SdrawWidth, SdrawHeight, SdrawAscent;
extern int TopMargin, BottomMargin, LeftMargin, RightMargin, Border;


extern int lnBeginX;
extern int lnBeginY;
extern int lnEndX;
extern int lnEndY;
extern char lineMode;


int MySendDoodle();



/*
 * draw a line between array[l - 1] and array[l] and store points in array
 */
void
FillLine(array, l, max)
	POINT *array;	/* array of points */
	int *l;		/* length */
	int max;	/* size of array */
{
	int length;
	int x0, y0;
	int x1, y1;
	int d, swap, temp, i;
	int deltaX, deltaY;
	int lx, ly;
	int x, y;
	int a, b;

	length = *l;
	x0 = array[length - 1].x;
	y0 = array[length - 1].y;
	x1 = array[length].x;
	y1 = array[length].y;
	length--;

	if (x1 < x0)
	{
		lx = x0 - x1;
		deltaX = -1;
	}
	else
	{
		lx = x1 - x0;
		deltaX = 1;
	}
	if (y1 < y0)
	{
		ly = y0 - y1;
		deltaY = -1;
	}
	else
	{
		ly = y1 - y0;
		deltaY = 1;
	}

	if (ly > lx)
	{
		a = ly;
		b = lx;
		swap = 1;
		temp = deltaX;
		deltaX = deltaY;
		deltaY = temp;
	}
	else
	{
		a = lx;
		b = ly;
		swap = 0;
	}

	if (a == 0)
	{
		return;
	}

	x = y = 0;
	d = (2 * b) - a;

	for (i=0; i <= a; ++i)
	{
		if (swap)
		{
			array[length].x = x0 + y;
			array[length].y = y0 + x;
		}
		else
		{
			array[length].x = x0 + x;
			array[length].y = y0 + y;
		}
		length++;
		if (length == max)
		{
			break;
		}
		if (d < 0)
		{
			x += deltaX;
			d += (2 * b);
		}
		else
		{
			x += deltaX;
			y += deltaY;
			d = d + (2 * (b - a));
		}
	}
	*l = length - 1;
}


#ifdef OLD_FILLLINE
void
FillLine(a,l,max) 
/* draws a line  between array[length-1] & array[length]; stores in array */
POINT *a;	 /* array of points */
long *l;	/* length */
long max;	/* size of array */
{
int x1,y1,x2,y2;
float x,y;
float yinc,ydiff,xinc,xdiff;
long length;

	length = *l;
	x1 = a[length-1].x;
	y1 = a[length-1].y;
	x2 = a[length].x;
	y2 = a[length].y;
	max--;

	ydiff = (x1 > x2) ? (y1 - y2) : (y2 - y1);
	xdiff = (y1 > y2) ? (x1 - x2) : (x2 - x1);
	if (abs(y2-y1) > abs(x2-x1)) { /* slope greater than 1 or less than -1*/
	    if (y1 > y2 ) {
		xinc = (float) xdiff / ((y1 == y2)?1.0 : ((float)(y1 - y2)));
		for (y = y2, x = x2; y < y1; y++, x=x+xinc) {
			a[length].x = (int) x;
			a[length].y = (int) y;
			length = (length < max) ? length+1 : length;
			}
		}
	    else  {
		xinc = (float) xdiff / ((y1 == y2)?1.0 : ((float)(y2 - y1)));
		for (y = y1,x = x1; y < y2; y++,x=x+xinc) {
			a[length].x = (int) x;
			a[length].y = (int) y;
			length = (length < max) ? length+1 : length;
			}
		}
	    }
	else {
	    if (x1 > x2 ) {
		yinc = (float) ydiff / ((x1 == x2)?1.0 : ((float)(x1 - x2)));
		for (x = x2, y = y2; x < x1; x++, y=y+yinc) {
			a[length].x = x;
			a[length].y = (int) y;
			length = (length < max) ? length+1 : length;
			}
		}
	    else  {
		yinc = (float) ydiff / ((x1 == x2)?1.0 : ((float)(x2 - x1)));
		for (x = x1,y = y1; x < x2; x++,y=y+yinc) {
			a[length].x = x;
			a[length].y = (int) y;
			length = (length < max) ? length+1 : length;
			}
		}
	    }
	a[length].x = x2;
	a[length].x = x2;
	a[length].y = y2;

	*l = length;

}
#endif


void
DrawBlocks(V, d, array, start, end, color, width)
	View *V;
	Cdata *d;
	POINT *array;
	long start;
	long end;
	unsigned long color;
	int width;
{
	int i, x, y;
	int row1, row2, col1, col2;
	int px, py;
	Pixmap dmap;
	Pixmap clipmask;

	if ((V->Mode == TEXTINSERT)&&(V->isUp))
	{
		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
	}
	if (V->type == V_SHEET)
	{
		XSetForeground(myDpy, drawAreaGC, color);

	    for (i=start; i <= end; i++)
	    {
		if ((V->isUp)&&(V->viewOverlay))
		{
			XFillRectangle(myDpy, XtWindow(V->drawArea),
				drawAreaGC, array[i].x - (width / 2),
				array[i].y - (width / 2), width, width);
		}
		col1 = (array[i].x - (width / 2) + V->Scroll_x) /
			(SdrawWidth * S_DIGITS);
		col2 = (array[i].x - (width / 2) + width + V->Scroll_x) /
			(SdrawWidth * S_DIGITS);
		row1 = (array[i].y - (width / 2) + V->Scroll_y) / SdrawHeight;
		row2 = (array[i].y - (width / 2) + width + V->Scroll_y) /
			SdrawHeight;
		for (y = row1; y <= row2; y++)
		{
		    for (x = col1; x <= col2; x++)
		    {
			if ((x >= 0)&&(y >= 0)&&(x < d->xdim)&&(y < d->ydim))
			{
			    dmap = FindDHash(V->Doodles, x, y, &clipmask);
			    px = (array[i].x - (width / 2) + V->Scroll_x) -
				(x * SdrawWidth * S_DIGITS);
			    py = (array[i].y - (width / 2) + V->Scroll_y) -
				(y * SdrawHeight);
			    if (dmap == (Pixmap)0)
			    {
				dmap = XCreatePixmap(myDpy,
							XtWindow(V->drawArea),
							(SdrawWidth * S_DIGITS),
							SdrawHeight,
							XDefaultDepth(myDpy,
							XDefaultScreen(myDpy)));
				clipmask = XCreatePixmap(myDpy,
							XtWindow(V->drawArea),
							(SdrawWidth * S_DIGITS),
							SdrawHeight, 1);
				XFillRectangle(myDpy, clipmask, clipOffGC,
							0, 0,
							(SdrawWidth * S_DIGITS),
							SdrawHeight);
				AddDHash(V->Doodles, x, y,
					dmap, clipmask);
			    }
			    XFillRectangle(myDpy, dmap, drawAreaGC,
				    px, py, width, width);
			    XFillRectangle(myDpy, clipmask, clipOnGC,
				    px, py, width, width);
			}
		    }
		}
	    }
	    return;
	}

	if (V->type == V_TEXT)
	{
		XSetForeground(myDpy, drawAreaGC, color);

	    for (i=start; i <= end; i++)
	    {
		if ((V->isUp)&&(V->viewOverlay))
		{
			XFillRectangle(myDpy, XtWindow(V->drawArea),
				drawAreaGC, array[i].x - (width / 2),
				array[i].y - (width / 2), width, width);
		}
		col1 = (array[i].x - (width / 2) + V->Scroll_x - LeftMargin) /
			Swidth;
		col2 = (array[i].x - (width / 2) + width + V->Scroll_x -
			LeftMargin) / Swidth;
		row1 = (array[i].y - (width / 2) + V->Scroll_y - TopMargin) /
			Sheight;
		row2 = (array[i].y - (width / 2) + width + V->Scroll_y -
			TopMargin) / Sheight;
		for (y = row1; y <= row2; y++)
		{
		    for (x = col1; x <= col2; x++)
		    {
			if ((x >= 0)&&(y >= 0))
			{
			    dmap = FindDHash(V->Doodles, x, y, &clipmask);
			    px = (array[i].x - (width / 2) + V->Scroll_x -
				LeftMargin) - (x * Swidth);
			    py = (array[i].y - (width / 2) + V->Scroll_y -
				TopMargin) - (y * Sheight);
			    if (dmap == (Pixmap)0)
			    {
				dmap = XCreatePixmap(myDpy,
							XtWindow(V->drawArea),
							Swidth, Sheight,
							XDefaultDepth(myDpy,
							XDefaultScreen(myDpy)));
				clipmask = XCreatePixmap(myDpy,
							XtWindow(V->drawArea),
							Swidth, Sheight, 1);
				XFillRectangle(myDpy, clipmask, clipOffGC,
							0, 0,
							Swidth, Sheight);
				AddDHash(V->Doodles, x, y,
					dmap, clipmask);
			    }
			    XFillRectangle(myDpy, dmap, drawAreaGC,
				    px, py, width, width);
			    XFillRectangle(myDpy, clipmask, clipOnGC,
				    px, py, width, width);
			}
		    }
		}
	    }
	    return;
	}

	if ((V->type == V_RASTER)||(V->type == V_WHITEBOARD))
	{
		if ((V->isUp)&&(V->viewOverlay))
		{
			if (V->areaSelect)
			{
				RubberSelect(V, V->drawArea);
			}
			if (V->lineSelect)
			{
				RubberLineSelect(V, V->drawArea, 0);
			}
			if (V->pointSelect)
			{
				RubberPoint(V, V->drawArea, 0);
			}
		}
		XSetForeground(myDpy, drawAreaGC, color);
		for (i=start; i <= end; i++)
		{
			if ((V->isUp)&&(V->viewOverlay))
			{
				XFillRectangle(myDpy, XtWindow(V->drawArea),
					drawAreaGC, array[i].x - (width / 2),
					array[i].y - (width / 2), width, width);
			}
			XFillRectangle(myDpy, V->doodlePix, drawAreaGC,
				array[i].x - (width / 2),
				array[i].y - (width / 2), width, width);
		}
		if ((V->isUp)&&(V->viewOverlay))
		{
			if (V->pointSelect)
			{
				RubberPoint(V, V->drawArea, 1);
			}
			if (V->lineSelect)
			{
				RubberLineSelect(V, V->drawArea, 0);
			}
			if (V->areaSelect)
			{
				RubberSelect(V, V->drawArea);
			}
		}


		for (i = d->doodleImage != NULL ? start : end+1; i <= end; i++)
		{
			int x, y;

			for (y = -(width / 2); y < (width - (width / 2)); y++)
			{
				for (x = -(width / 2);
					x < (width - (width / 2)); x++)
				{
					if (((array[i].x + x) >= 0)&&
						((array[i].y + y) >= 0)&&
						((array[i].x + x) < d->xdim)&&
						((array[i].y + y) < d->ydim))
					{
						XPutPixel(d->doodleImage,
							array[i].x + x,
							array[i].y + y,
							color);
					}
				}
			}
		}
	}
	if ((V->Mode == TEXTINSERT)&&(V->isUp))
	{
		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
	}
}


void
DrawPoints(V, d, array, start, end, color, width)
	View *V;
	Cdata *d;
	POINT *array;
	long start;
	long end;
	unsigned long color;
	int width;
{
	int i;
	int row, col;
	int px, py;
	Pixmap dmap;
	Pixmap clipmask;

	if (width > 1)
	{
		DrawBlocks(V, d, array, start, end, color, width);
		return;
	}
	if ((V->type == V_RASTER)||(V->type == V_WHITEBOARD))
	{
		if ((V->isUp)&&(V->viewOverlay))
		{
			if (V->areaSelect)
			{
				RubberSelect(V, V->drawArea);
			}
			if (V->lineSelect)
			{
				RubberLineSelect(V, V->drawArea, 0);
			}
			if (V->pointSelect)
			{
				RubberPoint(V, V->drawArea, 0);
			}
		}
		XSetForeground(myDpy, drawAreaGC, color);
		if ((V->isUp)&&(V->viewOverlay))
		{
			XDrawPoints(myDpy, XtWindow(V->drawArea), drawAreaGC,
				(XPoint *)&(array[start]), (end - start + 1),
				CoordModeOrigin);
		}
		XDrawPoints(myDpy, V->doodlePix, drawAreaGC,
			(XPoint *)&(array[start]), (end - start + 1),
			CoordModeOrigin);
		if ((V->isUp)&&(V->viewOverlay))
		{
			if (V->pointSelect)
			{
				RubberPoint(V, V->drawArea, 1);
			}
			if (V->lineSelect)
			{
				RubberLineSelect(V, V->drawArea, 0);
			}
			if (V->areaSelect)
			{
				RubberSelect(V, V->drawArea);
			}
		}

		for (i= d->doodleImage != NULL ? start : end+1; i <= end; i++)
		{
			if ((array[i].x < d->xdim)&& (array[i].x >= 0 ) &&
				(array[i].y < d->ydim)&& (array[i].y >= 0))
			{
				XPutPixel(d->doodleImage,
					array[i].x, array[i].y, color);
			}
#ifdef DEBUG
			else
			{
				printf("pixel out of bounds %d,%d\n",
					array[i].x,array[i].y);
			}
#endif
		}
	}
	else if (V->type == V_SHEET)
	{
		XSetForeground(myDpy, drawAreaGC, color);
		if ((V->isUp)&&(V->viewOverlay))
		{
			XDrawPoints(myDpy, XtWindow(V->drawArea), drawAreaGC,
				(XPoint *)&(array[start]), (end - start + 1),
				CoordModeOrigin);
		}
		for (i=start; i <= end; i++)
		{
			col = (array[i].x + V->Scroll_x) / (SdrawWidth * S_DIGITS);
			row = (array[i].y + V->Scroll_y) / SdrawHeight;
			if ((col < d->xdim)&&(row < d->ydim))
			{
				dmap = FindDHash(V->Doodles, col, row,
					&clipmask);
				px = (array[i].x + V->Scroll_x) -
					(col * SdrawWidth * S_DIGITS);
				py = (array[i].y + V->Scroll_y) -
					(row * SdrawHeight);
				if (dmap == (Pixmap)0)
				{
					dmap = XCreatePixmap(myDpy,
							XtWindow(V->drawArea),
							(SdrawWidth * S_DIGITS),
							SdrawHeight,
							XDefaultDepth(myDpy,
							XDefaultScreen(myDpy)));
					clipmask = XCreatePixmap(myDpy,
							XtWindow(V->drawArea),
							(SdrawWidth * S_DIGITS),
							SdrawHeight, 1);
					XFillRectangle(myDpy, clipmask,
							clipOffGC,
							0, 0,
							(SdrawWidth * S_DIGITS),
							SdrawHeight);
					AddDHash(V->Doodles, col, row,
						dmap, clipmask);
				}
				XDrawPoint(myDpy, dmap, drawAreaGC, px, py);
				XDrawPoint(myDpy, clipmask, clipOnGC, px, py);
			}
		}
	}
	else if (V->type == V_TEXT)
	{
		XSetForeground(myDpy, drawAreaGC, color);
		if ((V->isUp)&&(V->viewOverlay))
		{
			XDrawPoints(myDpy, XtWindow(V->drawArea), drawAreaGC,
				(XPoint *)&(array[start]), (end - start + 1),
				CoordModeOrigin);
		}
		for (i=start; i <= end; i++)
		{
			col = (array[i].x + V->Scroll_x - LeftMargin) / Swidth;
			row = (array[i].y + V->Scroll_y - TopMargin) / Sheight;
			if ((col >= 0)&&(row >= 0))
			{
				dmap = FindDHash(V->Doodles, col, row,
					&clipmask);
				px = (array[i].x + V->Scroll_x - LeftMargin) -
					(col * Swidth);
				py = (array[i].y + V->Scroll_y - TopMargin) -
					(row * Sheight);
				if (dmap == (Pixmap)0)
				{
					dmap = XCreatePixmap(myDpy,
							XtWindow(V->drawArea),
							Swidth, Sheight,
							XDefaultDepth(myDpy,
							XDefaultScreen(myDpy)));
					clipmask = XCreatePixmap(myDpy,
							XtWindow(V->drawArea),
							Swidth, Sheight, 1);
					XFillRectangle(myDpy, clipmask,
							clipOffGC,
							0, 0,
							Swidth, Sheight);
					AddDHash(V->Doodles, col, row,
						dmap, clipmask);
				}
				XDrawPoint(myDpy, dmap, drawAreaGC, px, py);
				XDrawPoint(myDpy, clipmask, clipOnGC, px, py);
			}
		}
	}
}


void
InitDrawDoodle(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	drawDoodle[0].x = win_x;
	drawDoodle[0].y = win_y;
	DrawPoints(V, V->cData, drawDoodle, 0, 0,
		V->doodleColor, V->doodleWidth);
	doodleLength = 1;
	lastDoodle = 0;
}


void
DrawDoodle(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	long	start;
	int     status;

	if ((drawDoodle[doodleLength-1].x != win_x)||
	    (drawDoodle[doodleLength-1].y != win_y))
	{
		drawDoodle[doodleLength].x = win_x;
		drawDoodle[doodleLength].y = win_y;
		start = doodleLength;
		FillLine(drawDoodle, &doodleLength, MAXDRAWDOODLE);
		DrawPoints(V, V->cData, drawDoodle, start,
			doodleLength, V->doodleColor, V->doodleWidth);
		doodleLength++;

		/*
		 * Send Doodle
		 */
		if (doodleLength == MAXDRAWDOODLE)
		{
			status = MySendDoodle(V, V->doodleWidth,
				(doodleLength - lastDoodle),
				&drawDoodle[lastDoodle], True, True);
			drawDoodle[0].x = drawDoodle[doodleLength  - 1].x;
			drawDoodle[0].y = drawDoodle[doodleLength  - 1].y;
			lastDoodle = 0;
			doodleLength = 1;
		}
		else
		{
			status = MySendDoodle(V, V->doodleWidth,
				(doodleLength - lastDoodle),
				&drawDoodle[lastDoodle], True, False);
			if (status == 1)
			{
				drawDoodle[0].x = drawDoodle[doodleLength -1].x;
				drawDoodle[0].y = drawDoodle[doodleLength -1].y;
				lastDoodle = 0;
				doodleLength = 1;
			}
		}
	}
}


void
DoneDrawDoodle(V, w, x, y)
	View *V;
	Widget w;
	int x, y;
{
	int status;

	/*
	 * Send Doodle
	 */
	status = MySendDoodle(V, V->doodleWidth, (doodleLength - lastDoodle),
		&drawDoodle[lastDoodle], True, True);
}


void
CBExposeDoodle(w, client_data, event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	XExposeEvent *ExEvent = (XExposeEvent *)event;
	View *V = (View *)client_data;

	if (V->isUp == False)
	{
		V->isUp = True;
	}

	if (V->areaSelect)
	{
		RubberSelect(V, V->drawArea);
	}
	if (V->lineSelect)
	{
		RubberLineSelect(V, V->drawArea, 0);
	}
	if (V->pointSelect)
	{
		RubberPoint(V, V->drawArea, 0);
	}
	if (V->viewOverlay)
	{
		XCopyArea(myDpy, V->doodlePix, XtWindow(w), drawAreaGC,
				ExEvent->x, ExEvent->y,
				ExEvent->width, ExEvent->height,
				ExEvent->x, ExEvent->y);
	}
	else
	{
		XClearArea(myDpy, XtWindow(w),
				ExEvent->x, ExEvent->y,
				ExEvent->width, ExEvent->height, False);
	}
	if (V->pointSelect)
	{
		RubberPoint(V, V->drawArea, 1);
	}
	if (V->lineSelect)
	{
		RubberLineSelect(V, V->drawArea, 0);
	}
	if (V->areaSelect)
	{
		RubberSelect(V, V->drawArea);
	}

	if (V->Mode == TEXTINSERT)
	{
		if (V->viewOverlay)
		{
			XCopyArea(myDpy, V->doodlePix, XtWindow(w), drawAreaGC,
				V->text_x, (V->text_y - Sascent),
				Swidth, Sheight,
				V->text_x, (V->text_y - Sascent));
		}

		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
	}
}


void
CBViewOverlay(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;
	Cardinal i;
	Arg argList[10];

	if (V->viewOverlay == True)
	{
		V->viewOverlay = False;
		if (V->Mode != NONE)
		{
			SetMode(V->lastToggle, V, V->Mode);
		}
		if (V->matchButton)
		{
			UnsetButton(V->matchButton->widget);
			V->matchButton = NULL;
		}
		if (V->type == V_TEXT)
		{
			i = 0;
			XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM);
			i++;
			XtSetValues(XtParent(V->drawArea), argList, i);

			XtUnmanageChild(V->toolform);
		}
		else
		{
			XtUnmanageChild(V->toolform);
			XtUnmanageChild(V->palform);
		}
                if (V->optionMenu != NULL)
		{
                        XtSetSensitive(V->optionMenu, False);
		}
	}
	else
	{
		V->viewOverlay = True;
		if (V->type == V_TEXT)
		{
			i = 0;
			XtSetArg(argList[i], XmNleftAttachment,XmATTACH_WIDGET);
			i++;
			XtSetArg(argList[i], XmNleftWidget, V->toolform); i++;
			XtSetValues(XtParent(V->drawArea), argList, i);

			XtManageChild(V->toolform);
		}
		else
		{
			XtManageChild(V->toolform);
			XtManageChild(V->palform);
		}
                if (V->optionMenu != NULL)
		{
                        XtSetSensitive(V->optionMenu, True);
		}
	}

	XClearArea(myDpy, XtWindow(V->drawArea), 0, 0, 0, 0, True);
}


DrawCollabDoodle(title, id, width, doodle, length, color)
	char *title;
	char *id;
	int width;
	POINT *doodle;
	int length;
	DColor *color;
{
	Cdata *d;
	unsigned long d_pixel;

	d = CdataSearchByName(title);
	if (d)
	{
		if (!(d->V->isUp))
		{
			XtPopup(d->V->shell, XtGrabNone);
			XFlush(myDpy);
		}

		d_pixel = BestColor(d, color);

		if ((d->V->Mode == TEXTINSERT)&&(d->V->isUp))
		{
			XFillRectangle(myDpy, XtWindow(d->V->drawArea), invGC,
				d->V->text_x, (d->V->text_y - Sascent),
				Swidth, Sheight);
		}

		if ((d->V->type == V_SHEET)||(d->V->type == V_TEXT))
		{
			int i;
			POINT *myDoodle;

			myDoodle = (POINT *)MALLOC(length * sizeof(POINT));

			for (i = 0; i < length; i++)
			{
				myDoodle[i].x = doodle[i].x - d->V->Scroll_x;
				myDoodle[i].y = doodle[i].y - d->V->Scroll_y;
			}
			DrawPoints(d->V, d, myDoodle, 0, (length - 1),
				d_pixel, width);
			FREE((char *)myDoodle);
		}
		else if ((d->V->type == V_RASTER)||(d->V->type == V_WHITEBOARD))
		{
			DrawPoints(d->V, d, doodle, 0, (length - 1),
				d_pixel, width);
		}

		if ((d->V->Mode == TEXTINSERT)&&(d->V->isUp))
		{
			XFillRectangle(myDpy, XtWindow(d->V->drawArea), invGC,
				d->V->text_x, (d->V->text_y - Sascent),
				Swidth, Sheight);
		}

		XFlush(myDpy);		/* EJB */
	}
}


DrawCollabContDoodle(title, id, width, doodle, length, color)
	char *title;
	char *id;
	int width;
	POINT *doodle;
	int length;
	DColor *color;
{
	Cdata *d;
	unsigned long d_pixel;
	POINT *myDoodle;
	int dlen;

	d = CdataSearchByName(title);
	if (d)
	{
		if (!(d->V->isUp))
		{
			XtPopup(d->V->shell, XtGrabNone);
			XFlush(myDpy);
		}

		d_pixel = BestColor(d, color);

		if ((d->V->Mode == TEXTINSERT)&&(d->V->isUp))
		{
			XFillRectangle(myDpy, XtWindow(d->V->drawArea), invGC,
				d->V->text_x, (d->V->text_y - Sascent),
				Swidth, Sheight);
		}

		myDoodle = (POINT *)MALLOC(MAXDRAWDOODLE * sizeof(POINT));
		dlen = 0;

		if ((d->V->type == V_SHEET)||(d->V->type == V_TEXT))
		{
			int i;

			myDoodle[0].x = doodle[0].x - d->V->Scroll_x;
			myDoodle[0].y = doodle[0].y - d->V->Scroll_y;

			for (i = 1; i < length; i++)
			{
				myDoodle[1].x = doodle[i].x - d->V->Scroll_x;
				myDoodle[1].y = doodle[i].y - d->V->Scroll_y;
				dlen = 1;
				FillLine(myDoodle, &dlen, MAXDRAWDOODLE);
				DrawPoints(d->V, d, myDoodle, 0, dlen,
					d_pixel, width);
				myDoodle[0].x = doodle[i].x - d->V->Scroll_x;
				myDoodle[0].y = doodle[i].y - d->V->Scroll_y;
			}
			DrawPoints(d->V, d, myDoodle, 0, 0, d_pixel, width);
		}
		else if ((d->V->type == V_RASTER)||(d->V->type == V_WHITEBOARD))
		{
			int i;

			myDoodle[0].x = doodle[0].x;
			myDoodle[0].y = doodle[0].y;

			for (i = 1; i < length; i++)
			{
				myDoodle[1].x = doodle[i].x;
				myDoodle[1].y = doodle[i].y;
				dlen = 1;
				FillLine(myDoodle, &dlen, MAXDRAWDOODLE);
				DrawPoints(d->V, d, myDoodle, 0, dlen,
					d_pixel, width);
				myDoodle[0].x = doodle[i].x;
				myDoodle[0].y = doodle[i].y;
			}
			DrawPoints(d->V, d, myDoodle, 0, 0, d_pixel, width);
		}

		FREE((char *)myDoodle);

		if ((d->V->Mode == TEXTINSERT)&&(d->V->isUp))
		{
			XFillRectangle(myDpy, XtWindow(d->V->drawArea), invGC,
				d->V->text_x, (d->V->text_y - Sascent),
				Swidth, Sheight);
		}

		XFlush(myDpy);		/* EJB */
	}
}


void
DrawCollabClearDoodle(title, id)
	char *title, *id;
{
	Cdata *d;
	View *V;

	d = CdataSearchByName(title);
	if (d == NULL)
	{
		return;
	}
	V = d->V;

	if (!(V->isUp))
	{
		XtPopup(V->shell, XtGrabNone);
		XFlush(myDpy);
	}

	if (V->type == V_SHEET)
	{
		XWindowAttributes attr;

		ClearDHash(V->Doodles);

		if (V->isUp)
		{
			XGetWindowAttributes(myDpy,
				XtWindow(XtParent(V->drawArea)), &attr);
			SheetExposed(V, 0, 0, attr.width, attr.height);
		}
		return;
	}

	if (V->type == V_TEXT)
	{
		XWindowAttributes attr;

		ClearDHash(V->Doodles);

		if (V->isUp)
		{
			XClearArea(myDpy, XtWindow(V->drawArea), 0, 0, 0, 0,
					True);
		}

		return;
	}

	if ((d)&&(d == V->cData))
	{
		if (V->type == V_WHITEBOARD)
		{
			Cardinal i;
			Arg argList[10];
			Pixel bg;

			i = 0;
			XtSetArg(argList[i], XtNbackground, &bg); i++;
			XtGetValues(V->drawArea, argList, i);
			XSetForeground(myDpy, drawAreaGC, bg);
			XFillRectangle(myDpy, V->doodlePix, drawAreaGC, 0, 0,
				d->xdim, d->ydim);
		}
		else
		{
			XCopyArea(myDpy, V->drawPix, V->doodlePix, drawAreaGC,
				0, 0, d->xdim, d->ydim, 0, 0);
		}

		if (d->doodleImage != NULL)
		{
			XDestroyImage(d->doodleImage);
		}
		d->doodleImage = XGetImage(myDpy, V->doodlePix, 0, 0,
				d->xdim, d->ydim, AllPlanes, ZPixmap);
		if (V->isUp)
		{
			XClearWindow(myDpy, XtWindow(V->drawArea));
			if (V->pointSelect)
			{
				RubberPoint(V, V->drawArea, 1);
			}
			if (V->lineSelect)
			{
				RubberLineSelect(V, V->drawArea, 0);
			}
			if (V->areaSelect)
			{
				RubberSelect(V, V->drawArea);
			}
		}
	}
	else if (d)
	{
		if (d->V->type == V_WHITEBOARD)
		{
			int x, y;
			Cardinal i;
			Arg argList[10];
			Pixel bg;

			i = 0;
			XtSetArg(argList[i], XtNbackground, &bg); i++;
			XtGetValues(d->V->drawArea, argList, i);
			for (y=0; y < d->ydim; y++)
			{
				for (x=0; x < d->xdim; x++)
				{
					if ((x >= 0)&&(y >= 0)&&
						(x < d->xdim)&&(y < d->ydim))
					{
					    XPutPixel(d->doodleImage, x, y, bg);
					}
				}
			}
		}
		else
		{
			int x, y;
			unsigned long pix;

			for (y=0; y < d->ydim; y++)
			{
				for (x=0; x < d->xdim; x++)
				{
					if ((x >= 0)&&(y >= 0)&&
						(x < d->xdim)&&(y < d->ydim))
					{
					   pix = XGetPixel(d->image, x, y);
					   XPutPixel(d->doodleImage, x, y, pix);
					}
				}
			}
		}
	}

	if ((V->Mode == TEXTINSERT)&&(V->isUp))
	{
		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
	}
}

void
CBClearDrawArea(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	if (V->Mode == TEXTINSERT)
	{
		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
		V->Mode = TEXT;
	}
	DrawCollabClearDoodle(V->cData->name, NULL);

	if (V->ispub)
	{
		(void)NetSendClearDoodle(outP, V->cData->name);
	}
}


int
MySendDoodle(V, width, length, doodle, discrete, doQueue)
	View *V;
	int width;
	int length;
	POINT *doodle;
	Boolean	discrete;
	Boolean	doQueue;
{
	int i, indx, status;
	unsigned long mask1, mask2;
	DColor color;
	XColor *xcolor;
	POINT *myDoodle;

	myDoodle = (POINT *)MALLOC(length * sizeof(POINT));

	if ((V->type == V_RASTER)||(V->type == V_WHITEBOARD))
	{
		mask1 = AllPlanes;
		mask2 = 0;
	}
	else
	{
		mask1 = AllPlanes;
		mask2 = 0;
	}
	indx = ((V->doodleColor & mask1) | mask2);
	xcolor = XColorCellOfView(V, indx);
	color.red = xcolor->red / 256;
	color.green = xcolor->green / 256;
	color.blue = xcolor->blue / 256;

	if ((V->type == V_SHEET)||(V->type == V_TEXT))
	{
		for (i = 0; i < length; i++)
		{
			myDoodle[i].x = V->Scroll_x + doodle[i].x;
			myDoodle[i].y = V->Scroll_y + doodle[i].y;
		}
	}
	else if ((V->type == V_RASTER)||(V->type == V_WHITEBOARD))
	{
		for (i = 0; i < length; i++)
		{
			myDoodle[i].x = doodle[i].x;
			myDoodle[i].y = doodle[i].y;
		}
	}

	if ((V->cData)&&(V->ispub))
	{
		status = NetSendDoodle(outP, V->cData->name, length,
			width, myDoodle, &color,
			discrete, doQueue, 0, "RasView");
	}
	FREE((char *)myDoodle);
	return(status);
}

