/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
/* $Id: animUI.h,v 1.5 1993/09/03 19:43:45 davet Exp $ */


#define ANIM_MODULE_NAME	"Animation"

typedef enum { A_FORWARD, A_REVERSE, A_PAUSE } RunStatus;

typedef struct {
	int tag;
	int ref;
	} JS_annoy_me;

static struct Methods {
	void (*make_frame)(/* Animation *anim, int xdim, int ydim,
			    unsigned char *image, float expandX,
			    float expandY */);
	void (*display_frame)(/* Animation *anim */);
	void (*destroy_frames)(/* Animation *anim */);
	} pixmapMethods, inMemoryMethods, inDiskMethods;

typedef struct  {
	char 	*title;
	Widget	top;
	Widget	mainWindow;
	Widget	menuBar;
	Widget	pulldown[10];
	Widget	button[10];
	Widget	buttonBox;
	Widget	slider;
	short	width;	/* slider width */
	Widget	animWindow;
	GC	animWindowGC;
	XImage	*ximage;
        Colormap cmap;
	Boolean badAllocError; /* set when server runs out of memory */

	struct Methods *methods;

	Data	*data;
	int	creationComplete;

	XtIntervalId	interv_id;
	RunStatus	runStatus;
	AnimRunType	runType;

	int	numFrames;
	int	curFrame;
	int	frame_dimX;
	int	frame_dimY;

	List	pixmapList;
	List	dataList;
	unsigned char *image_buff;
	FILE	*file_pointer;

	Boolean useAllEntries;
	XColor	ccells[256];
	Boolean displayNewPalette;
	Boolean showFrameNumber;

	int	delayedRead;
	JS_annoy_me *tagRefs;
	int	numTagRefs;
	char	*fileName;
	float	expandX;
	float	expandY;
	} Animation;
