
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)rghp.c	1.2	(NCSA)	8/11/87";
#endif lint

/*

rghp.c by Aaron Contorer for NCSA
Copyright 1987, board of trustees, University of Illinois

Routines for HP-GL plotter output.  Only 1 window output at a time.

*/

#define TRUE 1
#define FALSE 0

static char *HPname = "Hewlett-Packard HP-GL plotter";
static char busy; /* is device already in use */
static int winbot,winleft,wintall,winwide;
	/* position and size of window into virtual space */
static int (*outfunc)();
	/* the function to call with pointer to strings */
static char HPtext[100];
	/* the string containing the HP-GL output text */
static int HPpenx,HPpeny;
static int HPblank;
static int HPcolor;

static signore(s)
char *s;
/* Ignore the string pointer passed here. */
{}


RGHPoutfunc(f)
int (*f)();
/*
	Specify the function that is to be called with pointers to all
	the HP-GL strings.
*/
{
	outfunc = f;
}


static HPbegin()
/* set up environment for whole new printout */
{
	(*outfunc)("IN;SP1;SC-50,4370,-100,4120;PU0,0;");
	HPpenx = HPpeny = 0;
}

int RGHPnewwin()
{
	if (busy) return(-1);

	HPtext[0] = '\0';
	HPpenx = HPpeny = 0;
	HPblank = TRUE;
	HPcolor = 100;
	return(0);
}

RGHPclrscr(w){
	RGHPpagedone(w);
}

RGHPclose(w) {
	RGHPclrscr(w);
	busy=FALSE;
}

RGHPpoint(w,x,y) {
	(*outfunc)("PD;PU;");
} 

RGHPdrawline(w,x0,y0,x1,y1)
int w,x0,y0,x1,y1;
{
	if (HPblank) {
		HPbegin();
		HPblank = FALSE;
	}

	if (x0 != HPpenx || y0 != HPpeny) {
		/* only move pen if not already there */
		sprintf(HPtext,"PU%d,%d;",x0, y0);
		(*outfunc)(HPtext);
	}
	sprintf(HPtext,"PD%d,%d;",x1, y1);
	(*outfunc)(HPtext);
	HPpenx=x1;
	HPpeny=y1;
}

RGHPpagedone(w) {
	(*outfunc)("PG;");
	HPblank = TRUE;
}

RGHPdataline(w,data,count) {}

RGHPpencolor(w,color) {
	color &= 7;
	if (color) {
		sprintf(HPtext,"SP%d;",color);
		(*outfunc)(HPtext);
	}
}

RGHPcharmode(w,rotation,size) {}
RGHPshowcur() {}
RGHPlockcur() {}
RGHPhidecur() {}
RGHPbell(w) {}
RGHPuncover(w) {}

char *RGHPdevname() {
	return(HPname);
}

RGHPinit() {
	busy=FALSE;
	outfunc=signore;
}

RGHPinfo(w,a,b,c,d,v) {}

RGHPgmode() {}
RGHPtmode() {}
