#ifndef lint
static char *SCCSid = "%W%	(NCSA)	%G%";
#endif lint

/*
** Raster Virtual Kernel
*/

#define RASTER_MASTER
#define MASTERDEF

#include <stdio.h>
#include "rr.h"
#include "vr.h"

extern char *malloc();
/*
** global vars
*/

static int			VRstate = DONE;		/* current state */
static int			VRcmdnum = -1;		/* current command */
static int			VRargcount = 0;		/* number of args for command */
static int			VRdatalen = 0;		/* length of expected data */
static int			VRbufpos = 0;		/* current pointer in tempdata */
static union arg	VRargs[MAXARGS];	/* argument vector */
static char			VRtempdata[256];	/* temporary storage while parsing */
static char         *VRspace;			/* storage for incoming data */
static char			*VRptr;				/* pointer for data buffer */
static char			*VRptr2;			/* copy of above */

/*
** VRinit	-- initialize the VR system
**
** Arguments:
**
**	None.
**
** Returns:
**
**	int		-- status, 1 == succsessful, 0 == failed
*/

int VRinit()
{
	VRhead.w_next = (VRW *)0L;
	VRspace = (char *)malloc(LINEMAX+10);
	if (VRspace)
		return 1;
	else
		return 0;
}

/*
** VRwrite -- parse a string of VR commands
** 
** Arguments:
**
**	char *b;	-- buffer pointer
**	int	len;	-- buffer length
**
** Returns:
**
**	int			-- Number of characters processed.  0 tells
**				-- the upper level to switch out of raster mode;
**				-- usually on error, but also at completion of
**				-- command processing.
**
*/

int VRwrite(b, len)
char	*b;
int		len;
{

	int			count = 0;
	char		*p = b;
	char		c;
	int			i;
	extern char	*strcpy();
	int			VRnextargstate();

	/*
	** loop 'til no more chars
	*/

	while (count < len) {
		c = *p;

		switch (VRstate) {
			case DONE:

				if (c == ESC)
					VRstate = ESCFOUND;
				else
					return count;
				break;

			case ESCFOUND:

				if (c == CMDTRM)
					VRstate = WANTCMD;
				else {
					VRstate = DONE;
					return count;
				}
				break;

			/*
			** looking for a valid command char
			*/

			case WANTCMD:

				for (i = 0; i < NCMDS; i++) {
					if (cmdtab[i].c_name == c)
						break;
				}

				VRcmdnum = i;

				/*
				** not a valid command, so later
				*/

				if (VRcmdnum == NCMDS) {
					VRstate = DONE;
					return 0;
				}

				/*
				** set up for this command
				*/

				VRargcount = 0;
				VRbufpos = 0;

				VRstate = WANTDEL;
				break;

			/*
			** look for that first ;
			*/

			case WANTDEL:
				if (c == DELIM)
					VRstate = VRnextargstate(VRargcount, VRcmdnum);
				else {
					VRstate = DONE;
				}
				break;

			/*
			** looking for an integer arg
			*/

			case IARG:
				switch (c) {

					/*
					** we've found the end of the argument, so
					** try to put into the vector for later use
					*/

					case DELIM:
					case CMDTRM:
						VRtempdata[VRbufpos] = '\0';

						/*
						** copy into argument union
						*/

						(void)sscanf(VRtempdata,"%d",&VRargs[VRargcount].a_num);
						VRbufpos = 0;

						VRargcount++;
						if (c == DELIM)
							VRstate = VRnextargstate(VRargcount, VRcmdnum);
						else
							if (cmdtab[VRcmdnum].c_flags & FL_DATA)
								VRstate = DATA;
							else {

								/*
								** run the command
								*/

								(*cmdtab[VRcmdnum].c_func)(VRargs, (char *)0L);
								VRstate = DONE;
							}

						break;

					/*
					** copy over characters for later
					*/

					default:
						VRtempdata[VRbufpos++] = c;
				}
				break;

			/*
			** looking for string arg
			*/

			case SARG:
				switch (c) {

					/*
					** put string into argument vector
					*/

					case DELIM:
					case CMDTRM:
						
						VRtempdata[VRbufpos] = '\0';
/*
						VRargs[VRargcount].a_ptr = malloc((unsigned)VRbufpos+1);
*/
						
						if (VRargs[VRargcount].a_ptr == (char *)0L) {
							VRstate = DONE;
							break;
						}

						(void)strcpy(VRargs[VRargcount].a_ptr, VRtempdata);
						VRbufpos = 0;
						VRargcount++;
						if (c == DELIM)
							VRstate = VRnextargstate(VRargcount, VRcmdnum);
						else
							if (cmdtab[VRcmdnum].c_flags & FL_DATA)
								VRstate = DATA;
							else {

								/*
								** run the command
								*/

								(*cmdtab[VRcmdnum].c_func)(VRargs, (char *)0L);
								VRstate = DONE;
							}

						break;

					/*
					** save string for later
					*/

					default:
						VRtempdata[VRbufpos++] = c;

				}
				break;

			/*
			** looking for a count argument
			*/

			case CARG:
				switch (c) {

					/*
					** we've found the end of the argument, so
					** try to put into the vector for later use
					*/

					case DELIM:
					case CMDTRM:
						VRtempdata[VRbufpos] = '\0';

						/*
						** copy into argument union
						*/

						(void)sscanf(VRtempdata,"%d",&VRdatalen);
						(void)sscanf(VRtempdata,"%d",&VRargs[VRargcount]);
						if (VRdatalen > LINEMAX)
							VRdatalen = LINEMAX;
						VRargcount++;
						VRbufpos = 0;

						if (c == DELIM)
							VRstate = VRnextargstate(VRargcount, VRcmdnum);
						else
							if (cmdtab[VRcmdnum].c_flags & FL_DATA)
								VRstate = DATA;
							else {

								/*
								** run the command
								*/

								(*cmdtab[VRcmdnum].c_func)(VRargs, (char *)0L);
								VRstate = DONE;
							}

						/*
						** allocate storage for data
						*/

						VRptr = VRspace;

						if (VRptr == (char *)0L) {
							VRstate = DONE;
							return 0;
						}
						VRptr2 = VRptr;
						decode0();			/* reset decoder */

						break;

					/*
					** copy over characters for later
					*/

					default:
						VRtempdata[VRbufpos++] = c;
				}
				break;

			/*
			** retrieve a line of data
			*/

			case DATA:
				
				/*
				** store bytes until done
				*/

				if (0 <= (i = decode1(c))) {
					*VRptr2++ = i;
					VRdatalen--;
				}

				if (!VRdatalen) {

					/*
					** we've got all of the data
					*/

					(*cmdtab[VRcmdnum].c_func)(VRargs, VRptr);
					VRstate = DONE;
				}

				break;

		}		/* end switch(VRstate)*/

		p++;
		count++;
	}			/* end while loop */

	return count;
}

/*
** VRnextargstate -- return the next state based on where we're
**				  -- at already.
**
** Arguments:
**
** int ac         -- current argument count
** int state 	  -- current state
** int c    	  -- current command
**
** Returns:
**
** int       	  -- next state to move to
**
*/

static int VRnextargstate(ac, c)
int ac;
int c;
{

	switch (cmdtab[c].c_args[ac]) {
		case INT:
			return IARG;
		case STRING:
			return SARG;
		case COUNT:
			return CARG;
		case 0:
			return DATA;

		/*
		** in case of error
		*/

		default:
			return DONE;
	}
}

/*
** VRwindow -- create a new raster window
**
** Arguments:
**
**	union arg av[];	-- the argument vector
**
**	int		av[0, 1]; 	-- upper left;
**	int		av[2, 3]; 	-- width, height
**	int		av[4];	 	-- window hardware display number
**	char	*av[5];   	-- title
**
** Returns:
**
**	None.  No provision has been made for error returns in any of
**	these routines because I don't know what to do if an error
**	occurs.  Perhaps a better man than I can figure out how to 
**	deal with this.
**	N.B -- these functions are declared as int, in the event
**	that an error return is added.
*/

int VRwindow(av)
union arg av[];
{

	VRW	*w = &VRhead;

	/*
	** go to end of list and malloc some space for a new window thing
	*/

	while (w->w_next != (VRW *)0L) {
		if (!strcmp(w->w_name,av[5].a_ptr))		/* don't re-allocate win */
			return(1);
		w = w->w_next;
	}

	w->w_next = (VRW *)malloc((unsigned)sizeof(VRW));

	if (w->w_next == (VRW *)0L)
		return 0;

	w = w->w_next;

	/*
	** fill in the new window area
	*/

	w->w_left = av[0].a_num;
	w->w_top = av[1].a_num;
	w->w_width = av[2].a_num;
	w->w_height = av[3].a_num;
	w->w_display = av[4].a_num;
	w->w_name = av[5].a_ptr;

	/*
	** keep list terminated
	*/

	w->w_next = (VRW *)0L;

	return RRwindow(w);
}

/*
** VRdestroy -- destroy a window by name
**
** Arguments:
**
**   union arg av[]; -- the argument vector
**
**   char *av[0] -- the name of the window
**
** Returns:
**
**   None.
**
*/

int VRdestroy(av)
union arg av[];
{
	VRW			*w = &VRhead;
	VRW		 	*ow;
	extern int	strcmp();

	while (w->w_next != (VRW *)0L) {
		ow = w;
		w = w->w_next;
		if (!strcmp(w->w_name, av[0].a_ptr)) {
			(void)RRdestroy(w);
			ow->w_next = w->w_next;
			(void)free((char *)w);
			return 1;
		}
	}

	return 0;
}

/*
** VRmap -- take a color map command and set the palette
**
** Arguments:
**
**   union arg av[]; -- the argument vector
**
**   int 	av[0, 1];  -- start & length of map segment
**	 int	av[2];     -- count of data needed (info only)
**	 char	*av[3];    -- window name
**   char	*data;     -- pointer to the data  
**
** Returns:
**
**   None.
**
*/

int VRmap(av,data)
union arg	av[];
char		*data;
{
	VRW			*w;
	VRW			*VRlookup();

	w = VRlookup(av[3].a_ptr);

	if (w == (VRW *)0L)
		return 0;

	return RRmap(w, av[0].a_num, av[1].a_num, av[2].a_num, data);
}

/*
** VRpixel -- display a line of pixel data
** 
** Arugments:
**
**	union arg av[]; -- the argument vector
**
**	int		av[0];  -- x coordinate
**	int	 	av[1];  -- y coordinate
**	int	 	av[2];  -- length of data
**	char	*av[3]; -- window name
**	char	*data;  -- pointer to data
**
** Returns:
**
**	None.
**
*/

int VRpixel(av, data)
union arg	av[];
char		*data;
{
	VRW *w;
	VRW *VRlookup();

	/*
	** find the right window
	*/

	w = VRlookup(av[3].a_ptr);

	if (w == (VRW *)0L)
		return 0;

	return RRpixel(w, av[0].a_num, av[1].a_num, av[2].a_num, data);

}

/*
** VRrle -- display a line of run-length encoded data
** 
** Arugments:
**
**	union arg av[]; -- the argument vector
**
**	int		av[0];  -- x coordinate
**	int	 	av[1];  -- y coordinate
**	int	 	av[2];  -- length of data
**	char	*av[3]; -- window name
**	char	*data;  -- pointer to data
**
** Returns:
**
**	None.
**
*/

int VRrle(av, data)
union arg	av[];
char		*data;
{
	VRW *w;
	VRW *VRlookup();

	/*
	** find the right window
	*/

	w = VRlookup(av[3].a_ptr);

	if (w == (VRW *)0L)
		return 0;

	return RRrle(w, av[0].a_num, av[1].a_num, av[2].a_num, data);

}

/*
** VRfile	-- cause the named window to be dumped to a file
**
** Arguments:
**
**	union arg av[];		-- the argument vector
**
**	int		av[0];		-- start x coordinate
**	int		av[1];		-- start y coordinate
**	int		av[2];		-- width of region to dump
**	int		av[3];		-- height of region to dump
**	int		av[4];		-- format of file -- machine dependent
**	char	*av[5];		-- file name to use
**	char	*av[6];		-- window name to dump
**
** Returns:
**
**	int;				-- 1 if success, 0 if failure
**
*/

int VRfile(av)
union arg av[];
{
	VRW	*w;
	VRW	*VRlookup();

	/*
	** Look up the window
	*/

	w = VRlookup(av[6].a_ptr);

	if (w == (VRW *)0L)
		return 0;

	/*
	** call the low level file routine
	*/

	return RRfile(w, av[0].a_num, av[1].a_num, av[2].a_num, av[3].a_num,
		av[4].a_num, av[5].a_ptr);

}

/*
** VRclick	-- Click the Slide Camera -- very machine dependent
**
** Arguments:
**
**	union arg	av[];		-- the argument vector
**
**	char	*av[0];			-- window name
**
** Returns:
**
**	int;					-- 1 if success, 0 if failure
*/

int VRclick(av)
union arg av[];
{
	VRW	*w;
	VRW	*VRlookup();

	/*
	** look up the window
	*/

	w = VRlookup(av[0].a_ptr);

	if (w == (VRW *)0L)
		return 0;

	return RRclick(w);
}

/*
** VRmsave	-- Save the named colormap to the file -- saves the whole thing
**
** Arguments:
**
**	union arg	av[];		-- the argument vector
**
**	char	*av[0];			-- file name
**	char	*av[1];			-- window name
**
** Returns:
**
**	int;					-- 1 if success, 0 if failure
*/

int VRmsave(av)
union arg av[];
{
	VRW	*w;
	VRW	*VRlookup();

	/*
	** look up the window
	*/

	w = VRlookup(av[1].a_ptr);

	if (w == (VRW *)0L)
		return 0;

	return RRmsave(w, av[0].a_ptr);
}

/*
** VRlookup			-- find an entry in the list by name
**
** Arguments:
**
**	char	*name;	-- the name of the window
**
** Returns:
**
**	VRW	*w;			-- pointer to window structure, (VRW *)0 if not found
**
*/

VRW *VRlookup(name)
char *name;
{
	VRW	*w = VRhead.w_next;

	while (w != (VRW *)0L) {
		if (!strcmp(w->w_name, name))
			return w;
		w = w->w_next;
	}

	return (VRW *)0L;
}

/*
** VRcleanup -- remove all windows from the screen
**
** Arguments:
**
**	None.
**
** Returns:
**
**	int;	1	-- always successful, or there's nothing you can do
**				-- about it anyways...
**
*/

int VRcleanup()
{
	VRW *w = VRhead.w_next;
	VRW *x;

	while (w != (VRW *)0L) {
		x = w->w_next;
		(void)RRdestroy(w);
		w = x;
	}

	return 1;
}

/************************************************************************/
/*  decoding
*   handle the special ASCII printable character encoding of data bytes.
*/

/***********************************************************************/
/*
*  123 precedes #'s 0-63 
*  124 precedes #'s 64-127
*  125 precedes #'s 128-191
*  126 precedes #'s 192-255
*  overall:  realchar = (specialchar - 123)*64 + (char-32) 
*            specialchar = r div 64 + 123
*            char = r mod 64 + 32
*/
/***********************************************************************/

#ifdef doFRAME
frsend(fd,buf,buflen)
	char *buf;
	int fd,buflen;
	{
	char nb[2];
	char *p,myeol;
	int newl;

	newl = 2;
	myeol = EOL;

	write(fd,frs,2);			/* start of frame */
	p = buf;
	while (buflen > 0) {	/* empty buffer */
		while (*p > 31 && *p < SYN && buflen > 0 && ++newl < 74) {
			p++;			/* skip legal chars */
			buflen--;
		}
		if (p > buf) {				/* write out this range */
			write(fd,buf,p-buf);
			buf = p;
		}
		if (newl > 72) {
			write(fd,&myeol,1);		/* write spacer */
			newl = 0;
		}
		while ((*p < 32 || *p >= SYN) && buflen > 0) {
			if (*p == EOL)
				newl = 0;
			nb[0] = (*p>>6) + 123;		/* special escape char */
			nb[1] = (*p & 0x3f) + 32;	/* encoded char */
			write(fd,nb,2);	
			buflen--; p++;
			buf = p;
			if (++newl > 72) {
				write(fd,&myeol,1);			/* send one */
				newl = 0;
			}
		}
	}

	write(fd,fre,2);			/* end of frame */

}
#endif

/***********************************************************************/
/* decode0 and decode1
*  start and continue the decoding.
*
*  Returns real characters, 0 if in the middle of an escape sequence.
*/

#define FRSKIP 0
#define FRIN 1
#define FRSPECIAL 2
#define FROVER 3
#define FRDONE 4

static int dstate=FRSKIP,dspec=0;
/*
*  set up receive
*/
decode0()
	{
	dstate = FRIN;
}

decode1(c)
	int c;
	{
	int h;

	switch (dstate) {
	case FRSKIP:
		return(-1);

	case FRIN:						/* decoding */
		if (c > 31 && c < 123)
			return(c);
		else {
			dspec = c;				/* save special character */
			dstate = FRSPECIAL;		/* doing special character */
		}
		return(-1);
	case FRSPECIAL:
		switch (dspec) {
		case 123:
		case 124:
		case 125:
		case 126:			/* encoded character */
			dstate = FRIN;
			return(((dspec - 123)<< 6) - 32 + c);
		default:			/* mistaken character in stream */
			dstate = FRIN;  /* assume not special */
			return(decode1(c));  /* check for sure */
			break;
		}
		break;

	}

}
