#ifndef TRUE
#define	TRUE	(1==1)
#endif

#ifndef FALSE
#define	FALSE	(0==1)
#endif

#define	BOOLEAN	0
#define INT	1
#define	FLOAT	2
#define	STRING	3
#define ARG_DEF(s,m,t,size,v,d)		{s,m,t,size,(int *)v,FALSE,d}
#define ARG_LAST			{NULL,0,NULL,0,NULL,FALSE}


/* Basic element used for switch definition table */
typedef struct args_s {
	char * switchname;	/* Name of switch to match */
	int mandatory;		/* TRUE if required, FALSE otherwise */
	int type;		/* Type of switch data */
	int size;		/* Number of arguments in data */
	int * value;		/* Pointer to data storage area */
	int found;		/* TRUE if exists on command-line */
	char * description;	/* Description of switch used for usage */
} args_t;


/* Function Prototypes */
int args_found_arg(args_t [], char *);
int args_usage(char * [], args_t []);
int args_dump_args(args_t []);
static int args_dump_arg(args_t [], int i);
int args_parse(int, char * [], args_t []);
static int args_parse_value(int, char * [], args_t [], int *, int);
