#include "df.h"
#include "globals.h"

/************************************************************************
*																		*
*	char *mDFgetelement(fName, dfile, tag, ref, length, accessMsg)		*
*	Error Checking code for reading in HDF elements.					*
*																		*
************************************************************************/
unsigned char *mDFgetelement(fName, dfile, tag, ref, length, accessMsg)
unsigned char *dfile;
int tag, ref;
int	*length;
unsigned char *accessMsg;
{
	unsigned char *dataPtr;
	int	offset, len;
	
	if(DFaccess( dfile, tag, ref, "r")<0) {
		if(accessMsg != NULL)
			printf(accessMsg);
		else
			printf("Error accessing file %s\n", fName);
		return(NULL);
	}
	if(DFgetdd(dfile, &tag, &ref, &offset, &len) < 0)
		return(NULL);
	if((dataPtr = mMalloc(len + 1)) == NULL)
		return (NULL);
	if(DFread(dfile, dataPtr, len) < 0) {
		free(dataPtr);
		printf("Error reading file %s\n", fName);
		return(NULL);
	}
	*length = len;
	*(dataPtr + len) = 0;	/* In case it is text */
	return(dataPtr);
}


/************************************************************************
*																		*
*	char *ReadImage(fName, x, y, palette)								*
*	Low level routine for reading in an Image from an HDF file.			*
*	It performs error checking and prints all the appropriate messages.	*
*	If palette is nil, then no palette is saved.						*
*																		*
************************************************************************/
unsigned char *ReadImage(fName, x, y, palette)
	int *x, *y;
	unsigned char *fName;
	unsigned char *palette;
{
	unsigned char *theData;
	int isPal;
	unsigned char *pal, trashPal[768];
	

	if(DFR8getdims(fName, x, y, &isPal) < 0) {
		printf("Dimensions not found in '%s'.\n", fName);
		return(NULL);
	}
	if(palette == NULL)
		pal = trashPal;
	else {
		pal = palette;
		if(!isPal) {
			printf("Palette not found in '%s'.\n", fName);
			return(NULL);
		}
	}
	theData = mMalloc((*x) * (*y));
	if(theData == NULL)
		return(NULL);
	if(DFR8getimage(fName, theData, *x, *y, pal) < 0) {
		printf("Error reading image from '%s'.\n", fName);
		free(theData);
		return(NULL);
	}
	return(theData);
}


/************************************************************************
*																		*
*	int WriteImage(fName, x, y, theImage, palette, mode)				*
*	Low level routine for reading in an Image from an HDF file.			*
*	It performs error checking and prints all the appropriate messages.	*
*	If palette is nil, then no palette is saved.						*
*																		*
************************************************************************/
int WriteImage(fName, theImage, x, y, palette, mode)
	unsigned char *fName;
	int x, y;
	unsigned char *theImage;
	unsigned char *palette;
	int mode;
{
	DFR8setpalette(palette);
	if(mode)
		mode = DFTAG_RLE;
	if(DFR8putimage(fName, theImage, x, y, mode) < 0) {
		printf("Error writing file '%s',\n", fName);
		return(-1);
	}
	return(0);
}


/************************************************************************
*																		*
*	 DFgetdd(dfile, tag, ref, offset, length)							*
*	Extra support for HDF.  Returns all the information of the DFdd		*
*	in individual variables.											*
*																		*
************************************************************************/
int DFgetdd(dfile, tag, ref, offset, length)
DF *dfile;
int *tag, *ref, *offset, *length;
{
	DFdd *dd;
	
	dd = dfile->up_dd;
	*tag = dd->tag;
	*ref = dd->ref;
	*offset = dd->offset;
	*length = dd->length;
	return(0);
}