/* SCCS @(#)i_osto_pos.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                          i_osto_pos.callback.c                       */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   i_osto_pos.callback.c                               */
/*                                                                      */
/* DESCRIPTION  :   IO operations of LaboImage (store and postscript)   */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "libwidgets/widgetstructure.h"
#include "i_osto_pos.layout.h"
#include <Xm/FileSB.h>
#include <Xm/Text.h>
#include "sauve4.h"

extern struct fname *lire_fname ();
extern struct fname *lire_repertoire_gel ();
extern void Ote_ima_des ();

extern Display *gDisplay;
extern Cursor  gWatchcursor;
extern Widget  gLabowidget;

/******************************************************
/   cancelCallback for Widget  IO_store_post_file_selection 
/*****************************************************/

void
IO_store_post_file_CANCEL_callb(IO_store_post_file_selection, IO_store_post_file_widget, callData)
	Widget IO_store_post_file_selection;
	Widget IO_store_post_file_widget;
	caddr_t callData;
{
	XtUnmanageChild (IO_store_post_file_widget);
}


/******************************************************
/   okCallback for Widget  IO_store_post_file_selection 
/*****************************************************/

void
IO_store_single_OK_callb(IO_store_post_file_selection, 
			IO_store_post_file_widget, callData)
	Widget IO_store_post_file_selection;
	Widget IO_store_post_file_widget;
	caddr_t callData;
{
  struct fname *fn;
  char *filedes;

  if (filedes != NULL) free(filedes);

  filedes = XmTextGetString (XmFileSelectionBoxGetChild 
			   (IO_store_post_file_selection, XmDIALOG_TEXT));

  /* we dont accept an empty label */
  if (strlen (filedes) == 0) 
    sprintf (filedes, "%s/image_save", getenv("HOME"));
  else Ote_ima_des(&filedes);

  /* mise a jour de la variable globale: repertoire_save */
  strcpy (repertoire_save, XmTextGetString (XmFileSelectionBoxGetChild 
					  (IO_store_post_file_selection, 
					   XmDIALOG_FILTER_TEXT)));

  sprintf (buf,mastertabs[233]);
  write_master (buf);

  sprintf (buf, "%d ", index_image[0]);
  write_master (buf);

  sprintf (buf, "--> %s\n", filedes);
  write_master (buf);

  fn = lire_fname (filedes, 20);

  if (fn->fpdesc != NULL && fn->fpim != NULL) 
  {
    desc.type = dir_desc[index_image[0]].type;
    sauve_fichier (index_image[0], -1, -1, fn);
  }
  else  
    write_erreur(931);

  XtUnmanageChild (IO_store_post_file_widget);
  free(filedes);
}

/******************************************************
/   okCallback for Widget  IO_store_post_file_selection 
/*****************************************************/

void
IO_store_cartesian_OK_callb(IO_store_post_file_selection, 
			IO_store_post_file_widget, callData)
	Widget IO_store_post_file_selection;
	Widget IO_store_post_file_widget;
	caddr_t callData;
{
  struct fname *fn;
  char *filedes;

  if (filedes != NULL) free(filedes);

  filedes = XmTextGetString (XmFileSelectionBoxGetChild 
			   (IO_store_post_file_selection, XmDIALOG_TEXT));

  /* we dont accept an empty label */
  if (strlen (filedes) == 0) 
           sprintf (filedes, "%s/image_save", getenv("HOME"));
  else Ote_ima_des(&filedes);

  /*mise a jour de la variable globale: repertoire_save*/
  strcpy (repertoire_save, XmTextGetString (XmFileSelectionBoxGetChild 
					  (IO_store_post_file_selection, 
					   XmDIALOG_FILTER_TEXT)));

  sprintf (buf,mastertabs[234]);
  write_master (buf);

  sprintf (buf, "(%d %d) ", index_image[0], index_image[2]);
  write_master (buf);

  sprintf (buf, "--> %s\n", filedes);
  write_master (buf);

  if (dir_desc[index_image[0]].type < 3 && dir_desc[index_image[2]].type < 3 )
     write_erreur (14);    
  else
  {
    fn = lire_fname (filedes, 20);

    if (fn->fpdesc != NULL && fn->fpim != NULL) 
    {
      desc.type = 4;
      sauve_fichier (index_image[0], index_image[2], -1, fn);
    }
    else  
      write_erreur(931);
  }
  XtUnmanageChild (IO_store_post_file_widget);
  free(filedes);
}


/******************************************************
/   okCallback for Widget  IO_store_post_file_selection 
/*****************************************************/

void
IO_store_polar_OK_callb(IO_store_post_file_selection, 
			IO_store_post_file_widget, callData)
	Widget IO_store_post_file_selection;
	Widget IO_store_post_file_widget;
	caddr_t callData;
{
  struct fname *fn;
  char * filedes;

  if (filedes != NULL) free(filedes);

  filedes = XmTextGetString (XmFileSelectionBoxGetChild 
			   (IO_store_post_file_selection, XmDIALOG_TEXT));

  /* we dont accept an empty label */
  if (strlen (filedes) == 0) 
           sprintf (filedes, "%s/image_save", getenv("HOME"));
  else Ote_ima_des(&filedes);

  /*mise a jour de la variable globale: repertoire_save*/
  strcpy (repertoire_save, XmTextGetString (XmFileSelectionBoxGetChild 
					  (IO_store_post_file_selection, 
					   XmDIALOG_FILTER_TEXT)));

  sprintf (buf,mastertabs[235]);
  write_master (buf);

  sprintf (buf, "(%d %d) ", index_image[0], index_image[2]);
  write_master (buf);

  sprintf (buf, "--> %s\n", filedes);
  write_master (buf);

  if (dir_desc[index_image[0]].type < 3 && dir_desc[index_image[2]].type < 3 )
    write_erreur(14);
  else
  {
    fn = lire_fname (filedes, 20);

    if (fn->fpdesc != NULL && fn->fpim != NULL) 
    {
      desc.type = 5;
      sauve_fichier (index_image[0], index_image[2], -1, fn);
    }
    else  
      write_erreur(931);

  }
  XtUnmanageChild (IO_store_post_file_widget);
  free (filedes);
}


/******************************************************
/   okCallback for Widget  IO_store_post_file_selection 
/*****************************************************/

void
IO_store_rgb_OK_callb(IO_store_post_file_selection, 
			IO_store_post_file_widget, callData)
	Widget IO_store_post_file_selection;
	Widget IO_store_post_file_widget;
	caddr_t callData;
{
  struct fname *fn;
  char * filedes;

  if (filedes != NULL) free(filedes);

  filedes = XmTextGetString (XmFileSelectionBoxGetChild 
			   (IO_store_post_file_selection, XmDIALOG_TEXT));

  /* we dont accept an empty label */
  if (strlen (filedes) == 0) 
           sprintf (filedes, "%s/image_save", getenv("HOME"));
  else Ote_ima_des(&filedes);


  /*mise a jour de la variable globale: repertoire_save*/
  strcpy (repertoire_save, XmTextGetString (XmFileSelectionBoxGetChild 
					  (IO_store_post_file_selection, 
					   XmDIALOG_FILTER_TEXT)));

  sprintf (buf,mastertabs[236]);
  write_master (buf);
  sprintf(buf,"(%d %d %d) ",index_image[0],index_image[2],index_image[4]);
  write_master (buf);
  sprintf (buf, "--> %s\n", fn->filename);
  write_master (buf);
  
  if ((dir_desc[index_image[0]].type != 0) && (dir_desc[index_image[2]].type != 0) && (dir_desc[index_image[4]].type != 0))
      write_erreur (988);
  else
  {
    fn = lire_fname (filedes, 20);

    if (fn->fpdesc != NULL && fn->fpim != NULL) 
    {
      desc.type = 6;
      sauve_fichier (index_image[0],index_image[2],index_image[4], fn);
    }
    else  
      write_erreur(931);

  }
  XtUnmanageChild (IO_store_post_file_widget);
  free(filedes);
}



/******************************************************
/   okCallback for Widget  IO_store_post_file_selection 
/*****************************************************/

void
IO_store_melanie_OK_callb(IO_store_post_file_selection, 
			IO_store_post_file_widget, callData)
	Widget IO_store_post_file_selection;
	Widget IO_store_post_file_widget;
	caddr_t callData;
{
  struct fname *fn;
  char * dirgel;

  if (dirgel != NULL) free(dirgel);

  dirgel = XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_store_post_file_selection, XmDIALOG_TEXT));

  /* we dont accept an empty label */
  if (strlen (dirgel) == 0) 
           sprintf (dirgel, "%s/gel_save", getenv("HOME"));


  /*mise a jour de la variable globale: repertoire_save*/
  strcpy (repertoire_save, XmTextGetString (XmFileSelectionBoxGetChild 
					    (IO_store_post_file_selection, 
					     XmDIALOG_FILTER_TEXT)));

  fn = lire_repertoire_gel (dirgel, 1);

  if (fn->fpdesc != NULL && fn->fpim != NULL) 
  {
    desc.type = dir_desc[index_image[0]].type;
    sauve_gel (index_image[0], fn);
  }  
  else  
    write_erreur(931);
    
  XtUnmanageChild (IO_store_post_file_widget);
  free(dirgel);
}


/******************************************************
/   okCallback for Widget  IO_store_post_file_selection 
/*****************************************************/

void
IO_store_sun_OK_callb(IO_store_post_file_selection, 
			IO_store_post_file_widget, callData)
	Widget IO_store_post_file_selection;
	Widget IO_store_post_file_widget;
	caddr_t callData;
{
  struct fname *fn;
  char * filedes;
  int type;

  if (filedes != NULL) free(filedes);

  filedes = XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_store_post_file_selection, XmDIALOG_TEXT));

  /* we dont accept an empty label */
  if (strlen (filedes) == 0) 
           sprintf (filedes, "%s/image_save", getenv("HOME"));

  /*mise a jour de la variable globale: repertoire_save*/
  strcpy (repertoire_save, XmTextGetString (XmFileSelectionBoxGetChild 
					    (IO_store_post_file_selection, 
					     XmDIALOG_FILTER_TEXT)));

  sprintf (buf,mastertabs[237]);
  write_master (buf);
  sprintf (buf, "%d ", index_image[0]);
  write_master (buf);

  sprintf (buf, "--> %s\n", filedes);
  write_master (buf);

  type = dir_desc[index_image[0]].type;

  if (type > 0)
      write_erreur(16);
  else
  {
    fn = lire_fname (filedes, 31);
	
    if (fn->fpim != NULL) 
     sauve_rasterfile (fn, (unsigned char *)dir_image[index_image[0]].image,
			dir_desc[index_image[0]].nligne,
			dir_desc[index_image[0]].ncolonne);
    else  
      write_erreur(931);
  }

  XtUnmanageChild (IO_store_post_file_widget);
  free(filedes);
}


/******************************************************
/   okCallback for Widget  IO_store_post_file_selection 
/*****************************************************/

void
IO_post_normal_OK_callb(IO_store_post_file_selection, 
			IO_store_post_file_widget, callData)
	Widget IO_store_post_file_selection;
	Widget IO_store_post_file_widget;
	caddr_t callData;
{
  struct fname *fn;
  char *filedes;
  unsigned char *image;
  int type, ligne, colonne;
  float mmin, mmax;

  XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
  XDefineCursor(gDisplay, 
		XtWindow(IO_store_post_file_widget), gWatchcursor);
  XFlush(gDisplay);

  if (filedes != NULL) free(filedes);

  filedes = XmTextGetString (XmFileSelectionBoxGetChild 
			   (IO_store_post_file_selection, XmDIALOG_TEXT));

  if (strlen (filedes) == 0) 
           sprintf (filedes, "%s/image_postcript", getenv("HOME"));
  else Ote_ima_des(&filedes);

  /*mise a jour de la variable globale: repertoire_save*/
  strcpy (repertoire_save, XmTextGetString (XmFileSelectionBoxGetChild 
					  (IO_store_post_file_selection, 
					   XmDIALOG_FILTER_TEXT)));

  sprintf (buf, mastertabs[230]);
  strcat (buf, mastertabs[231]);
  write_master (buf);

  sprintf (buf, "%d ", index_image[0]);
  write_master (buf);

  sprintf (buf, "--> %s\n", filedes);
  write_master (buf);

  fn = lire_fname (filedes, 21);

  if (fn->fpdesc != NULL && fn->fpim != NULL) 
  {
    if (dir_image[index_image[0]].image == NULL)
    {
      write_erreur(1);
      XUndefineCursor(gDisplay, XtWindow(gLabowidget));
      XUndefineCursor(gDisplay, XtWindow(IO_store_post_file_widget));
      return;
    }

    type = dir_desc[index_image[0]].type;

    if (type > 0)
      write_erreur(16);
    else 
    {
      ligne = dir_desc[index_image[0]].nligne;
      colonne = dir_desc[index_image[0]].ncolonne;
      image = dir_image[index_image[0]].image;
      mmin = dir_desc[index_image[0]].mmin;
      mmax = dir_desc[index_image[0]].mmax;
      fichier_laser(0, ligne, colonne, mmin, mmax, image, fn->fpim);
    }
  }
  else
      write_erreur(931);

  XUndefineCursor(gDisplay, XtWindow(gLabowidget));
  XUndefineCursor(gDisplay, XtWindow(IO_store_post_file_widget));

  XtUnmanageChild (IO_store_post_file_widget);
  free(filedes);
}


/******************************************************
/   okCallback for Widget  IO_store_post_file_selection 
/*****************************************************/

void
IO_post_max_OK_callb(IO_store_post_file_selection, 
			IO_store_post_file_widget, callData)
	Widget IO_store_post_file_selection;
	Widget IO_store_post_file_widget;
	caddr_t callData;
{
  struct fname *fn;
  char *filedes;
  unsigned char *image;
  int type, ligne, colonne;
  float mmin, mmax;

  XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
  XDefineCursor(gDisplay, 
		XtWindow(IO_store_post_file_widget), gWatchcursor);
  XFlush(gDisplay);

  if (filedes != NULL) free(filedes);

  filedes = XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_store_post_file_selection, XmDIALOG_TEXT));

  if (strlen (filedes) == 0) 
    sprintf (filedes, "%s/image_postcript", getenv("HOME"));
  else Ote_ima_des(&filedes);

  /*mise a jour de la variable globale: repertoire_save*/
  strcpy (repertoire_save, XmTextGetString (XmFileSelectionBoxGetChild 
					  (IO_store_post_file_selection, 
					   XmDIALOG_FILTER_TEXT)));

  sprintf (buf, mastertabs[230]);
  strcat (buf, mastertabs[232]);
  write_master (buf);
    
  sprintf (buf, "%d ", index_image[0]);
  write_master (buf);

  sprintf (buf, "--> %s\n", filedes);
  write_master (buf);

  fn = lire_fname (filedes, 21);

  if (fn->fpdesc != NULL && fn->fpim != NULL) 
  {
    if (dir_image[index_image[0]].image == NULL)
    {
      write_erreur(1);
      XUndefineCursor(gDisplay, XtWindow(gLabowidget));
      XUndefineCursor(gDisplay, 
		    XtWindow(IO_store_post_file_widget));
      return;
    }

    type = dir_desc[index_image[0]].type;

    if (type > 0)
      write_erreur(16);
    else 
      {
	ligne = dir_desc[index_image[0]].nligne;
	colonne = dir_desc[index_image[0]].ncolonne;
	image = dir_image[index_image[0]].image;
	mmin = dir_desc[index_image[0]].mmin;
	mmax = dir_desc[index_image[0]].mmax;
	fichier_laser(1, ligne, colonne, mmin, mmax, image, fn->fpim);
      }
  }
  else
     write_erreur(931);
    
  XUndefineCursor(gDisplay, XtWindow(gLabowidget));
  XUndefineCursor(gDisplay, XtWindow(IO_store_post_file_widget));

  XtUnmanageChild (IO_store_post_file_widget);
  free(filedes);
}


