/* SCCS @(#)el.c	1.1  12/2/92 */
/*****************************************************************************/
/* module el.c								     */
/*									     */
/* Author: Rene Perrier							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   June 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

/* programme de creation de divers elements structurants utilises par le module */
/* de morphologie mathematique a niveaux de gris du programme "LaboImage"             */
/*  RENE PERRIER   15.6.88 */

# include <stdio.h>
# include <string.h>
# include <ctype.h>
# include <math.h>

#define INV_PI    0.31830988618379067154       /* = 1/pi */
#define MINSHORT -32768
#define MAXSHORT  32767

#define carre(x) ((x)*(x))
#define racine(x) ((short)sqrt ((double)x))
#define MAX(x,y)   (((x) < (y))  ?  (y) : (x))

#define EL_STRUCT struct el_struct
EL_STRUCT
         {
	 short      x;
         short      y;
         short      z;
         EL_STRUCT  *next;
	 };


/*===================================================================================*/
/*   support :                                                                       */
/*  ~~~~~~~~~~                                                                       */
/*              la procedure "support(r)" produit une liste de vecteurs 3D dont les  */
/*   coordonnees (x,y) forment le support d'un element structurant de revolution     */
/*   (cad construit en faisant tourner une courbe definie dans le plan (x,z) autour  */
/*   de l'axe z). La coordonnee z des vecteurs n'est pas initialisee.                */
/*              Pour determiner ce support, on utilise l'algorithme de Bressenham    */
/*   qui nous donne le contour d'un cercle de rayon r que l'on rempli au fur et a    */
/*   mesure.                                                                         */
/*                                                                                   */
/*   support(r) retourne un pointeur vers la liste des vecteurs.                     */

EL_STRUCT *support(r)

   short r;                          /* r = rayon de la base de l'element structurant*/

   {
   EL_STRUCT   *ptr, *ptr_debut, *ptr_fin;
   short       x,y,delta,j;
   char        cas;

   ptr = (EL_STRUCT *) malloc (sizeof(*ptr));
   ptr_debut = ptr;
   if (r == 0) cas = 0;
      else cas = 1;
   x = 0;
   y = r;
   delta = 3 - 2 * r;

   while (x < y)                                            /* x = 0  to  r/racine(2) */
      {
                      /* construction des colonnes (x,-y) a (x,y) et (-x,-y) a (-x,y) */
      for (j= -y; j<=y; j++)
         {
         ptr->x = x;  ptr->y = j;  ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
         ptr_fin = ptr;
         ptr = ptr->next;
         if (x != 0)                      /* afin de ne pas dupliquer la colonne x=0 */
            {
            ptr->x = -x;  ptr->y = j;  ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
            ptr_fin = ptr;
            ptr = ptr->next;
	    };
	 };

   switch(cas)
      {
      case 1:      /* x = x+1 et y inchange => la colonne (y,x) et (-y,x) s'agrandit */
         if (x != 0)
            {
            ptr->x = y;  ptr->y = -x;  ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
            ptr = ptr->next;
            ptr->x = -y;  ptr->y = -x;  ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
            ptr = ptr->next;
	    };
         ptr->x = y;  ptr->y = x; ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
         ptr = ptr->next;
         ptr->x = -y; ptr->y = x;  ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
         ptr_fin = ptr;
         ptr = ptr->next;
         break;

      case 2: /* x = x+1 et y = y-1 => il faut construire les colonnes (y,x) et (-y,x)*/
         for (j= -x; j<=x; j++)
            {
       	    ptr->x = y;  ptr->y = j;  ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
            ptr = ptr->next;
            ptr->x = -y;  ptr->y = j;  ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
            ptr_fin = ptr;
            ptr = ptr->next;
	    };
         break;
      };

                          /* algorithme de Bressenham */
      if (delta < 0)
         {
	 delta = delta + 4*x + 6;
         cas = 1;
	 }
      else
         {
	 delta = delta + 4*(x - y) + 10;
         cas = 2;
         y--;
	 };
      x++;

      };  /* fin de la boucle while (x<y) */

   if (x==y)    /* si x=y il faut encore rajouter des points */
      {
      switch(cas)
         {
         case 0:                        /* cas particulier r=0 => un seul vecteur */
            ptr->x = ptr->y = 0;
            ptr->next = NULL;
            break;

         case 1:      /* 4 points a rajouter */
            ptr->x = x;  ptr->y = x;  ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
            ptr = ptr->next;
            ptr->x = x;  ptr->y = -x;  ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
            ptr = ptr->next;
            ptr->x = -x;  ptr->y = x; ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
            ptr = ptr->next;
            ptr->x = -x; ptr->y = -x;  ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
            ptr_fin = ptr;
            ptr = ptr->next;
            break;

         case 2:     /* 2 colonnes a rajouter */
            for (j= -x; j<=x; j++)
               {
       	       ptr->x = y;  ptr->y = j;  ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
               ptr = ptr->next;
               ptr->x = -y;  ptr->y = j;  ptr->next = (EL_STRUCT *) malloc (sizeof(*ptr));
               ptr_fin = ptr;
               ptr = ptr->next;
	       };
            break;
	 };
      };

   if (cas != 0)
      {
      free(ptr);
      ptr_fin->next = NULL;
      };

   return(ptr_debut);
   };


/*===================================================================================*/
/*    sphere :                                                                       */
/*   ~~~~~~~~~                                                                       */
/*               la procedure sphere construit un element structurant spherique de   */
/*      rayon r en initialisant la coordonne z des vecteurs de liste pointee par ptr */
/*      par la formule suivante :                                                    */
/*                                   z = round( racine( r*r - x*x - y*y))            */
/*                                                                                   */
/*     sphere() retourne le pointeur sur la liste des vecteurs.                      */

EL_STRUCT *sphere(r)

   short      r;  /* rayon de la sphere */

   {
   EL_STRUCT  *pt, *ptr;
   short      temp;

   ptr = support(r);
   pt = ptr;
   while(pt != NULL)    /* parcours de la liste */
      {
      temp = carre(r) - carre(pt->x) - carre(pt->y);
      if (temp > 0)
         pt->z = racine(temp) + 0.5;  /* calcul de z */
      else    /* (x,y) se trouve en dehors de la sphere reele */
         pt->z = 0;
      pt = pt->next;
      }; 

   return(ptr);
   };


/*===================================================================================*/
/*    cone :                                                                         */
/*   ~~~~~~~                                                                         */
/*            la procedure cone produit un element structurant conique de rayon r et */
/*   de hauteur h en initialisant la coordonne z des vecteurs de liste pointee par   */
/*   ptr par la formule suivante :                                                   */
/*                                   z = round(h - racine(x*x + y*y)*(h/r)           */
/*                                                                                   */
/*     cone() retourne le pointeur sur la liste des vecteurs.                        */

EL_STRUCT *cone(r,h)

   short     r,h;  /* r = rayon    h = hauteur */

   {
   EL_STRUCT *pt, *ptr;
   short     temp;

   ptr = support(r);
   pt = ptr;
   while(pt != NULL)
      {
      temp =  carre(pt->x) + carre(pt->y);
      pt->z = (double)h - (racine(temp)*((double)h / (double)r)) + 0.5;
      pt = pt->next;
      };

   return(ptr);
   };


/*===================================================================================*/
/*    cylindre :                                                                     */
/*   ~~~~~~~~~~~                                                                     */
/*            la procedure cylindre produit un element structurant cylindrique de    */
/*   rayon r et de hauteur h en initialisant la coordonne z des vecteurs de liste    */
/*   pointee par ptr par la formule suivante :                                       */
/*                                   z = h                                           */
/*                                                                                   */
/*     cylindre() retourne le pointeur sur la liste des vecteurs.                    */

EL_STRUCT *cylindre(r,h)

   short     r,h;   /* r = rayon      h = hauteur */

   {
   EL_STRUCT *pt, *ptr;

   ptr = support(r);
   pt = ptr;
   while(pt != NULL)
      {
      pt->z = h;
      pt = pt->next;
      };

   return(ptr);
   };


/*===================================================================================*/
/*   gaussienne :                                                                    */
/*   ~~~~~~~~~~~~                                                                    */
/*                 la procedure gaussienne produit un element structurant ayant la   */
/*   forme d'une gaussienne d'amplitude h et d'ecarts-types sigma-x et sigma-y.      */
/*   Le support de cette gaussienne est tronque en un support rond de rayon r, ou r  */
/*   est la valeur telle que la hauteur maximale de la gaussienne sur le cercle de   */
/*   rayon r ne soit pas plus petite que 1/4.                                        */
/*   La coordonnee z des vecteurs de la liste pointee par ptr est initialisee par la */
/*   formule suivante:                                                               */
/*                                                                                   */
/*   z = h / (2 * PI * sig_x * sig_y) * exp( -1/2 (carre(x/sig_x) + carre(y/sig_y))) */
/*                                                                                   */
/*   gaussienne () retourne le pointeur sur la liste de vecteurs.                    */

EL_STRUCT *gaussienne(h,sig_x,sig_y)

   float h, sig_x, sig_y;      /* amplitude (hauteur), sigma_x, sigma_y (ecart-type) */

   {
   short       r;   /* rayon du support */
   EL_STRUCT   *pt, *ptr;
   double       borne, sig_max, temp;

   sig_max = MAX((double)sig_x, (double)sig_y);
   borne = 1.0 / 4.0;
   temp =  (double)h / 2.0 * INV_PI / (double)sig_x / (double)sig_y;

   /* boucle de determination de r */
   for (r = 1; 
       borne < (temp * exp(- 1.0 /2.0 * (carre((double)r) / (carre(sig_max)))));
       r++);

   pt = ptr = support(r);

   /* boucle de construction de la gaussienne */
   while (pt != NULL)
      {
      pt->z = temp * exp(-1.0/2.0 * ((carre((double)pt->x)/carre((double)sig_x))
                                  + (carre((double)pt->y)/carre((double)sig_y))));
      pt = pt->next;
      };

   return(ptr);
   };


/*===================================================================================*/
/*   plan_image :                                                                    */
/*   ~~~~~~~~~~~~                                                                    */
/*                la procedure plan_image produit un element structurant provenant   */
/*   d'un plan image pointe par ptr_plan. Ce plan image est de type short, sa taille */
/*   est nligne x ncolonne. Tous les point de ce plan dont la valeur est differente  */
/*   de -32768 appartiennent a l'element structurant et conservent leur valeur.      */
/*   L'origine de l'element structurant produit se situe en son centre selon x et y  */
/*   (ou au point "entier" le plus proche).                                          */
/*                                                                                   */
/*   plan_image () retourne le pointeur sur la liste de vecteurs.                    */

EL_STRUCT *plan_image(ptr_plan,nligne,ncolonne)

   short  *ptr_plan;          /* pointeur vers le plan image qui contient l'el. str. */
   short  nligne, ncolonne;   /* nb de lignes et de colonnes de ce plan */

   {
   short           *ptr;        /* pointeur de parcours du plan_image */
   EL_STRUCT       *pt1;        /* pointeur sur la liste de vecteurs */
   EL_STRUCT       *pt2;        /* pointeurs de parcours de la liste de vecteurs */
   short register  i,j;         /* indice des lignes et colonnes du plan_image */
   short           xmax, xmin, ymax, ymin;    /* coordonnees extreme de l'el. str. */
   short           tx, ty;      /* coordonnees de l'origine de l'el. str. dans le  */
                                /* plan_image                                      */

   ptr = ptr_plan;

   pt1 = pt2 = (EL_STRUCT *) malloc (sizeof(*pt1));
   pt2->next = pt2;

     /* boucle de parcours de l'image et construction de la liste de vecteurs en   */
     /* chargeant tous les points dont la valeur n'est pas -32768 ainsi que leurs  */
     /* coordonnees.                                                               */

   for (i = 0; i < nligne; i++)
      {
      for (j = 0; j < ncolonne; j++)
         {
         if (*ptr != MINSHORT)
            {
	    pt2 = pt2->next;
            pt2->x = i;
	    pt2->y = j;
	    pt2->z = *ptr;
            pt2->next = (EL_STRUCT *) malloc (sizeof(*pt1));
	    };
         ptr++;
	 };
      };

   free(pt2->next);
   pt2->next = NULL;   /* la liste est construite */

   pt2 = pt1; /* pt2 pointe au debut de la liste */

   xmax = xmin = pt2->x;
   ymax = ymin = pt2->y;
   while (pt2 != NULL) /* boucle de recherche des coordonnees extremes de l'el. str. */
      {
      if (pt2->x > xmax) 
            xmax = pt2->x;
         else if (pt2->x < xmin) 
            xmin = pt2->x;
      if (pt2->y > ymax) 
            ymax = pt2->y;
         else if (pt2->y < ymin) 
	    ymin = pt2->y;
      pt2 = pt2->next;
      };

   pt2 = pt1;

   tx = (xmax + xmin + 1)/2;  /* tx = round((xmax-xmin)/2) */
   ty = (ymax + ymin + 1)/2;  /*             "             */

   while (pt2 != NULL)   /* boucle de translation de l'el. str. pour que son centre */
      {                  /* soit en (0,0)                                           */
      pt2->x -= tx;
      pt2->y -= ty;
      pt2 = pt2->next;
      };

   return(pt1);
   };

/*===================================================================================*/
