/* SCCS @(#)vtransfo.c	1.1  12/2/92 */
/*****************************************************************************/
/* module vtransfo.c							     */
/*									     */
/* Author: Markus Buchi							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
 
#define  MAX_OP  12

#define  X   01
#define  X1  02
#define  X2  04
#define  X3  010
#define  X4  020
#define  X5  040
#define  X6  0100


extern  unsigned short **c_allouer();
extern                 c_desallouer();

static unsigned short  X0_mask[MAX_OP], X1_mask[MAX_OP];


/*****************************************************************/

/* Points extremes du squelette */

long E_tout_ou_rien( nl, nc, image )
int nl, nc;
unsigned short **image;
{
    long n;

    X1_mask[0] = X ;
    X0_mask[0] = X1 | X4 | X5 | X6;

    X1_mask[1] = X ;
    X0_mask[1] = X1 | X2 | X5 | X6;

    X1_mask[2] = X ;
    X0_mask[2] = X6 | X1 | X2 | X3;

    X1_mask[3] = X ;
    X0_mask[3] = X1 | X2 | X3 | X4;

    X1_mask[4] = X ;
    X0_mask[4] = X2 | X3 | X4 | X5;

    X1_mask[5] = X ;
    X0_mask[5] = X3 | X4 | X5 | X6;

    x1_cadre( nl, nc, image );  /* met le cadre a 1 */
 
    n = t_transvois( nl, nc, image, X0_mask, X1_mask, 6 );    
    return(n);

} /* end E_tout_ou_rien */

/***************************************************************/

/* Points isoles */

long I_tout_ou_rien( nl, nc, image )
int nl, nc;
unsigned short **image;
{
    long n;

    X1_mask[0] = X ;
    X0_mask[0] = X1 | X2 | X3 | X4 | X5 | X6;

    x1_cadre( nl, nc, image );  /* met le cadre a 1 */
 
    n = t_transvois( nl, nc, image, X0_mask, X1_mask, 1 );
    return(n);    

} /* end I_tout_ou_rien */

/***************************************************************/

/* Points triples du squelette */

F_tout_ou_rien( nl, nc, image )
int nl, nc;
unsigned short **image;
{  

    X1_mask[0] = X | X1 | X3 | X5 ;
    X0_mask[0] = X2 | X4 | X6 ;

    X1_mask[1] = X | X2 | X4 | X6;
    X0_mask[1] = X1 | X3 | X5 ;

    X1_mask[2] = X | X2 | X3 ;
    X0_mask[2] = 0 ;

    X1_mask[3] = X | X3 | X4 ;
    X0_mask[3] = 0 ;

    X1_mask[4] = X | X4 | X5 ;
    X0_mask[4] = 0 ;

    X1_mask[5] = X | X5 | X6 ;
    X0_mask[5] = 0 ;

    X1_mask[6] = X | X6 | X1 ;
    X0_mask[6] = 0 ;

    X1_mask[7] = X | X1 | X2 ;
    X0_mask[7] = 0 ;

    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    t_transvois( nl, nc, image, X0_mask, X1_mask, 8 );    

} /* end E_tout_ou_rien */

/***************************************************************/

/* Marqueur homotopique */

D_amincir( nl, nc, image, taille )
int nl, nc;
unsigned short **image;
short taille;
{
    X1_mask[0] = X | X1;
    X0_mask[0] = X3 | X4 | X5;

    X1_mask[2] = X | X2;
    X0_mask[2] = X4 | X5 | X6;

    X1_mask[4] = X | X3;
    X0_mask[4] = X5 | X6 | X1;

    X1_mask[1] = X | X4;
    X0_mask[1] = X6 | X1 | X2;

    X1_mask[3] = X | X5;
    X0_mask[3] = X1 | X2 | X3;

    X1_mask[5] = X | X6;
    X0_mask[5] = X2 | X3 | X4;

    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    a_transvois( nl, nc, image, taille, X0_mask, X1_mask, 6 );    

} /* end D_amincir */

/*****************************************************************/

/* squelette homotopique */

L_amincir( nl, nc, image, taille )
int nl, nc;
unsigned short **image;
short taille;
{
    X1_mask[0] = X | X2 | X3 ;
    X0_mask[0] = X5 | X6 ;

    X1_mask[2] = X | X3 | X4;
    X0_mask[2] = X6 | X1 ;

    X1_mask[4] = X | X4 | X5 ;
    X0_mask[4] = X1 | X2 ;

    X1_mask[1] = X | X5 | X6;
    X0_mask[1] = X2 | X3 ;

    X1_mask[3] = X | X6 | X1;
    X0_mask[3] = X3 | X4 ;

    X1_mask[5] = X | X1 | X2;
    X0_mask[5] = X4 | X5 ;

    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    a_transvois( nl, nc, image, taille, X0_mask, X1_mask, 6 );    

} /* end L_amincir */

/********************************************************************/

/* amincissement homotopique  M */

M_amincir( nl, nc, image, taille )
int nl, nc;
unsigned short **image;
short taille;
{
    X0_mask[0] = X1 ;
    X1_mask[0] = X | X3 | X4 | X5 ;

    X0_mask[2] = X2 ;
    X1_mask[2] = X | X4 | X5 | X6;

    X0_mask[4] = X3 ;
    X1_mask[4] = X | X5 | X6 | X1;

    X0_mask[1] = X4 ;
    X1_mask[1] = X | X6 | X1 | X2;

    X0_mask[3] = X5 ;
    X1_mask[3] = X | X1 | X2 | X3;

    X0_mask[5] = X6 ;
    X1_mask[5] = X | X2 | X3 | X4;


    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    a_transvois( nl, nc, image, taille, X0_mask, X1_mask, 6 );    

} /* end M_amincir */

/*****************************************************************/

/* Ebarbulage */

E_amincir( nl, nc, image, taille )
int nl, nc;
unsigned short **image;
short taille;
{
    X1_mask[0] = X ;
    X0_mask[0] = X1 | X4 | X5 | X6;

    X1_mask[2] = X ;
    X0_mask[2] = X1 | X2 | X5 | X6;

    X1_mask[4] = X ;
    X0_mask[4] = X6 | X1 | X2 | X3;

    X1_mask[1] = X ;
    X0_mask[1] = X1 | X2 | X3 | X4;

    X1_mask[3] = X ;
    X0_mask[3] = X2 | X3 | X4 | X5;

    X1_mask[5] = X ;
    X0_mask[5] = X3 | X4 | X5 | X6;

    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    a_transvois( nl, nc, image, taille, X0_mask, X1_mask, 6 );    

} /* end E_amincir */

/*****************************************************************/

/* Contour */

H_amincir( nl, nc, image, taille )
int nl, nc;
unsigned short **image;
short taille;
{
    X1_mask[0] = X | X1 | X2 | X3 | X4 | X5 | X6 ;
    X0_mask[0] = 0 ;

    x1_cadre( nl, nc, image );  /* met le cadre a 1 */
 
    a_transvois( nl, nc, image, taille, X0_mask, X1_mask, 1 );    

} /* end H_amincir */

/*****************************************************************/

/* Erosion lineaire */

R_amincir( nl, nc, image, taille, angle )
int nl, nc;
unsigned short **image;
short taille, angle;
{
    switch ( angle )
       {
	   case 0   : 
                      X1_mask[0] = X ;
                      X0_mask[0] = X1; 
                      break;
           
           case 60  :
                      X1_mask[0] = X ;
                      X0_mask[0] = X2 ;
                      break;

           case 120 :
                      X1_mask[0] = X ;
                      X0_mask[0] = X3;
                      break;

	   case 180 : 
                      X1_mask[0] = X ;
                      X0_mask[0] = X4; 
                      break;
           
           case 240 :
                      X1_mask[0] = X ;
                      X0_mask[0] = X5 ;
                      break;

           case 300 :
                      X1_mask[0] = X ;
                      X0_mask[0] = X6;
                      break;
                      
       }

    x0_cadre( nl, nc, image );  /* met le cadre a 1 */
 
    a_transvois( nl, nc, image, taille, X0_mask, X1_mask, 1 );    

} /* end R_amincir */

/*****************************************************************/

/* enveloppe quasi-convexe */

D_epaissir( nl, nc, image, taille )
int nl, nc;
unsigned short **image;
short taille;
{
    X0_mask[0] = X | X1;
    X1_mask[0] = X3 | X4 | X5;

    X0_mask[2] = X | X2;
    X1_mask[2] = X4 | X5 | X6;

    X0_mask[4] = X | X3;
    X1_mask[4] = X5 | X6 | X1;

    X0_mask[1] = X | X4;
    X1_mask[1] = X6 | X1 | X2;

    X0_mask[3] = X | X5;
    X1_mask[3] = X1 | X2 | X3;

    X0_mask[5] = X | X6;
    X1_mask[5] = X2 | X3 | X4;

    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    e_transvois( nl, nc, image, taille, X0_mask, X1_mask, 6 );    

} /* end D_epaissir */

/*****************************************************************/

/* epaississement homotopique Lc */

L_epaissir( nl, nc, image, taille )
int nl, nc;
unsigned short **image;
short taille;
{
    X0_mask[0] = X | X2 | X3 ;
    X1_mask[0] = X5 | X6 ;

    X0_mask[2] = X | X3 | X4;
    X1_mask[2] = X6 | X1 ;

    X0_mask[4] = X | X4 | X5 ;
    X1_mask[4] = X1 | X2 ;

    X0_mask[1] = X | X5 | X6;
    X1_mask[1] = X2 | X3 ;

    X0_mask[3] = X | X6 | X1;
    X1_mask[3] = X3 | X4 ;

    X0_mask[5] = X | X1 | X2;
    X1_mask[5] = X4 | X5 ;

    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    e_transvois( nl, nc, image, taille, X0_mask, X1_mask, 6 );    

} /* end L_epaissir */

/*****************************************************************/

/* epaississement */

E_epaissir( nl, nc, image, taille )
int nl, nc;
unsigned short **image;
short taille;
{
    X0_mask[0] = X ;
    X1_mask[0] = X1 | X4 | X5 | X6;

    X0_mask[2] = X ;
    X1_mask[2] = X1 | X2 | X5 | X6;

    X0_mask[4] = X ;
    X1_mask[4] = X6 | X1 | X2 | X3;

    X0_mask[1] = X ;
    X1_mask[1] = X1 | X2 | X3 | X4;

    X0_mask[3] = X ;
    X1_mask[3] = X2 | X3 | X4 | X5;

    X0_mask[5] = X ;
    X1_mask[5] = X3 | X4 | X5 | X6;

    x0_cadre( nl, nc, image );  /* met le cadre a 1 */
 
    e_transvois( nl, nc, image, taille, X0_mask, X1_mask, 6 );    

} /* end E_epaissir */

/*****************************************************************/

/* epaississement a partir de points isoles Mc */

M_epaissir( nl, nc, image, taille )
int nl, nc;
unsigned short **image;
short taille;
{
    X1_mask[0] = X1 ;
    X0_mask[0] = X | X3 | X4 | X5 ;

    X1_mask[2] = X2 ;
    X0_mask[2] = X | X4 | X5 | X6;

    X1_mask[4] = X3 ;
    X0_mask[4] = X | X5 | X6 | X1;

    X1_mask[1] = X4 ;
    X0_mask[1] = X | X6 | X1 | X2;

    X1_mask[3] = X5 ;
    X0_mask[3] = X | X1 | X2 | X3;

    X1_mask[5] = X6 ;
    X0_mask[5] = X | X2 | X3 | X4;


    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    e_transvois( nl, nc, image, taille, X0_mask, X1_mask, 6 );    

} /* end M_epaissir */

/*****************************************************************/

/* Dilatation lineaire */

R_epaissir( nl, nc, image, taille, angle )
int nl, nc;
unsigned short **image;
short taille, angle;
{
    switch ( angle )
       {
	   case 0   : 
                      X0_mask[0] = X ;
                      X1_mask[0] = X1; 
                      break;
           
           case 60  :
                      X0_mask[0] = X ;
                      X1_mask[0] = X2 ;
                      break;

           case 120 :
                      X0_mask[0] = X ;
                      X1_mask[0] = X3;
                      break;

	   case 180 : 
                      X0_mask[0] = X ;
                      X1_mask[0] = X4; 
                      break;
           
           case 240 :
                      X0_mask[0] = X ;
                      X1_mask[0] = X5 ;
                      break;

           case 300 :
                      X0_mask[0] = X ;
                      X1_mask[0] = X6;
                      break;
                      
       }

    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    e_transvois( nl, nc, image, taille, X0_mask, X1_mask, 1 );    

} /* end R_epaissir */

/*****************************************************************/

/* epaississement */

C_epaissir( nl, nc, image, taille )
int nl, nc;
unsigned short **image;
short taille;
{
    X1_mask[0] = X1 | X2 | X3 ;
    X0_mask[0] = X ;

    X1_mask[1] = X2 | X3 | X4 ;
    X0_mask[1] = X ;

    X1_mask[2] = X3 | X4 | X5 ;
    X0_mask[2] = X ;

    X1_mask[3] = X4 | X5 | X6 ;
    X0_mask[3] = X ;

    X1_mask[4] = X5 | X6 | X1;
    X0_mask[4] = X ;

    X1_mask[5] = X6 | X1 | X2;
    X0_mask[5] = X ;


    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    e_transvois( nl, nc, image, taille, X0_mask, X1_mask, 6 );    

} /* end C_epaissir */

/*****************************************************************/

/* TRANSFORMATIONS CONDITIONNELLES */

/* amincissement conditionnelle homotopique */

L_camincir( nl, nc, image, ima_condi, taille )
int nl, nc;
unsigned short **image, **ima_condi;
short taille;
{
    X1_mask[0] = X | X2 | X3 ;
    X0_mask[0] = X5 | X6 ;

    X1_mask[2] = X | X3 | X4;
    X0_mask[2] = X6 | X1 ;

    X1_mask[4] = X | X4 | X5 ;
    X0_mask[4] = X1 | X2 ;

    X1_mask[1] = X | X5 | X6;
    X0_mask[1] = X2 | X3 ;

    X1_mask[3] = X | X6 | X1;
    X0_mask[3] = X3 | X4 ;

    X1_mask[5] = X | X1 | X2;
    X0_mask[5] = X4 | X5 ;

    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    a_condvois( nl, nc, image, ima_condi,  taille, X0_mask, X1_mask, 6 );    

} /* end L_camincir */


/********************************************************************/

/* amincissement homotopique condi.  M */

/* Marqueur homotopique */

D_camincir( nl, nc, image, ima_condi, taille )
int nl, nc;
unsigned short **image, **ima_condi;
short taille;
{
    X1_mask[0] = X | X1;
    X0_mask[0] = X3 | X4 | X5;

    X1_mask[2] = X | X2;
    X0_mask[2] = X4 | X5 | X6;

    X1_mask[4] = X | X3;
    X0_mask[4] = X5 | X6 | X1;

    X1_mask[1] = X | X4;
    X0_mask[1] = X6 | X1 | X2;

    X1_mask[3] = X | X5;
    X0_mask[3] = X1 | X2 | X3;

    X1_mask[5] = X | X6;
    X0_mask[5] = X2 | X3 | X4;

    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    a_condvois( nl, nc, image, ima_condi, taille, X0_mask, X1_mask, 6 );    

} /* end D_camincir */

/*****************************************************************/

/* Ebarbulage condi. */

E_camincir( nl, nc, image, ima_condi,  taille )
int nl, nc;
unsigned short **image, **ima_condi;
short taille;
{
    X1_mask[0] = X ;
    X0_mask[0] = X1 | X4 | X5 | X6;

    X1_mask[2] = X ;
    X0_mask[2] = X1 | X2 | X5 | X6;

    X1_mask[4] = X ;
    X0_mask[4] = X6 | X1 | X2 | X3;

    X1_mask[1] = X ;
    X0_mask[1] = X1 | X2 | X3 | X4;

    X1_mask[3] = X ;
    X0_mask[3] = X2 | X3 | X4 | X5;

    X1_mask[5] = X ;
    X0_mask[5] = X3 | X4 | X5 | X6;

    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    a_condvois( nl, nc, image, ima_condi,  taille, X0_mask, X1_mask, 6 );    

} /* end E_camincir */

/*****************************************************************/

/* epaississement conditionnelle homotopique ~L */

L_cepaissir( nl, nc, image, ima_condi, taille )
int nl, nc;
unsigned short **image, **ima_condi;
short taille;
{
    X0_mask[0] = X | X2 | X3 ;
    X1_mask[0] = X5 | X6 ;

    X0_mask[2] = X | X3 | X4;
    X1_mask[2] = X6 | X1 ;

    X0_mask[4] = X | X4 | X5 ;
    X1_mask[4] = X1 | X2 ;

    X0_mask[1] = X | X5 | X6;
    X1_mask[1] = X2 | X3 ;

    X0_mask[3] = X | X6 | X1;
    X1_mask[3] = X3 | X4 ;

    X0_mask[5] = X | X1 | X2;
    X1_mask[5] = X4 | X5 ;

    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    e_condvois( nl, nc, image, ima_condi, taille, X0_mask, X1_mask, 6 );    

} /* end L_cepaissir */

/*****************************************************************/

/* epais. homotopique condi. ~D */

D_cepaissir( nl, nc, image, ima_condi,  taille )
int nl, nc;
unsigned short **image, **ima_condi;
short taille;
{
    X0_mask[0] = X | X1;
    X1_mask[0] = X3 | X4 | X5;

    X0_mask[2] = X | X2;
    X1_mask[2] = X4 | X5 | X6;

    X0_mask[4] = X | X3;
    X1_mask[4] = X5 | X6 | X1;

    X0_mask[1] = X | X4;
    X1_mask[1] = X6 | X1 | X2;

    X0_mask[3] = X | X5;
    X1_mask[3] = X1 | X2 | X3;

    X0_mask[5] = X | X6;
    X1_mask[5] = X2 | X3 | X4;

    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    e_condvois( nl, nc, image, ima_condi,  taille, X0_mask, X1_mask, 6 );    

} /* end D_cepaissir */

/*****************************************************************/

/* epaississement condi. ~E */

E_cepaissir( nl, nc, image, ima_condi,  taille )
int nl, nc;
unsigned short **image, **ima_condi;
short taille;
{
    X0_mask[0] = X ;
    X1_mask[0] = X1 | X4 | X5 | X6;

    X0_mask[2] = X ;
    X1_mask[2] = X1 | X2 | X5 | X6;

    X0_mask[4] = X ;
    X1_mask[4] = X6 | X1 | X2 | X3;

    X0_mask[1] = X ;
    X1_mask[1] = X1 | X2 | X3 | X4;

    X0_mask[3] = X ;
    X1_mask[3] = X2 | X3 | X4 | X5;

    X0_mask[5] = X ;
    X1_mask[5] = X3 | X4 | X5 | X6;

    x0_cadre( nl, nc, image );  /* met le cadre a 1 */
 
    e_condvois( nl, nc, image, ima_condi,  taille, X0_mask, X1_mask, 6 );    

} /* end E_cepaissir */

/*****************************************************************/

/* epaississement conditionnel a partir de points isoles ~M */

M_cepaissir( nl, nc, image, ima_condi,  taille )
int nl, nc;
unsigned short **image, **ima_condi;
short taille;
{
    X1_mask[0] = X1 ;
    X0_mask[0] = X | X3 | X4 | X5 ;

    X1_mask[2] = X2 ;
    X0_mask[2] = X | X4 | X5 | X6;

    X1_mask[4] = X3 ;
    X0_mask[4] = X | X5 | X6 | X1;

    X1_mask[1] = X4 ;
    X0_mask[1] = X | X6 | X1 | X2;

    X1_mask[3] = X5 ;
    X0_mask[3] = X | X1 | X2 | X3;

    X1_mask[5] = X6 ;
    X0_mask[5] = X | X2 | X3 | X4;


    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    e_condvois( nl, nc, image, ima_condi,  taille, X0_mask, X1_mask, 6 );    

} /* end M_cepaissir */

/*****************************************************************/

/* epaississement condi. ~C */

C_cepaissir( nl, nc, image, ima_condi,  taille )
int nl, nc;
unsigned short **image, **ima_condi;
short taille;
{
    X1_mask[0] = X1 | X2 | X3 ;
    X0_mask[0] = X ;

    X1_mask[1] = X2 | X3 | X4 ;
    X0_mask[1] = X ;

    X1_mask[2] = X3 | X4 | X5 ;
    X0_mask[2] = X ;

    X1_mask[3] = X4 | X5 | X6 ;
    X0_mask[3] = X ;

    X1_mask[4] = X5 | X6 | X1;
    X0_mask[4] = X ;

    X1_mask[5] = X6 | X1 | X2;
    X0_mask[5] = X ;


    x0_cadre( nl, nc, image );  /* met le cadre a 0 */
 
    e_condvois( nl, nc, image, ima_condi,  taille, X0_mask, X1_mask, 6 );    

} /* end C_cepaissir */
