/*****************************************************************************/
/* module padding.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <math.h>

#include "define.h"
#include "structure.h"
#include "global.h"
#include "type.h"

static Panel_setting lire_padding();

Frame       frame_padding;
Panel       panel_padding;
Panel_item  padding_ligne, padding_colonne, padding_valeur;


extern void hproc_pad_cte();
extern void hproc_pad_period();
extern void hproc_pad_prolong();

/*****************************************************************************/

int padding_prolong (nodep, noarr, pad)
    int nodep, noarr;
    struct paddi *pad;
{
    int dx, dy;
    register int i, j;


    dx = (pad->colonne - dir_desc[nodep].ncolonne) / 2;
    dy = (pad->ligne - dir_desc[nodep].nligne) / 2;
    switch (dir_desc[nodep].type) {
	case -1:
	case 0 : {
	    unsigned char *imdep, *im, *deb_im, *t, val;
	    imdep = dir_image[nodep].image;	    
	    deb_im = im = (unsigned char *) malloc 
		 (pad->ligne * pad->colonne * element(dir_desc[nodep].type));
	    /* remplissage de la gauche et de la droite */
	    t = im + dy * pad->colonne;
	    for (j=0; j<dir_desc[nodep].nligne; j++){
		val = *imdep;
		for	(i=0; i<dx; i++){
		    *t = val;
		    t++;
		}
		for (i=0; i<dir_desc[nodep].ncolonne; i++) {
		    *t = *imdep;
		    t++;  imdep++;
		}
		val = *(imdep - 1);
		for (i=0;i<(pad->colonne - dir_desc[nodep].ncolonne - dx);i++){
		    *t = val;
		    t++;
		}
	    }
	    /* remplissage du haut et du bas */
	    for (i=0; i<pad->colonne; i++){
		t = im;
		val = *(t + dy * pad->colonne);
		for (j=0; j<dy; j++){
		    *t = val;
		    t += pad->colonne;
		}
		t += (pad->colonne * dir_desc[nodep].nligne);
		val = *(t - pad->colonne);
		for (j=0; j<(pad->ligne - dir_desc[nodep].nligne - dy); j++){
		    *t = val;
		    t += pad->colonne;
		}
		im++;
	    }
	    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
	    dir_image[noarr].image = deb_im;
	    break;
	}    
	case 1 : {
	    short *imdep, *im, *deb_im, *t, val;
	    imdep = (short *)dir_image[nodep].image;	    
	    deb_im = im = (short *) malloc 
		 (pad->ligne * pad->colonne * element(dir_desc[nodep].type));
	    /* remplissage de la gauche et de la droite */
	    t = im + dy * pad->colonne;
	    for (j=0; j<dir_desc[nodep].nligne; j++){
		val = *imdep;
		for	(i=0; i<dx; i++){
		    *t = val;
		    t++;
		}
		for (i=0; i<dir_desc[nodep].ncolonne; i++) {
		    *t = *imdep;
		    t++;  imdep++;
		}
		val = *(imdep - 1);
		for (i=0;i<(pad->colonne - dir_desc[nodep].ncolonne - dx);i++){
		    *t = val;
		    t++;
		}
	    }
	    /* remplissage du haut et du bas */
	    for (i=0; i<pad->colonne; i++){
		t = im;
		val = *(t + dy * pad->colonne);
		for (j=0; j<dy; j++){
		    *t = val;
		    t += pad->colonne;
		}
		t += (pad->colonne * dir_desc[nodep].nligne);
		val = *(t - pad->colonne);
		for (j=0; j<(pad->ligne - dir_desc[nodep].nligne - dy); j++){
		    *t = val;
		    t += pad->colonne;
		}
		im++;
	    }
	    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
	    dir_image[noarr].image = (unsigned char *)deb_im;
	    break;
	}    
	case 2 : {
	    int *imdep, *im, *deb_im, *t, val;
	    imdep = (int *)dir_image[nodep].image;	    
	    deb_im = im = (int *) malloc 
		 (pad->ligne * pad->colonne * element(dir_desc[nodep].type));
	    /* remplissage de la gauche et de la droite */
	    t = im + dy * pad->colonne;
	    for (j=0; j<dir_desc[nodep].nligne; j++){
		val = *imdep;
		for	(i=0; i<dx; i++){
		    *t = val;
		    t++;
		}
		for (i=0; i<dir_desc[nodep].ncolonne; i++) {
		    *t = *imdep;
		    t++;  imdep++;
		}
		val = *(imdep - 1);
		for (i=0;i<(pad->colonne - dir_desc[nodep].ncolonne - dx);i++){
		    *t = val;
		    t++;
		}
	    }
	    /* remplissage du haut et du bas */
	    for (i=0; i<pad->colonne; i++){
		t = im;
		val = *(t + dy * pad->colonne);
		for (j=0; j<dy; j++){
		    *t = val;
		    t += pad->colonne;
		}
		t += (pad->colonne * dir_desc[nodep].nligne);
		val = *(t - pad->colonne);
		for (j=0; j<(pad->ligne - dir_desc[nodep].nligne - dy); j++){
		    *t = val;
		    t += pad->colonne;
		}
		im++;
	    }
	    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
	    dir_image[noarr].image = (unsigned char *)deb_im;
	    break;
	}    
	case 3 : {
	    float *imdep, *im, *deb_im, *t, val;
	    imdep = (float *)dir_image[nodep].image;	    
	    deb_im = im = (float *) malloc 
		 (pad->ligne * pad->colonne * element(dir_desc[nodep].type));
	    /* remplissage de la gauche et de la droite */
	    t = im + dy * pad->colonne;
	    for (j=0; j<dir_desc[nodep].nligne; j++){
		val = *imdep;
		for	(i=0; i<dx; i++){
		    *t = val;
		    t++;
		}
		for (i=0; i<dir_desc[nodep].ncolonne; i++) {
		    *t = *imdep;
		    t++;  imdep++;
		}
		val = *(imdep - 1);
		for (i=0;i<(pad->colonne - dir_desc[nodep].ncolonne - dx);i++){
		    *t = val;
		    t++;
		}
	    }
	    /* remplissage du haut et du bas */
	    for (i=0; i<pad->colonne; i++){
		t = im;
		val = *(t + dy * pad->colonne);
		for (j=0; j<dy; j++){
		    *t = val;
		    t += pad->colonne;
		}
		t += (pad->colonne * dir_desc[nodep].nligne);
		val = *(t - pad->colonne);
		for (j=0; j<(pad->ligne - dir_desc[nodep].nligne - dy); j++){
		    *t = val;
		    t += pad->colonne;
		}
		im++;
	    }
	    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
	    dir_image[noarr].image = (unsigned char *)deb_im;
	    break;
	}
    }
    dir_desc[noarr] = dir_desc[nodep];
    dir_desc[noarr].nligne = pad->ligne;
    dir_desc[noarr].ncolonne = pad->colonne;
    statis (dir_image[noarr].image, dir_desc[noarr].type, 
            dir_desc[noarr].nligne, dir_desc[noarr].ncolonne,
            &(dir_desc[noarr].mmin), &(dir_desc[noarr].mmax), 
            &(dir_desc[noarr].mu), &(dir_desc[noarr].ecart));
}

/*****************************************************************************/

int padding_period (nodep, noarr, pad)
    int nodep, noarr;
    struct paddi *pad;
{
    int dx, dy;
    register int i, j;


    dx = (pad->colonne - dir_desc[nodep].ncolonne) / 2;
    dy = (pad->ligne - dir_desc[nodep].nligne) / 2;
    switch (dir_desc[nodep].type) {
	case -1:
	case 0 : {
	    unsigned char *imdep, *im, *deb_im, *t_dep, *t_arr, *t;
	    imdep = dir_image[nodep].image;
	    deb_im = im = (unsigned char *) malloc
		(pad->ligne * pad->colonne * element(dir_desc[nodep].type));
	    t_arr = im + dy * pad->colonne + dx;
	    for (j=0; j<dir_desc[nodep].nligne; j++){
		t_dep = imdep;
		/* recopie de l'image */
		for (i=0; i<dir_desc[nodep].ncolonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
		/* remplissage de la droite */
		imdep = t_dep;
		t = t_arr;
		t_dep = t_arr - dir_desc[nodep].ncolonne;
		for (i=0;i<(pad->colonne - dir_desc[nodep].ncolonne - dx);i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		/* remplissage de la gauche */
		t_dep = t - (dx % dir_desc[nodep].ncolonne);
		t = t_arr;
		t_arr = t_arr - pad->colonne;
		for (i=0; i<dx; i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		t_arr = t + dx;
	    }
	    /* remplissage du bas */
	    t_dep = im + dy * pad->colonne;
	    t_arr = t_dep + dir_desc[nodep].nligne * pad->colonne;
	    t = t_arr;
	    for (j=0; j < (pad->ligne - dir_desc[nodep].nligne - dy); j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }		
	    /* remplissage du haut */
	    t_dep = t - (dy % dir_desc[nodep].nligne) * pad->colonne;
	    t_arr = im;
	    for (j=0; j < dy; j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }
	    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
	    dir_image[noarr].image = deb_im;
	    break;
        }
	case 1:{
	    short *imdep, *im, *deb_im, *t_dep, *t_arr, *t;
	    imdep = (short *)dir_image[nodep].image;
	    deb_im = im = (short *) malloc
		(pad->ligne * pad->colonne * element(dir_desc[nodep].type));
	    t_arr = im + dy * pad->colonne + dx;
	    for (j=0; j<dir_desc[nodep].nligne; j++){
		t_dep = imdep;
		/* recopie de l'image */
		for (i=0; i<dir_desc[nodep].ncolonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
		/* remplissage de la droite */
		imdep = t_dep;
		t = t_arr;
		t_dep = t_arr - dir_desc[nodep].ncolonne;
		for (i=0;i<(pad->colonne - dir_desc[nodep].ncolonne - dx);i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		/* remplissage de la gauche */
		t_dep = t - (dx % dir_desc[nodep].ncolonne);
		t = t_arr;
		t_arr = t_arr - pad->colonne;
		for (i=0; i<dx; i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		t_arr = t + dx;
	    }
	    /* remplissage du bas */
	    t_dep = im + dy * pad->colonne;
	    t_arr = t_dep + dir_desc[nodep].nligne * pad->colonne;
	    t = t_arr;
	    for (j=0; j < (pad->ligne - dir_desc[nodep].nligne - dy); j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }		
	    /* remplissage du haut */
	    t_dep = t - (dy % dir_desc[nodep].nligne) * pad->colonne;
	    t_arr = im;
	    for (j=0; j < dy; j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }
	    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
	    dir_image[noarr].image = (unsigned char *)deb_im;
	    break;
	}
	case 2:{
	    int *imdep, *im, *deb_im, *t_dep, *t_arr, *t;
	    imdep = (int *)dir_image[nodep].image;
	    deb_im = im = (int *) malloc
		(pad->ligne * pad->colonne * element(dir_desc[nodep].type));
	    t_arr = im + dy * pad->colonne + dx;
	    for (j=0; j<dir_desc[nodep].nligne; j++){
		t_dep = imdep;
		/* recopie de l'image */
		for (i=0; i<dir_desc[nodep].ncolonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
		/* remplissage de la droite */
		imdep = t_dep;
		t = t_arr;
		t_dep = t_arr - dir_desc[nodep].ncolonne;
		for (i=0;i<(pad->colonne - dir_desc[nodep].ncolonne - dx);i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		/* remplissage de la gauche */
		t_dep = t - (dx % dir_desc[nodep].ncolonne);
		t = t_arr;
		t_arr = t_arr - pad->colonne;
		for (i=0; i<dx; i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		t_arr = t + dx;
	    }
	    /* remplissage du bas */
	    t_dep = im + dy * pad->colonne;
	    t_arr = t_dep + dir_desc[nodep].nligne * pad->colonne;
	    t = t_arr;
	    for (j=0; j < (pad->ligne - dir_desc[nodep].nligne - dy); j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }		
	    /* remplissage du haut */
	    t_dep = t - (dy % dir_desc[nodep].nligne) * pad->colonne;
	    t_arr = im;
	    for (j=0; j < dy; j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }
	    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
	    dir_image[noarr].image = (unsigned char *)deb_im;
	    break;
	}
	case 3:{
	    float *imdep, *im, *deb_im, *t_dep, *t_arr, *t;
	    imdep = (float *)dir_image[nodep].image;
	    deb_im = im = (float *) malloc
		(pad->ligne * pad->colonne * element(dir_desc[nodep].type));
	    t_arr = im + dy * pad->colonne + dx;
	    for (j=0; j<dir_desc[nodep].nligne; j++){
		t_dep = imdep;
		/* recopie de l'image */
		for (i=0; i<dir_desc[nodep].ncolonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
		/* remplissage de la droite */
		imdep = t_dep;
		t = t_arr;
		t_dep = t_arr - dir_desc[nodep].ncolonne;
		for (i=0;i<(pad->colonne - dir_desc[nodep].ncolonne - dx);i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		/* remplissage de la gauche */
		t_dep = t - (dx % dir_desc[nodep].ncolonne);
		t = t_arr;
		t_arr = t_arr - pad->colonne;
		for (i=0; i<dx; i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		t_arr = t + dx;
	    }
	    /* remplissage du bas */
	    t_dep = im + dy * pad->colonne;
	    t_arr = t_dep + dir_desc[nodep].nligne * pad->colonne;
	    t = t_arr;
	    for (j=0; j < (pad->ligne - dir_desc[nodep].nligne - dy); j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }		
	    /* remplissage du haut */
	    t_dep = t - (dy % dir_desc[nodep].nligne) * pad->colonne;
	    t_arr = im;
	    for (j=0; j < dy; j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }
	    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
	    dir_image[noarr].image = (unsigned char *)deb_im;
	    break;
	}
    }
    dir_desc[noarr] = dir_desc[nodep];
    dir_desc[noarr].nligne = pad->ligne;
    dir_desc[noarr].ncolonne = pad->colonne;
    statis (dir_image[noarr].image, dir_desc[noarr].type, 
            dir_desc[noarr].nligne, dir_desc[noarr].ncolonne,
            &(dir_desc[noarr].mmin), &(dir_desc[noarr].mmax), 
            &(dir_desc[noarr].mu), &(dir_desc[noarr].ecart));
}	    

/*****************************************************************************/

int padding_const (nodep, noarr, pad)
    int nodep, noarr;
    struct paddi *pad;
{
    int dx, dy;
    register int i, j;



    dx = (pad->colonne - dir_desc[nodep].ncolonne) / 2;
    dy = (pad->ligne - dir_desc[nodep].nligne) / 2;
    switch (dir_desc[nodep].type) {
	case -1:
	case 0 : {
	    unsigned char *imdep, *im, *deb_im, *t, val;
	    imdep = dir_image[nodep].image;	    
	    deb_im = im = (unsigned char *) malloc 
		 (pad->ligne * pad->colonne * element(dir_desc[nodep].type));
	    for (i=0; i < pad->colonne * dy; i++) {
		*im = pad->valeur;
		im++;
	    }
	    for (j=0; j < dir_desc[nodep].nligne; j++){
		for (i=0; i < dx; i++){
		    *im = pad->valeur;
		    im++;
		}
		for (i=0; i < dir_desc[nodep].ncolonne; i++){
		    *im = *imdep;
		    im++;  imdep++;
		}
		for (i=0;i < pad->colonne - dir_desc[nodep].ncolonne - dx;i++){
		    *im = pad->valeur;
		    im++; 
		}
	    }
	    for(i=0;i<pad->colonne*(pad->ligne-dir_desc[nodep].nligne-dy);i++){
		*im = pad->valeur;
		im++;
	    }
	    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
	    dir_image[noarr].image = deb_im;
	    break;
	}    
	case 1 : {
	    short *imdep, *im, *deb_im, *t, val;
	    imdep = (short *)dir_image[nodep].image;	    
	    deb_im = im = (short *) malloc 
		 (pad->ligne * pad->colonne * element(dir_desc[nodep].type));
	    for (i=0; i < pad->colonne * dy; i++) {
		*im = pad->valeur;
		im++;
	    }
	    for (j=0; j < dir_desc[nodep].nligne; j++){
		for (i=0; i < dx; i++){
		    *im = pad->valeur;
		    im++;
		}
		for (i=0; i < dir_desc[nodep].ncolonne; i++){
		    *im = *imdep;
		    im++;  imdep++;
		}
		for (i=0;i < pad->colonne - dir_desc[nodep].ncolonne - dx;i++){
		    *im = pad->valeur;
		    im++; 
		}
	    }
	    for(i=0;i<pad->colonne*(pad->ligne-dir_desc[nodep].nligne-dy);i++){
		*im = pad->valeur;
		im++;
	    }
	    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
	    dir_image[noarr].image = (unsigned char *)deb_im;
	    break;
	}    
	case 2 : {
	    int *imdep, *im, *deb_im, *t, val;
	    imdep = (int *)dir_image[nodep].image;	    
	    deb_im = im = (int *) malloc 
		 (pad->ligne * pad->colonne * element(dir_desc[nodep].type));
	    for (i=0; i < pad->colonne * dy; i++) {
		*im = pad->valeur;
		im++;
	    }
	    for (j=0; j < dir_desc[nodep].nligne; j++){
		for (i=0; i < dx; i++){
		    *im = pad->valeur;
		    im++;
		}
		for (i=0; i < dir_desc[nodep].ncolonne; i++){
		    *im = *imdep;
		    im++;  imdep++;
		}
		for (i=0;i < pad->colonne - dir_desc[nodep].ncolonne - dx;i++){
		    *im = pad->valeur;
		    im++; 
		}
	    }
	    for(i=0;i<pad->colonne*(pad->ligne-dir_desc[nodep].nligne-dy);i++){
		*im = pad->valeur;
		im++;
	    }
	    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
	    dir_image[noarr].image = (unsigned char *)deb_im;
	    break;
	}    
	case 3 : {
	    float *imdep, *im, *deb_im, *t, val;
	    imdep = (float *)dir_image[nodep].image;	    
	    deb_im = im = (float *) malloc 
		 (pad->ligne * pad->colonne * element(dir_desc[nodep].type));
	    for (i=0; i < pad->colonne * dy; i++) {
		*im = pad->valeur;
		im++;
	    }
	    for (j=0; j < dir_desc[nodep].nligne; j++){
		for (i=0; i < dx; i++){
		    *im = pad->valeur;
		    im++;
		}
		for (i=0; i < dir_desc[nodep].ncolonne; i++){
		    *im = *imdep;
		    im++;  imdep++;
		}
		for (i=0;i < pad->colonne - dir_desc[nodep].ncolonne - dx;i++){
		    *im = pad->valeur;
		    im++; 
		}
	    }
	    for(i=0;i<pad->colonne*(pad->ligne-dir_desc[nodep].nligne-dy);i++){
		*im = pad->valeur;
		im++;
	    }
	    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
	    dir_image[noarr].image = (unsigned char *)deb_im;
	    break;
	}
    }
    dir_desc[noarr] = dir_desc[nodep];
    dir_desc[noarr].nligne = pad->ligne;
    dir_desc[noarr].ncolonne = pad->colonne;
    statis (dir_image[noarr].image, dir_desc[noarr].type, 
            dir_desc[noarr].nligne, dir_desc[noarr].ncolonne,
            &(dir_desc[noarr].mmin), &(dir_desc[noarr].mmax), 
            &(dir_desc[noarr].mu), &(dir_desc[noarr].ecart));
}

/*****************************************************************************/

static Panel_setting lire_padding (item, event)
    Panel_item item;
    Event *event;

{
    static struct paddi pad;

    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_padding);
        return;
    }
    else { 
        if (event_id(event) == '\t')
	    return (PANEL_NEXT);
        else {
	    pad.ligne = atoi ((char *)panel_get (padding_ligne, PANEL_VALUE));
	    pad.colonne = atoi((char *)panel_get(padding_colonne,PANEL_VALUE));
	    if ((int)panel_get(panel_padding, PANEL_CLIENT_DATA) == TRUE){
		if (flag_creer && strcmp (
		(char *)panel_get(padding_valeur,PANEL_VALUE),"MOY") == 0){
		    pad.valeur = 0;
		    pad.flag_moy = TRUE;	
		}
		else {
		    pad.valeur = atof((char *)panel_get
				(padding_valeur, PANEL_VALUE));
		    pad.flag_moy = FALSE;	
		}
	    }
	    window_return(&pad);
	    window_destroy (frame_padding);
	    return;
	}
    }
}

/*****************************************************************************/

struct paddi *padding_panel(nodep, methode)
int nodep, methode;

{
    Panel_item nbr_ligne, nbr_colonne, titre;
    char stitre[30], rep[20];
    struct paddi *pad;
    int pos;
    
    frame_padding = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
                         FRAME_NO_CONFIRM, TRUE, 0);
    panel_padding = window_create (frame_padding, PANEL, PANEL_LABEL_BOLD,
			 TRUE, 0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	pad = (struct paddi *)(macro_cour->param);
    else pad = NULL;

    if (methode == 1)
	strcpy (stitre, paneltabs[371]);
    else 
	strcpy (stitre, paneltabs[372]);
    titre = panel_create_item (panel_padding, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(0),
                       PANEL_LABEL_STRING, stitre,
                       0);
    if (!flag_creer){
	sprintf(stitre, paneltabs[373],
		    dir_desc[nodep].nligne);
	nbr_ligne = panel_create_item (panel_padding, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(2),
                       PANEL_LABEL_STRING, stitre,
                       0);
	sprintf(stitre, paneltabs[374], 
		    dir_desc[nodep].ncolonne);
	nbr_colonne = panel_create_item (panel_padding, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(3),
                       PANEL_LABEL_STRING, stitre,
                       0);
	pos = 3;
    }
    else pos = 0;
    padding_ligne = panel_create_item (panel_padding, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(pos+2),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[375],
                       PANEL_VALUE, (pad != NULL ? 
		       (char *)sprintf(rep,"%d",pad->ligne) : ""),
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_padding,
                       0);
    padding_colonne = panel_create_item (panel_padding, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(pos+3),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[376],
                       PANEL_VALUE, (pad != NULL ? 
		       (char *)sprintf(rep,"%d",pad->colonne) : ""),
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_padding,
                       0);
    if (methode == 1) {
	if (flag_creer)
	    sprintf (rep, "MOY");
	else if (flag_exec == OFF || (pad != NULL && pad->flag_moy))
	    sprintf (rep, "%f", dir_desc[nodep].mu);
	else sprintf (rep, "%f", pad->valeur);
        padding_valeur = panel_create_item (panel_padding, PANEL_TEXT,
			PANEL_SHOW_ITEM, TRUE,
			PANEL_LABEL_X, ATTR_COL(1),
			PANEL_LABEL_Y, ATTR_ROW(pos+4),
                        PANEL_VALUE_DISPLAY_LENGTH, 20,
                        PANEL_VALUE_STORED_LENGTH, 20,
                        PANEL_LABEL_STRING, paneltabs[377],
			PANEL_VALUE, rep,
                        PANEL_NOTIFY_STRING, "\r\n\t\03",
                        PANEL_NOTIFY_PROC, lire_padding,
                        0);
	panel_set (panel_padding, PANEL_CLIENT_DATA, TRUE, 0);
    }
    else panel_set (panel_padding, PANEL_CLIENT_DATA, FALSE, 0);
    window_fit (panel_padding);
    window_fit (frame_padding);
    window_set (panel_padding, PANEL_CARET_ITEM, padding_ligne, 0);
    pad = (struct paddi *)window_loop(frame_padding);
    return (pad);
}

/*****************************************************************************/

caddr_t	proc_padding (m, mi)
    Menu m;
    Menu_item mi;

{
    struct commande *com;
    struct paddi *pad, *copypad;
    int nodep, noarr, methode = (int)menu_get (mi, MENU_VALUE);
    switch (methode){
	case 2: if ((flag_bother) || (flag_help)){
		    hproc_pad_prolong();
		}
		break;
	case 1: if ((flag_bother) || (flag_help)){
		    hproc_pad_cte();
		}
		if (flag_help) hproc_pad_cte();
		break;
	case 3: if ((flag_bother) || (flag_help)){
		    hproc_pad_period();
		}
		break;
    }
    if (flag_bother) return;

    if (!flag_creer){
	switch (methode){
	    case 1: sprintf (buf, mastertabs[210]);
		    break;
	    case 2: sprintf (buf, mastertabs[211]); 
		    break;
	    case 3: sprintf (buf, mastertabs[212]);
		    break;
	}
	write_master(buf);
    }
    if (flag_exec == FROMTO_AUTO || flag_exec == AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (!flag_creer){
	sprintf (buf, mastertabs[213], index_image[0], index_image[1]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	pad = (struct paddi *)malloc(sizeof(*pad));
	*pad = *((struct paddi *)macro_cour->param);
	if (pad->flag_moy) pad->valeur = dir_desc[index_image[0]].mu;
    }
    else
	pad = padding_panel(index_image[0], methode);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_creer){
	com = (struct commande *) new_commande (&macro_cour);
	switch (methode){
	    case 1: strcpy (com->nom, "AUXMODPADCON");
		    com->code = 1240;
		    break;
	    case 2: strcpy (com->nom, "AUXMODPADPRO");
		    com->code = 1241;
		    break;
	    case 3: strcpy (com->nom, "AUXMODPADPER");
		    com->code = 1242;
		    break;
	}
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	if (methode == 1) 
	    if (pad->flag_moy)
		sprintf (buf, "%s FROM %d TO %d WITH %d %d MOY\n",
		    com->nom, index_image[0], index_image[1], 
		    pad->ligne, pad->colonne);
	    else
		sprintf (buf, "%s FROM %d TO %d WITH %d %d %f\n",
		    com->nom, index_image[0], index_image[1], 
		    pad->ligne, pad->colonne, pad->valeur);
	else sprintf (buf, "%s FROM %d TO %d WITH %d %d\n",
	    com->nom, index_image[0],index_image[1], pad->ligne, pad->colonne);
	write_macro(buf);
	copypad = (struct paddi *)malloc(sizeof(*pad));
	*copypad = *pad;
	com->param = (char *)copypad;
    }
    else{
	if (methode == 1)
	    sprintf(buf," (%d %d %f)\n",pad->ligne,pad->colonne,pad->valeur);
	else
	    sprintf (buf," %d %d\n", pad->ligne, pad->colonne);
	write_master (buf);
	if (flag_break){
	    interruption();
	    return;
	}
	else if ((pad->ligne == 0 ) ||  (pad->colonne == 0)){
	    write_erreur(99);
	    return;
	}
	else {
	    pad->methode = methode;
	    switch (methode){
	    case 1: 
		padding_const (index_image[0], index_image[1], pad);  break;
	    case 2: 
		padding_prolong (index_image[0], index_image[1], pad);  break;
	    case 3: 
		padding_period (index_image[0], index_image[1], pad);  break;
	    }
	}
    }
}
