/*  GLOBAL VARIABLES DECLARATION   */
 
#include <stdio.h>
#include <math.h>

#define nb_resx     2000        /* X-resolution (pixels) */ 
#define nb_resy     2000        /* Y-resolution (pixels) */ 
#define max_row      500	/* Graphic's coordinates */
#define max_col      500
#define max_line    (2 * max_row + 1)
#define MAL            0

#define min(A,B)    ((A) < (B) ? (A) : (B))

static float **F,   /* X and Y projection on the function stored in od */
             **G;
static int  xline[max_line],  /* used with polyline */
            yline[max_line];
static int ymin[nb_resx+1],   /* upper and lower limits */
           ymax[nb_resx+1],
           ymin_new[nb_resx+1],
           ymax_new[nb_resx+1];
static int  i1,
            jj1,
            i2,
            j2,
            iline;

char    position;

float   u1,
        u2,
        u3,
        v1,
        v2,
        v3;



/***********  polyline procedure  ***********/


polyline (n)       /* drawing the gel */
int     n;
{
    int     i;


    for (i = 1; i <= n; i++){
/*        printf(" the i: %d  xline: %d %d    yline: %d %d\n",i,xline[i], xline[i-1], yline[i], yline[i-1] );
*/
	line (xline[i-1] ,yline[i-1], xline[i], yline[i]);
    }
}


/***********  drawzigzag procedure  ***********/


drawzigzag ()    
{
    int     i,
            ix1,
            ix2,
            ydep,
            ydes;
    float   deltay;

    ix1 = F[i1][jj1];
    ix2 = F[i2][j2];
    ydep = G[i1][jj1];
    if (ix1 == ix2)
	ix1--;
    i = ix1;
    deltay = (G[i2][j2] - ydep)/(ix2-ix1); /* slope of the straight */
    do {
	ydes = ydep + deltay * (++i - ix1);
	switch (position) {
	    case 'i': 
		if (ydes > ymin[i]) {
		    if (ydes < ymax[i]) {
			xline[++iline] = i;/* we enter the hidden part */
			yline[iline] = ymin[i];
			position = 'h';
			polyline (iline);
		    }
		    else	/* we pass from the inferior to the
				   superior part */
			position = 's';
		}
	    /* else we stay in the inferior part */
		break;
	    case 'h': 
		if (ydes <= ymin[i]) {
		    iline = 0;	/* we enter the inferior part */
		    xline[iline] = i;
		    yline[iline] = ymin[i];
		    position = 'i';
		}
		else
		if (ydes >= ymax[i]) {
		    iline = 0;	/* we enter the superior part */
		    xline[iline] = i;
		    yline[iline] = ymax[i];
		    position = 's';
		}
		break;
	    case 's': 
		if (ydes < ymax[i]) {
		    if (ydes > ymin[i]) {
			xline[++iline] = i;/* we enter the hidden part */
			yline[iline] = ymax[i];
			position = 'h';
			polyline (iline);
		    }
		    else	/* we pass from the superior to the
				   inferior part */
			position = 'i';
		}
	    /* else we stay over the surface */
		break;
	};			/* switch */
	if (ymin_new[i] > ydes)
	    ymin_new[i] = ydes;
	if (ymax_new[i] < ydes)
	    ymax_new[i] = ydes;
    } while (i != ix2);		/*  end of do */
    if (position != 'h') {
	xline[++iline] = ix2;
	yline[iline] = ydes;
    }
}				/* drawzigzag */


/***********  project procedure  ************/


project (x, y, z,u,v) /* project the 3D-coordinates on the paper-plane */
float   x,
        y,
        z,
       *u,
       *v;
{
    *u = x * u1 + y * u2;	/* +z*u3 but u3=0 */
    *v = x * v1 + y * v2 + z * v3;
}


/*********** respla procedure (2 dimensions) ***********/


char  **respla (mr, mc, sizem)  /* allocate memory-place according to fnx and fny */
int     mr,
        mc,
        sizem;
{
    int     nbytes,
            i;
    char  **A;

    nbytes = mr * sizeof *A;
    A = (char **) malloc (nbytes);
/*    if (A == MAL)
	for (;;)
	    wildrexit ("mallocres2"); */
    nbytes = mr * mc * sizem;
    A[0] = (char *) malloc (nbytes);
/*    if (A[0] == MAL)
	for (;;)
	    wildrexit ("mallocres2"); */
    for (i = 1; i < mr; ++i)
	A[i] = A[i - 1] + mc * sizem;
    return (A);
}


/*********** network procedure  ************/


network (p1, p2, p3, zmin, zmax, xbeg, xend, ybeg, yend,fnx,fny, info,FCT)
float   p1,       /* projection point :(p1,p2,p3) */
        p2,
        p3,
        zmin,     /* limit values in third dimension */
        zmax,
        xbeg,     /* limits of the window to be drawn */
        xend,
        ybeg,
        yend,
        info[];   /* info[0]=umin, info[1]=umax, info[2]=vmin, info[3]=vmax. If info[5]=1 then umin,...,vmax are fixed by info[1..4]. If info[6]=1 then do not draw the ground frame. */
int     fnx,      /* numbers of strokes */
        fny;
short  (* FCT)(); /* gel's function */ 

{
    float    xdelta,
             ydelta,
             temp,             
             x,
             y,
             z,
             delx,
             dely,
             sizex,
             sizey,
             size,
             w1,
             w2,
             w3,
             ww1,
             ww2,
             p12norme,
             pnorme,
             u,
             v,
             umin,
             umax,
             vmin,
             vmax,
             umed,
             vmed;
    int      icas,
             ixtemp,
             iytemp,
             a,
             b,
             nxdep,
             nydep,
             ix,
             iy,
             i;

/*------- Dimensions must not be to high -------*/

    space(0,0,nb_resx, nb_resy); /* hardware window */
    if (fnx > max_row)
	xend = xbeg + max_row;
    if (fny > max_col)
	yend = ybeg + max_col;
    xdelta = xend - xbeg;
    ydelta = yend - ybeg;

/* ------- distance between to nodes: delx and dely -------*/

    delx = xdelta / (fnx-1);
    dely = ydelta / (fny-1);

/*-------if p1=p2=p3=0 then the standard value p=(-3,-2,2) is chosen -------*/

    if ((p1 == 0.0) && (p2 == 0.0) && (p3 == 0.0)) {
	p1 = -3.0;
	p2 = -2.0;
	p3 = 2.0;
    }

/* determination of the orthogonal projection on the plane p1*x+p2*y+p3*z=0 */

    p12norme = p1 * p1 + p2 * p2;

    pnorme = sqrt (p12norme + p3 * p3);
    p12norme = sqrt (p12norme);

/*------- unitary vector colinear with p -------*/

    w1 = p1 / pnorme;
    w2 = p2 / pnorme;
    w3 = p3 / pnorme;

/*------- projection of p on the ground and normalisation -------*/

    if (p12norme == 0) {
	ww1 = 1.0;
	ww2 = 0.0;
    }
    else {
	ww1 = p1 / p12norme;
	ww2 = p2 / p12norme;
    }

/*------- intersection of the plane with the ground -------*/

    u1 = -ww2;
    u2 = ww1;
    u3 = 0.0;

/*------- v = w cross u -------*/

    v1 = w2 * u3 - w3 * u2;
    v2 = w3 * u1 - w1 * u3;
    v3 = w1 * u2 - w2 * u1;

/* ------- (Ui,Vi,Wi) is an orthonormal system, the projection will be :
           u=x*u1+y*u2+z*u3
           v=x*v1+y*v2+z*v3.

 PROJECTION OF THE SURFACE ON THE PLANE AND COMPUTATION OF THE LIMITS
 ====================================================================

 Determination how the data should be stored in order to draw the nearest
 part of the surface first. It corresponds to a rotation of the suface.   

	     according to the icas-value we do a rotation, 
	     because we ever want to see the figure from   
	     (p1,p2,p3) where p1 and p2 are negative.      */

    icas = (p1<0) << 1 | (p2<0);      

    if(icas == 3 || icas == 0){
        F = (float **) respla (fnx, fny, sizeof **F);
        G = (float **) respla (fnx, fny, sizeof **G);
    } else {
        F = (float **) respla (fny, fnx, sizeof **F);
        G = (float **) respla (fny, fnx, sizeof **G);
    }
/*------- projection -------*/

    umin = 1.0E30;
    umax = -umin;
    vmin = umin;
    vmax = -vmin;
    for (x =  xbeg; x < xend+delx/2.0; x += delx)
	for (y = ybeg; y < yend+dely/2.0; y += dely) {
	    z = (* FCT)(x,y);
	    if (z < zmin)
		z = zmin;
	    else
	    if (z > zmax)
		z = zmax;
	    project (x, y, z,&u,&v);
	    if (u < umin)
		umin = u;
	    if (u > umax)
		umax = u;
	    if (v < vmin)
		vmin = v;
	    if (v > vmax)
		vmax = v;

/*------- memorise U and V -------*/

	    switch (icas) {
		case 3:                            /* p1<0 and p2<0 */ 
		    ixtemp = (x - xbeg)/delx+0.1;
		    iytemp = (y - ybeg)/dely+0.1;
		    break;
		case 1:                            /* p1>0 and p<0 */
		    ixtemp = (y - ybeg)/dely+0.1;
		    iytemp = (xend - x)/delx+0.1;
		    break;
		case 2:                            /* p1<0 and p2>0 */
		    ixtemp = (yend - y)/dely+0.1;
		    iytemp = (x - xbeg)/delx+0.1;
		    break;
		case 0:                            /* p1>0 and p2>0 */ 
		    ixtemp = (xend - x)/delx+0.1;
		    iytemp = (yend - y)/dely+0.1;
		    break;
	    }
	    F[ixtemp][iytemp] = u;  /* now we have in F and G the projected coordinates in the plane */
	    G[ixtemp][iytemp] = v;
	}			/* for */

/*------- if the system has been rotated -------*/

    if ((icas == 1) || (icas == 2)) {
	temp = xdelta;
	xdelta = ydelta;
	ydelta = temp;
        temp = fnx;
        fnx = fny;
        fny = temp;
    }

/*------- transformation of the coordinates such that the proportions are respected -------*/

    if (info[5] == 1.0) {
	umin = info[0];
	umax = info[1];
	vmin = info[2];
	vmax = info[3];
    }
    else {
	info[0] = umin;
	info[1] = umax;
	info[2] = vmin;
	info[3] = vmax;
    }
    /*------- drawing of the ground frame if info[6] != 1 -------*/

    if (info[6] != 1.0) {
	iline = 0;
	for (ix = 0; ix < 2; ix++)
	    for (iy = 0; iy < 2; iy++) {
                x = xbeg + ix * (xend-xbeg);
                y = ybeg + iy * (yend-ybeg);
		project (x, y, 0.0,&u,&v);
                xline[iline] = u;
                yline[iline] = v;
                if (u < umin)
                    umin = u;
                if (u > umax)
                    umax = u;
                if (v < vmin)
                    vmin = v;
                if (v > vmax)
                    vmax = v;
		iline = 2 * (iline + 1) % 5 - 1;
            }
	xline[4] = xline[0];
	yline[4] = yline[0];
        umed = (umin + umax) / 2;
        vmed = (vmin + vmax) / 2;
        if (umax == umin)
            umin -= 1.0E-10;
        if (vmax == vmin)
            vmin -= 1.0E-10;
        sizex = 1 / (umax - umin);
        sizey = 1 / (vmax - vmin);
        size = min(sizex,sizey);
        for (iline = 0; iline < 5; iline++){
	   xline[iline] = ((xline[iline] - umed) * size + 0.5) * nb_resx;
	   yline[iline] = ((yline[iline] - vmed) * size + 0.5) * nb_resy;
	}
	polyline (4);
    } else {
        umed = (umin + umax) / 2;
        vmed = (vmin + vmax) / 2;
        if (umax == umin)
            umin -= 1.0E-10;
        if (vmax == vmin)
            vmin -= 1.0E-10;
        sizex = 1 / (umax - umin);
        sizey = 1 / (vmax - vmin);
        size = min(sizex,sizey);
    }                                    /* end if */
    for (ix = 0; ix < fnx; ix++)
	for (iy = 0; iy < fny; iy++) {
	    F[ix][iy] = ((F[ix][iy] - umed) * size + 0.5) * nb_resx;
	    G[ix][iy] = ((G[ix][iy] - vmed) * size + 0.5) * nb_resy;
    }



/*------- limits initialisation ------- */

        for (i = 0; i <= nb_resx; i++) {
	     ymin[i] = 4001;
	     ymin_new[i] = 4001;
	     ymax[i] = -4001;
	     ymax_new[i] = -4001;
         } 

/*------- Drawing the curves -------
          ==================

  -------- first half --------      */
    for (nydep = 1; nydep < fny; nydep++) {
	i1 = 0;
	i2 = 0;
	jj1 = nydep;
	j2 = nydep - 1;
	position = 's';
	iline = 0;
	xline[iline] = F[i1][jj1];
	yline[iline] = G[i1][jj1];

/*------- do one zig-zag line -------*/

	do {
	    drawzigzag();
	    jj1 = j2;
	    i2 = i1 + 1;
	    drawzigzag();
	    i1 = i2;
	    j2 = jj1 - 1;
	} while ((j2 >= 0) && (i2 < fnx - 1));
	if (j2 >= 0)
	    drawzigzag();
	if (position != 'h')
	    polyline (iline);

/*------- update ymin and ymax -------*/
/*------- vector equality -------*/

	for(i = 0; i < nb_resx + 1; ymin[i] = ymin_new[i],i++);
	for(i = 0; i < nb_resx + 1; ymax[i] = ymax_new[i],i++);
    }				/* for */

/*------- second half -------*/

    for (nxdep = 0; nxdep < fnx - 1; nxdep++) {
	i1 = nxdep;
	i2 = nxdep + 1;
	jj1 = fny - 1;
	j2 = fny - 1;
	a = F[i1][jj1];
        b = G[i1][jj1];
	if (b >= ymax[a]) {
	    position = 's';
	    iline = 0;
	    xline[iline] = a;
	    yline[iline] = b;
	}
	else
           if (b <= ymin[a]) {
              position = 'i';
              iline = 0;
              xline[iline] = a;
              yline[iline] = b;
           }
           else
              position = 'h';        

/*------- do one zig-zag line -------*/

	do {
	    drawzigzag();
	    i1 = i2;
	    j2 = jj1 - 1;
	    drawzigzag();
	    jj1 = j2;
	    i2 = i1 + 1;
	} while ((i2 < fnx) && (j2 > 0));
	if (i2 < fnx)
	    drawzigzag();
	if (position != 'h')
	    polyline (iline);

/*------- update ymin and ymax -------*/
/*-------vector equality --------*/

	for(i = 0; i < nb_resx + 1; ymin[i] = ymin_new[i],i++);
	for(i = 0; i < nb_resx + 1; ymax[i] = ymax_new[i],i++);
    }				/* for */
    polyline (iline);
}				/* network */




