/*
** sun.c
**	 	The plot routine for hp plotter
** AUTHOR	Matthieu Funk December 1985
*/


#include 	<usercore.h>
#include        <sgtty.h>
#include        <stdio.h>


#define Bool unsigned
#define  VERTRESP 100.
#define  HORZRESP 100.0
#define  VERTRES  10.0
#define  HORZRES  10.0
#define  MAXVECT  512
/*
FILE *fp, *fopen();
*/
static float   HEIGHT = 10., WIDTH = 10.0;
static int xscale, yscale;
static float botx = 0., boty = 0., obotx = 0., oboty = 0.;
static float scalex = 1., scaley = 1.;



static int       xnow = 0;	    /* Beam position */
static int       ynow = 0;
static int       bx = -1;	    /* Beam position */
static int       by = -1;
static int 	 segment = 1;

static float deltx = 1000.0;
static float delty = 1000.0;

static int del = 20;

static float	vectx[MAXVECT];
static float	vecty[MAXVECT];
static int     nvect = 0;

struct vwsurf *get_view_surface();
static struct vwsurf Core_vwsurf;
struct vwsurf *our_surface = & Core_vwsurf;

static float red[9]={0.00,0.40,0.95,0.95,0.95,0.00,0.20,0.95,0.95};
static float grn[9]={0.00,0.25,0.15,0.75,0.95,0.95,0.20,0.30,0.95};
static float blu[9]={0.00,0.15,0.15,0.00,0.20,0.00,0.95,0.95,0.95};


preclosepl(){
    if (nvect > 0) envoivect();
    close_retained_segment();

}


closepl(){
	shut_down_core();
}

line(xx1,yy1,xx2,yy2){
	int x1,y1,x2,y2;
	x1 = xconv(xsc(xx1)); y1 = yconv(ysc(yy1));
	x2 = xconv(xsc(xx2)); y2 = yconv(ysc(yy2));
	if((x1 != bx) || (y1 != by)){
		if(nvect > 0) envoivect();
		ajouvect(x1,y1);
	}
	ajouvect(x2,y2);
	bx = x2; by = y2;
	xnow = x2; ynow = y2;
	return;
}

ajouvect(x,y)

{
   vectx[nvect] = x;
   vecty[nvect] = y;
   nvect++;
   if (nvect >= MAXVECT) envoivect();
}

envoivect()

{
    int	i;

    move_abs_2( vectx[0], vecty[0] );
    polyline_abs_2(vectx, vecty, nvect);
    bx = 2000;
    nvect = 0;
}


set_color(index)
int index;
{
/*	fprintf(fp,"set_color %d\n",index);*/
	set_line_index(index);
	set_text_index(index);
}


openpl(){
	float r[16],g[16],b[16];
	int i;
/*	fp = fopen("debug","w");	*/
	get_view_surface(our_surface, 0);
	start_up_core();
	set_window(0., 1000., 0., 1000.);
	set_window_clipping(TRUE);
	set_viewport_2(0.125, 0.875, 0.0, 0.75);
	inquire_color_indices(our_surface,0,15,r,g,b);
	for(i = 0; i < 9; i++){
		r[i] = red[i];
		g[i] = grn[i];
		b[i] = blu[i];
	}
	define_color_indices(our_surface,0,15, r, g ,b );
	create_retained_segment(segment);
	set_charprecision(CHARACTER);
	set_color(8);
	xscale = 1000./(HORZRESP * WIDTH);
	yscale = 1000./(VERTRESP * HEIGHT);
	return;
}

start_up_core(){

	initialize_core(BASIC, NOINPUT, TWOD);
	our_surface->cmapsize = 16;
	our_surface->cmapname[0] = '\0';
	our_surface->flags = VWSURF_NEWFLG;
	if(initialize_view_surface( our_surface, FALSE)) exit( 1);
	select_view_surface( our_surface );
}

shut_down_core(){

	deselect_view_surface( our_surface );
	terminate_core();
}


space(x0,y0,x1,y1){

	botx = 0;
	boty = 0;
	obotx = x0;
	oboty = y0;
	scalex = deltx/(x1-x0);
	scaley = delty/(y1-y0);

}

xsc(xi){
	int xa;
	xa = (xi - obotx) * scalex + botx;
	return(xa);
}

ysc(yi){
	int ya;
	ya = (yi - oboty) * scaley + boty;
	return(ya);
}

xconv(xp){
	return(xp / xscale);
}

yconv(yp){
	return(yp / yscale);
}
