/*****************************************************************************/
/* module convol.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <math.h>

#include "type.h"
#include "define.h"
#include "structure.h"
#include "global.h"

static      Panel_setting   lire_conv();
static	    int		    oldligne, oldcolonne;
Frame       frame_convol;
Panel       panel_convol;
Panel_item  conv_ligne, conv_colonne, conv_fact, conv_masque;

int	    flag_conv, flag_conv2;


extern void hproc_convol_masq();
extern void hproc_convol_image();
extern void hproc_correl_masq();
extern void hproc_correl_image();
extern void hproc_creer_masq();

extern char *mastertabs[];
extern char *paneltabs[];

/*****************************************************************************/

int convolue (debut, nodep, noarr, conv, select)
    float *debut;
    int nodep, noarr, select;
    struct convol *conv;
{
    float *deb, *arr, *im, *m, res, *masque;
    int dx, dy, ligne, colonne;
    register int l, c, i, j;

    if (select == 1 || select == 2) {  /* convolution -> retourner masque */
	masque=(float *)malloc(conv->colonne * conv->ligne * sizeof(*masque));
	deb = conv->masque + (conv->ligne * conv->colonne) - 1;
	conv->masque = masque;
	for (i=0; i<conv->ligne*conv->colonne; i++){
	    *masque = *deb;
	    masque++; deb--;
	}
    }
    dir_desc[noarr] = dir_desc[nodep];
    ligne = dir_desc[noarr].nligne;
    colonne = dir_desc[noarr].ncolonne;
    dir_desc[noarr].type = 3;
    arr = (float *)malloc(colonne*ligne*sizeof(*arr));
    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
    dir_image[noarr].image = (unsigned char *)arr;
    for (j = 0; j < ligne*colonne; j++){
        *arr = 0.0;
        arr++;	
    }
    dx = (conv->colonne+1)/2;
    dy = (conv->ligne+1)/2;
    arr = (float *)dir_image[noarr].image;
    arr = arr + (dy - 1) * colonne + dx - 1;

    for (l=0; l <= ligne - conv->ligne; l++){
	for (c=0; c <= colonne - conv->colonne; c++){
	    im = debut;
	    m = conv->masque;
	    res = 0;
	    for (j=0; j < conv->ligne; j++){
		for (i=0; i < conv->colonne; i++){
		    res += (*im) * (*m);
		    im++;  m++;
		}
		im += (colonne - conv->colonne);
	    }
	    *arr = res * conv->factmult;
	    arr++;  debut++;
	}
	arr += (conv->colonne - 1);
	debut += (conv->colonne - 1);
    }

    statis (dir_image[noarr].image, dir_desc[noarr].type, 
	    dir_desc[noarr].nligne, dir_desc[noarr].ncolonne,
	    &(dir_desc[noarr].mmin),&(dir_desc[noarr].mmax), 
	    &(dir_desc[noarr].mu),  &(dir_desc[noarr].ecart));
}

/*****************************************************************************/

static Panel_setting lire_conv (item, event)
    Panel_item item;
    Event *event;

{
    static int mx = -1, my = -1, unchanged;
    float f = -1, *m_init, *debut;
    int	i;
    static struct convol conv;
    static float *m;
    char label[35], rep[20];

    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_convol);
        return;
    }
    else { 
        f = (float)atof ((char *) panel_get (item, PANEL_VALUE));
        if (item==conv_ligne) conv.ligne = (int) f;
	else if (item==conv_colonne) conv.colonne = (int) f;
        else if (item==conv_fact) conv.factmult = f;
        else if (item==conv_masque) {
	    if (mx == -1) {
		if (conv.ligne + conv.colonne < 2) return (PANEL_NEXT);
		conv.masque = (float *)malloc(conv.ligne*conv.colonne*4);
		m = conv.masque;
		if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO){
		    if (oldligne != conv.ligne || oldcolonne != conv.colonne)
			unchanged = FALSE;
		    else {
			m_init = ((struct convol *)macro_cour->param)->masque;
			debut = m;
			unchanged = TRUE;
			for (i=0; i<conv.ligne*conv.colonne; i++){
			    *debut = *m_init;
			    debut++;
			    m_init++;
			}
		    }
		}
		mx = 1;
		my = 1;
	    }
	    *m = f; m++;
	    mx++;
	    if (mx > conv.colonne) {
	        mx = 1;
	        my++;
		if (my > conv.ligne) {
		    mx = -1;  my = -1;
	            window_return(&conv);
		    window_destroy (frame_convol);
		    return;
		}
	    }
	    sprintf (label, paneltabs[28], my, mx);
	    panel_set (item, PANEL_LABEL_STRING, label, 0);
	    if ((flag_exec == MANUEL || flag_exec == FROMTO_AUTO) && unchanged)
		panel_set_value (item, sprintf(rep, "%f", *m)); 
	    else panel_set_value (item, "");
	    return;
        }
        if (event_id(event) == '\t') 
	    return(PANEL_NEXT);
	/* pas de possibilite de retourner avec return avant fin du masque... 
	else {
            window_return(&conv);
	    window_destroy (frame_convol);
	    return;
	}
	*/
    }
}

/*****************************************************************************/

struct convol *convol_panel()

{
    Panel_item titre;
    char *repfloat;
    char stitre[30];
    struct convol *conv;

    repfloat = (char *)malloc(20);
    frame_convol = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
                         FRAME_NO_CONFIRM, TRUE, 0);
    panel_convol = window_create (frame_convol, PANEL, PANEL_LABEL_BOLD,
			 TRUE, 0);

    strcpy (stitre, paneltabs[29]);
    strcpy (repfloat,"");
    titre = panel_create_item (panel_convol, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(0),
                       PANEL_LABEL_STRING, stitre,
                       0);
    conv_ligne = panel_create_item (panel_convol, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(2),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[1],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_conv,
                       0);
    conv_colonne = panel_create_item (panel_convol, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(3),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[2],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_conv,
                       0);
    conv_fact = panel_create_item (panel_convol, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(4),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[30],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_conv,
                       0);
    conv_masque = panel_create_item (panel_convol, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(5),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[31],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_conv,
                       0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO){
	oldligne = ((struct convol *)macro_cour->param)->ligne;
	panel_set_value (conv_ligne, sprintf(repfloat, "%d", oldligne)); 
	oldcolonne = ((struct convol *)macro_cour->param)->colonne;
	panel_set_value (conv_colonne, sprintf(repfloat, "%d", oldcolonne));
	panel_set_value (conv_fact, sprintf(repfloat, "%f", 
	    ((struct convol *)macro_cour->param)->factmult));
	panel_set_value (conv_masque, sprintf(repfloat, "%f", 
	    *((struct convol *)macro_cour->param)->masque));
    }
    window_fit (panel_convol);
    window_fit (frame_convol);
    window_set (panel_convol, PANEL_CARET_ITEM, conv_ligne, 0);
    conv = (struct convol *)window_loop(frame_convol);
    return (conv);
}

/*****************************************************************************/

caddr_t	proc_convol (m, mi)
    Menu m;
    Menu_item mi;

{
    struct convol *conv, *copyconv;
    int select = (int)menu_get (mi, MENU_VALUE);
    float *im;
    register int i;

    switch (select) {
    case 1:  /* avec masque */
    case 11:
	if (flag_bother){	
	    if (select == 2) hproc_convol_masq();
	    else hproc_correl_masq();
	    return;
	}
	if (flag_help){	
	    if (select == 2) hproc_convol_masq();
	    else hproc_correl_masq();
	}
	if (!flag_creer){
	    if (select == 1) sprintf (buf, "Convolution: "); 
	    else sprintf (buf, "Correlation: ");
	    write_master(buf);
	}
	if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	    index_image[0] = macro_cour->from[0];
	    index_image[1] = macro_cour->to[0];
	}
	else fromto (FROMTO, DEFAUT);
	
	if (flag_break) interruption();
	else if (dir_image[index_image[0]].image == NULL){
	    write_erreur(1);
	    return;
	}
	else{
	    if (!flag_creer){
		sprintf (buf, "Image %d * masque --> %d\n", 
			index_image[0], index_image[1]);
		write_master (buf);
	    }
	    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
		conv = (struct convol *)malloc(sizeof(*conv));
		*conv = *(struct convol *)macro_cour->param;
	    }
	    else 
		conv = convol_panel();
	    if (flag_break) interruption();
	    else{
		if (flag_creer){
		    char *line, *masque;
		    float *m;
		    struct commande *com;

		    com = (struct commande *)new_commande(&macro_cour);
		    if (select == 1){
			sprintf (com->nom, "PROCONCONWMA");
			com->code = 60;
			sprintf (buf, "PROCONCONWMA");
		    }
		    else{
			sprintf (com->nom, "PROCONCORWMA");
			com->code = 62;
			sprintf (buf, "PROCONCORWMA");
		    }
		    com->from[0] = index_image[0];
		    com->to[0] = index_image[1];
		    line = (char *)malloc(80);
		    strcat (buf, sprintf(line," FROM %d TO %d WITH %d %d %f",
			    index_image[0], index_image[1], 
			    conv->ligne, conv->colonne, conv->factmult));
		    write_macro(buf);
		    masque = (char *)malloc(conv->colonne * conv->ligne * 10);
		    strcpy (masque, "");
		    m = conv->masque;
		    for (i=0; i < conv->ligne * conv->colonne; i++){
			strcat (masque, sprintf(line, " %f", *m));
			m++;
		    }
		    strcat (masque, "\n");
		    write_macro(masque);
		    copyconv = (struct convol *)malloc(sizeof(*copyconv));
		    *copyconv = *conv;
		    com->param = (char *)copyconv;
		    free(masque);
		    free(line);
		}
		else{
		    if (flag_break) interruption();
		    switch (dir_desc[index_image[0]].type ){
			case 6:
			case -1:
			case 0:
			case 1:
			case 2:flag_conv = TRUE;
				im = (float *)conv_float(index_image[0]);
				break;
			case 3:
			case 4:
			case 5:flag_conv = FALSE;
				im = (float *)dir_image[index_image[0]].image;
				break;
		    }
		    convolue (im,index_image[0], index_image[1],
					conv, select);
		    if (flag_conv) free(im);
		 /*   else {
			if (dir_desc[index_image[0]].type > 3)
			    write_erreur(12);
			else {
			    if (dir_desc[index_image[0]].type == 3){
				im = (float *)dir_image[index_image[0]].image;
				flag_conv = FALSE;
			    }
			    else{
				im = (float *)conv_float(index_image[0]);
				flag_conv = TRUE;
			    }
			    convolue (im,index_image[0], index_image[1],
					conv, select);
			    if (flag_conv) free(im);
			}
		     } */

		}
	    }
	}
	break;
    case 2:  /* avec image */
    case 12:
	if (flag_bother){	
	    if (select == 2) hproc_convol_image();
	    else hproc_correl_image();
	    return;
	}
	if (flag_help){	
	    if (select == 2) hproc_convol_image();
	    else hproc_correl_image();
	}
	if (!flag_creer){
	    if (select == 2) sprintf (buf, "Convolution: "); 
	    else sprintf (buf, "Correlation: ");
	    write_master(buf);
	}
	if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	    index_image[0] = macro_cour->from[0];
	    index_image[2] = macro_cour->from[1];
	    index_image[1] = macro_cour->to[0];
	}
	else fromto (FROMTO, DEF21);
	
	if (flag_break) interruption();
	else if (dir_image[index_image[0]].image == NULL){
	    write_erreur(9);
	    return;
	}
	if (dir_image[index_image[2]].image == NULL){
	    write_erreur(10);
	    return;
	}
	else{
	    if (!flag_creer){
		sprintf (buf, " %d *  %d --> %d\n", 
			index_image[0], index_image[2], index_image[1]);
		write_master(buf);
		if (dir_desc[index_image[0]].type > 3 || 
		    dir_desc[index_image[2]].type > 3 ) write_erreur(12);
	/*	else { 
		    if (dir_desc[index_image[0]].type == 3){
			flag_conv = FALSE;
			im = (float *)dir_image[index_image[0]].image;
		    }
		    else{
			flag_conv = TRUE;
			im = (float *)conv_float(index_image[0]);
		    }
		    conv = (struct convol *) malloc(sizeof(*conv));
		    if (dir_desc[index_image[2]].type == 3){
			flag_conv2 = FALSE;
			conv->masque =(float *)dir_image[index_image[2]].image;
		    }
		    else{
			flag_conv2 = TRUE;
			conv->masque = (float *)conv_float(index_image[2]);
		    }
		    conv->colonne = dir_desc[index_image[2]].ncolonne;
		    conv->ligne = dir_desc[index_image[2]].nligne;
		    conv->factmult = 1.0;
		    convolue(im, index_image[0], index_image[1], conv, select);
		    if (flag_conv) free(im);
		    if (flag_conv2) free(conv->masque);
	         }   */
		    switch (dir_desc[index_image[0]].type ){
			case 6:
			case -1:
			case 0:
			case 1:
			case 2:flag_conv = TRUE;
				im = (float *)conv_float(index_image[0]);
				break;
			case 3:
			case 4:
			case 5:flag_conv = FALSE;
				im = (float *)dir_image[index_image[0]].image;
				break;
		    }
		    conv = (struct convol *) malloc(sizeof(*conv));
		    if (dir_desc[index_image[2]].type == 3){
			flag_conv2 = FALSE;
			conv->masque =(float *)dir_image[index_image[2]].image;
		    }
		    else{
			flag_conv2 = TRUE;
			conv->masque = (float *)conv_float(index_image[2]);
		    }
		    conv->colonne = dir_desc[index_image[2]].ncolonne;
		    conv->ligne = dir_desc[index_image[2]].nligne;
		    conv->factmult = 1.0;
		    convolue(im, index_image[0], index_image[1], conv, select);
		    if (flag_conv) free(im);
		    if (flag_conv2) free(conv->masque);

	    }
	    else { /* creation */
		struct commande *com;
		com = (struct commande *)new_commande(&macro_cour);
		if (select == 2){
		    sprintf (com->nom, "PROCONCOMWIM");
		    com->code = 61;
		    sprintf (buf,"PROCONCONWIM FROM %d %d TO %d\n",
			    index_image[0], index_image[2], index_image[1]);
		}
		else{
		    sprintf (com->nom, "PROCONCORWIM");
		    com->code = 63;
		    sprintf (buf,"PROCONCORWIM FROM %d %d TO %d\n",
			    index_image[0], index_image[2], index_image[1]);
		}
		write_macro(buf);
		com->from[0] = index_image[0];
		com->from[1] = index_image[2];
		com->to[0] = index_image[1];
		com->param = NULL;
	    }
	}
	break;
    case 3:
        if (flag_bother){
	   hproc_creer_masq();
	   return;
	}
        if (flag_help) hproc_creer_masq();
	if (!flag_creer){
	    sprintf (buf, mastertabs[35]); 
	    write_master(buf);
	}
	if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	    index_image[1] = macro_cour->to[0];
	}
	else fromto (TO, DEFAUT);
	
	if (flag_break) interruption();
/*	else if (dir_image[index_image[0]].image == NULL){
	    write_erreur(1);
	    return;
	}
*/

	else{
	    if (!flag_creer){
		sprintf (buf, "--> %d\n", index_image[1]);
		write_master (buf);
	    }
	    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
		conv = (struct convol *)malloc(sizeof(*conv));
		*conv = *(struct convol *)macro_cour->param;
	    }
	    else 
		conv = convol_panel();
	    if (flag_break) interruption();
	    else{
		if (flag_creer){
		    char *line, *masque;
		    float *m;
		    struct commande *com;

		    com = (struct commande *)new_commande(&macro_cour);
		    sprintf (com->nom, "PROCONCMA");
		    com->code = 64;
		    com->to[0] = index_image[1];
		    line = (char *)malloc(80);
		    sprintf(buf, "PROCONCMA TO %d WITH %d %d %f",index_image[1],
			    conv->ligne,conv->colonne,conv->factmult);
		    write_macro(buf);
		    masque = (char *)malloc(conv->colonne * conv->ligne * 10);
		    strcpy (masque, "");
		    m = conv->masque;
		    for (i=0; i < conv->ligne * conv->colonne; i++){
			strcat (masque, sprintf(line, " %f", *m));
			m++;
		    }
		    strcat (masque, "\n");
		    write_macro(masque);
		    copyconv = (struct convol *)malloc(sizeof(*copyconv));
		    *copyconv = *conv;
		    com->param = (char *)copyconv;
		    free(masque);
		    free(line);
		}
		else{
		    im = (float *)malloc (conv->ligne * conv->colonne * 4);
		    if (dir_image[index_image[1]].image != NULL) 
			free (dir_image[index_image[1]].image);
		    dir_image[index_image[1]].image = (unsigned char *)im;
		    for (i=0; i < conv->ligne * conv->colonne; i++){
			*im = *(conv->masque) * conv->factmult;
			im++;
			(conv->masque)++;
		    }
		    dir_desc[index_image[1]].type = 3;
		    dir_desc[index_image[1]].nligne = conv->ligne;
		    dir_desc[index_image[1]].ncolonne = conv->colonne;
		    strcpy (dir_desc[index_image[1]].date, (char *)get_time());
			/* date et heure */
		    strcpy (dir_desc[index_image[1]].filename, "-masque-");
			/* nom */
		    statis (dir_image[index_image[1]].image,
			    dir_desc[index_image[1]].type, 
			    dir_desc[index_image[1]].nligne,
			    dir_desc[index_image[1]].ncolonne,
			    &(dir_desc[index_image[1]].mmin),
			    &(dir_desc[index_image[1]].mmax), 
			    &(dir_desc[index_image[1]].mu),
			    &(dir_desc[index_image[1]].ecart));
		}
	    }
	}
	break;
    }
}
