/*
 **  File: pic.c
 **  Purpose:  Functions to read .iv and .im files (Obsolete Adage file formats)
 **  See pic.h for descriptions of exported functions.
 */

#include <stdio.h>
#include <pic.h>

/* External declarations */
extern char *malloc();
extern void exit();
extern void free();

#define RGBRUNLEN 70 /* "Magic" number for Berkeley run-length encoded files. */

/* Forward Declarations */
static pic *ReadRaw( ),  *ReadRLE( );

/*  Local Funtion:
 **
 **  GetPixel returns the next pixel from the input stream in *Pixelptr.
 **  it returns TRUE if a pixel was available and FALSE on EOF or error.
 */
#define INBUFSIZE 512
static int inbuf[INBUFSIZE];
static int *inbufend = inbuf+INBUFSIZE;
static int *ptr = inbuf+INBUFSIZE;
static int pixelsRead;
#define GetPixel(Pixelptr) \
  ((ptr != inbufend) ? ( *(Pixelptr) = *ptr++, 1 ) :\
   ((pixelsRead = fread((char *)inbuf, sizeof(int), INBUFSIZE, Infile)) <= 0)\
   ? 0 : ( inbufend=inbuf+pixelsRead, ptr=inbuf, *(Pixelptr) = *ptr++, 1 ))


/* Exported function for Opening an image file */
pic *
  pic_open(Infile)
FILE *Infile;
{
  int Mode, bytesRead;
  
  rewind( Infile );
  if ( (bytesRead=fread((char *)(&Mode), sizeof(Mode), 1, Infile ) != 1))  {
    (void) fprintf(stderr, "Error in reading file.  Bytes read = %d\n",
	    bytesRead);
    exit(1);
  }
  if (Mode != RGBRUNLEN) {
    return ReadRaw( Infile);
  } else {
    return ReadRLE( Infile );
  }
}

static pic *
  ReadRLE( Infile )
FILE *Infile;
{
  pic *image= (pic *)malloc(sizeof(pic));
  int *i_ptr, *end;
  int RunCode, Color, count, i;
  
  /* The next two words of the file are the size of the final image */
  (void) fread( (char *)&image->xsize, sizeof(int), 1, Infile );
  (void) fread( (char *)&image->ysize, sizeof(int), 1, Infile );
  
  image->image = (int *) malloc( (unsigned int)
				image->xsize * image->ysize * sizeof(int) );
  if (image->image == NULL) {
    (void) fprintf( stderr, "No memory available for the image!\n" );
    exit(1);
  }
  
  i_ptr = image->image;
  end   = i_ptr + (unsigned)( image->xsize * image->ysize );
  while ( GetPixel(&RunCode) ) {
    count = RunCode & 0xff;
    Color = RunCode >> 8;
    if (i_ptr+count >= end)  /* Avoid overflow */
      count = (end - i_ptr);
    for(i=0; i<count; i++) {
      *i_ptr++ = Color;
    }
  }
  return(image);
}

static pic *
  ReadRaw( Infile )
FILE *Infile;
{
  pic *image= (pic *) malloc(sizeof(pic));
  int ystart, yend;
  int y;
  
  rewind( Infile );
  (void) fread( (char *)&image->xsize, sizeof(int), 1, Infile );
  (void) fread( (char *)&yend,   sizeof(int), 1, Infile );
  (void) fread( (char *)&ystart, sizeof(int), 1, Infile );
  image->ysize = yend - ystart + 1;
  
  image->image = (int *) malloc( (unsigned int)
				image->xsize * image->ysize * sizeof(int) );
  if (image->image == NULL) {
    (void) fprintf( stderr, "No memory available for the image!\n" );
    exit(1);
  }
  for(y=0; y<image->ysize; y++)
    (void) fread( (char *)(image->image + (image->ysize-1-y)*image->xsize), 
		 sizeof(int), image->xsize, Infile );
  return(image);
}


/* Exported function for reading the picture size */
void 
  pic_read_size(p, xp, yp)
pic *p;
int *xp;
int *yp;
{
  *xp = p->xsize;
  *yp = p->ysize;
}

/* Exported function for reading a scanline */
void 
  pic_read_line(p, y, buf)
pic *p;
int y;
pic_pixel *buf;
{
  register int *i_ptr = p->image + (p->ysize-y-1)*p->xsize;
  register int *end   = i_ptr + p->xsize;
  register pic_pixel *o_ptr = buf;
  
  for(; i_ptr < end; i_ptr++, o_ptr++) {
    o_ptr->r = *i_ptr & 0xFF;
    *i_ptr >>= 8;
    o_ptr->g = *i_ptr & 0xFF;
    *i_ptr >>= 8;
    o_ptr->b = *i_ptr & 0xFF;
  }
}

void 
  pic_close(p)
pic *p;
{
  (void) free((char *)p->image);
  (void) free((char *)p);
}

