/*
  File: img2wff.c
  Authors: K.R. Sloan
           Yun Wang
  Last Modified: 21 March 1991
  Purpose: Convert a Img file format file (.img) to .WFF format
  NOTE: this is a very simple first attempt - it doesn't come close
        to handling all possible Img options.  
        It handles colormap now.
*/
#include <assert.h>
#include <stdio.h>
#include "wff.h"

void *calloc();

static int VERBOSE = 0;
static char *RoutineName;
static usage()
 {
  fprintf( stderr, "Usage: %s [-h][-v] < img > wff\n", RoutineName );
  exit(1);
 }

static void FatalError(s)
 char *s;
 {
  fprintf(stderr,"%s: Fatal Error(%s)\n",RoutineName,s);
  exit(-1);
 } 

/* Img file stuff */

typedef struct Imgfile {
       char filetype[5]; 
       int  version;
       char attname[3];
       int  attlength;
       int  width;
       int  height;
       int  ncolors;
       unsigned char *asso;     /* This is nasty, how to use it? */
       char mapname[3];
       int  maplength;
       char dataname[3];
       int  datalength;
               }ImgfileType;

ImgfileType Img;
unsigned char Red[256], Green[256], Blue[256];
unsigned char *Pixdata;

static void ReadImgHeader(fdIn, fdOut)
 FILE *fdIn;
 {
  int i;
  char Field[80]; /* for parsing fields of the header */ 
 
  fscanf(fdIn,"%4s%4c",Img.filetype,Field);
  Field[4] = 0; Img.version = atoi(Field);
  if (VERBOSE)
   fprintf(stderr,"|%4s|%4d|\n",Img.filetype,Img.version);

  fscanf(fdIn,"%2s%8c",Img.attname,Field); 
  Field[8] = 0; Img.attlength = atoi(Field); 
  if (VERBOSE)
   fprintf(stderr,"|%2s|%8d|\n",Img.attname,Img.attlength);

  fscanf(fdIn,"%4c",Field);
  Field[4] = 0; Img.width   = atoi(Field);
  fscanf(fdIn,"%4c",Field);
  Field[4] = 0; Img.height  = atoi(Field);
  fscanf(fdIn,"%4c",Field);
  Field[4] = 0; Img.ncolors = atoi(Field);
  if (VERBOSE)
   fprintf(stderr,"|%4d|%4d|%4d|\n",Img.width,Img.height,Img.ncolors);     

  if (Img.attlength>12)    /*  We also need to read associated data */
   {
    fread(Img.asso,sizeof(unsigned char),Img.attlength-12,fdIn);
   }
  if (VERBOSE)
   {
    fprintf(stderr,"|");
    for(i=0;i<(Img.attlength-12);i++)
     fputc(stderr,Img.asso[i]);
    fprintf(stderr,"|\n");
   }

  fscanf(fdIn,"%2s%8c", Img.mapname,Field);
  Field[8] = 0; Img.maplength = atoi(Field);

  if (VERBOSE)
   fprintf(stderr,"|%2s|%8d|\n", Img.mapname, Img.maplength);

  if (Img.maplength != (3*Img.ncolors))
   FatalError("MapLength and NColors do not match");
  else
   for (i=0; i < Img.ncolors; i++)
    {
     Red[i]   = (unsigned char)fgetc(fdIn);
     Green[i] = (unsigned char)fgetc(fdIn);
     Blue[i]  = (unsigned char)fgetc(fdIn);
     if (VERBOSE) fprintf(stderr,"|%3d|%3d|%3d|\n", Red[i],Green[i],Blue[i]);
    }

  fscanf(fdIn,"%2s%8c",Img.dataname,Field);
  Field[8] = 0; Img.datalength = atoi(Field);
  if (VERBOSE) fprintf(stderr,"|%2s|%8d|\n",Img.dataname,Img.datalength);

  if (VERBOSE)
   {
    fprintf(stderr,"\n\n%4s %4d\n",Img.filetype,Img.version);
    fprintf(stderr,"%2s   %4d\n",Img.attname,Img.attlength);
    fprintf(stderr,"%4d   %4d   %4d\n",Img.width,Img.height,Img.ncolors);     
    for(i=0;i<(Img.attlength-12);i++) fputc(stderr,Img.asso[i]);
    fprintf(stderr,"\n");    
    fprintf(stderr,"%2s %8d\n", Img.mapname,Img.maplength);
    for (i=0; i<=(Img.ncolors-1);i++)
     fprintf(stderr,"%8d %8d %8d\n", Red[i],Green[i],Blue[i]);
    fprintf(stderr,"%2s %8d\n",Img.dataname,Img.datalength);
   }

  /*     Now it is data      */
  Pixdata = (unsigned char *)calloc(sizeof(unsigned char),Img.datalength);
  if (!Pixdata) FatalError("no memory for Imgdata");
  fread(Pixdata,sizeof(unsigned char),Img.datalength,fdIn); 
 }

static FrameBufferType *SetUpWFFFile(stream, xsize, ysize)
 FILE *stream;
 int xsize, ysize;
 {
  FrameBufferType *FrameBuffer;
  int Bottom, Left, Top, Right;
  int BitsPerBand;
  char WhatBands[10], Name[NameLength], Value[ValueLength];

  FrameBuffer = (FrameBufferType *)0;

  OpenFB(&FrameBuffer);
  assert(FrameBuffer);

  Bottom = 0; Left = 0; Top = ysize-1; Right = xsize-1;
  SetBounds(FrameBuffer, Bottom, Left, Top, Right);

  /* we only handle the simple cases...*/
  if (Img.maplength!= 0)      /* or 24bit_RGB ---I am thinking     */ 
   { BitsPerBand = 8; strcpy(WhatBands,"RGB"); }
  else             { BitsPerBand = 8; strcpy(WhatBands,"I"  ); }
  SetColorSystem(FrameBuffer, WhatBands,  BitsPerBand);


  strcpy(Name,"X-CreatedBy");
  strcpy(Value,RoutineName);
  SetDescriptor(FrameBuffer, Name, Value);

  strcpy(Name,"Encoding");
  strcpy(Value,"AIS");
  SetDescriptor(FrameBuffer, Name, Value);

  /* Header operations over, now we can start the output stream */
  PassImageOut(stream, FrameBuffer);
  return (FrameBuffer);
 }  

static void WriteMappedImage(FB)
 FrameBufferType *FB;
 { 
  unsigned char *Iptr;
  int x,y;

  for(y=0;y<Img.height;y++)
   {
    unsigned short Pixel[3];
    register unsigned char c;

    Iptr = &Pixdata[(Img.height-1-y)*Img.width];
    
    /* this is slow, but you'll find it easier to extend...*/  
    for(x=0;x<Img.width;x++)
     {
      if ( 0 != Img.maplength )
       {
        c =  *(Iptr++);
        Pixel[0] = Red[c];
        Pixel[1] = Green[c];
        Pixel[2] = Blue[c];
       }
      else 
        Pixel[0] = (unsigned short) *(Iptr++);;

      NextPixelOut(FB, (unsigned short *)Pixel);
     }
    wffFlush(FB);
   }
 }

/*
  The Main Line (are we in Philadelphia, yet?)
 */
int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  FrameBufferType *FB;

  RoutineName = argv[ArgsParsed++];
  while (ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0]) { usage(); exit(-1); }
    switch (argv[ArgsParsed++][1])
     {
      case 'v': VERBOSE = -1; break;
      default:
      case 'h': usage(); exit(-1);
     }
   }

  ReadImgHeader(stdin);

  FB = SetUpWFFFile(stdout, Img.width,Img.height);
  assert(FB);

  WriteMappedImage(FB);

  CloseFB(&FB);
  exit(0);
 }
