/*
   File: i2rgb.c
   Author: K.R. Sloan, James Painter
   Last Modified: 11 April, 1989
   Purpose: Convert an i wff file to rgb
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s\n",
           RoutineName);
 }

static void
Pass(fdIn,fdOut)
 FILE *fdIn, *fdOut;
 {
  FrameBufferType *FBin = NULL, *FBout = NULL;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  char WhatBands[ValueLength];
  int  BitsPerBand;
  int i, j, x,y,n, width;
  unsigned short *Pixel, *pin, *pout;
  extern char *malloc( /* unsigned */ );
  int passed = 0, AlphaBand = 0;

  if (FAILURE == OpenFB(&FBin))           {                        return; }
  if (FAILURE == PassImageIn(fdIn, FBin)) { (void)CloseFB(&FBin);  return; }
  if (FAILURE == OpenFB(&FBout))          { (void)CloseFB(&FBin);  return; }
 

  /*  Copy over existing NV pairs - watch for "X-PassedBy" */
  for (n=0;;n++)
   {
    GetDescriptorN(FBin, n, Name, Value);
    if (Name[0] == '\0') break;
    if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }
    SetDescriptor(FBout, Name, Value);
   }

  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    SetDescriptor(FBout, Name, Value);
   }

   /* Make sure the input image is a RGB image */
  GetColorSystem( FBin, WhatBands, &BitsPerBand );
  if (strcmp(WhatBands,"I") != 0 && strcmp(WhatBands,"IA") != 0) {
    fprintf( stderr, 
	    "Sorry. This program only knows how to deal with I images.\n" );
    exit (1 );
  }
  if (FBin->BandsPerPixel == 1)
    {
      strcpy( WhatBands, "RGB"); AlphaBand = 0;
    }
  else 
    {
      strcpy( WhatBands, "RGBA" ); AlphaBand = 1;
    }
      

  /* Set the output color system */
  SetColorSystem( FBout, WhatBands, BitsPerBand );
  
  /* Header operations over, now we can start the output stream */
  if (FAILURE == PassImageOut(fdOut, FBout))
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  /* Finally, pass the pixels */
  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right))
    { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  width = Right-Left+1;
  Pixel = (unsigned short *) 
    malloc ( (unsigned) (width * 4 * sizeof(*Pixel) ) );
  if (Pixel == NULL) 
    {
      fprintf( stderr, "No memory!\n" );
      (void)CloseFB(&FBin); (void)CloseFB(&FBout); return;
    }

  for (y=Bottom;y<=Top;y++)
   {
     if (FAILURE == NextNPixelsIn(FBin,width,Pixel))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
    
    i=0; j=0;
    pin  = Pixel + (width)*FBin->BandsPerPixel;
    pout = Pixel + (width)*FBout->BandsPerPixel;
    for (x=Right;x>=Left;x--)
     {
      *--pout = *--pin;
      *--pout = *pin;
      *--pout = *pin;
      if (AlphaBand) *--pout = *--pin;
     }
     if (FAILURE == NextNPixelsOut(FBout,width,Pixel))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
   }
  (void)CloseFB(&FBin);
  (void)CloseFB(&FBout);

 }

main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
 
  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc)  { usage(); exit (-1); }	

  Pass(stdin,stdout);
  exit (0);
}










