/*
  File: addAlpha.c
  Authors: Mike Schmidt,
           K.R. Sloan,
	   James Painter
  Last Modified: 13 January, 1989
  Purpose: Add a (constant) alpha band to an image
 */
#include <stdio.h>
#include <strings.h>
#include "wff.h"

static char *RoutineName;
static int alphavalue = 255;

static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [alphavalue]\n",
           RoutineName);
 }

static void
Pass(fdIn,fdOut)
 FILE *fdIn, *fdOut;
 {
  FrameBufferType *FBin = NULL, *FBout = NULL;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  int x,y,n;
  unsigned short *Pixel;
  int passed = 0, width;
  int BandsPerPixel;

  if (FAILURE == OpenFB(&FBin))           {                        return; }
  if (FAILURE == PassImageIn(fdIn, FBin)) { (void)CloseFB(&FBin);  return; }
  if (FAILURE == OpenFB(&FBout))          { (void)CloseFB(&FBin);  return; }
 

  /*  Copy over existing NV pairs - watch for "X-PassedBy" */
  for (n=0;;n++)
   {
    GetDescriptorN(FBin, n, Name, Value);
    if (Name[0] == '\0') break;

    if      (0 == strcmp(Name,"Encoding"))
     {
      strcpy(Value,"RLE");
     }
    else if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }
    else if (0 == strcmp(Name,"ColorSystem")) 
      {
	int l = strlen(Value);
	if (Value[l-1] != 'A') 
	  {
	    Value[l] = 'A'; Value[l+1] = '\0';
	  }
      }
    SetDescriptor(FBout, Name, Value);
   }

  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    SetDescriptor(FBout, Name, Value);
   }

  /* Header operations over, now we can start the output stream */
  if (FAILURE == PassImageOut(fdOut, FBout))
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  /* Finally, pass the pixels */
  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right)) 
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
  width = Right-Left+1;
  BandsPerPixel = FBin->BandsPerPixel;
  Pixel = (unsigned short *) 
    malloc( sizeof(unsigned short) * (unsigned)(width * (BandsPerPixel+1)) );
  if ((unsigned short *)0 == Pixel)
    {
      fprintf( stderr, "No memory for scan line buffer!\n" );
      (void)CloseFB(&FBin); (void)CloseFB(&FBout); return;
    }
      
  for (y=Bottom;y<=Top;y++)
   {
     for(x=Left; x <=Right; x++) 
       {
	 if (FAILURE == NextPixelIn(FBin, Pixel))
	   {  
	     fprintf(stderr,"%s: NextNPixelsIn failed\n", RoutineName);        
	     (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; 
	   }
	 Pixel[BandsPerPixel] = alphavalue;
	 if (FAILURE == NextPixelOut(FBout, Pixel))
	   {
	     fprintf(stderr,"%s: NextNPixelsOut failed\n", RoutineName);        
	     (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; 
	   }
       }
   }       

  (void)CloseFB(&FBin);
  (void)CloseFB(&FBout);
 }

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
 
  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc)  alphavalue = atoi(argv[ArgsParsed++]);
  if (ArgsParsed < argc)  { usage(); exit (-1); }	

  Pass(stdin,stdout);

  fprintf(stderr,"\n                -30-\n");
  exit (0);
}

