/*
 File: WC.c
 Author: K.R. Sloan
 Last Modified: 15 September 1992
 Purpose: read a tournament record, and print the wallchart
 */
#include <stdio.h>
#include "PairingCards.h"

int VERBOSE = 0;

char *RoutineName;

static void usage()
 {
  fprintf(stderr,"usage\n\t%s [-h][-v][-l]\n",RoutineName);
 }

static void FatalError(s)
 {
  fprintf(stderr,"%s: FatalError(%s)\n",RoutineName,s);
  exit(-1);
 }

int main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  int p; 
  
  RoutineName = argv[ArgsParsed++];
  while(argc > ArgsParsed)
   {
    if ('-' != argv[ArgsParsed][0]) {usage(); exit(-1);}
    switch (argv[ArgsParsed++][1])
     {
      case 'v': VERBOSE = -1; break;
      default:
      case 'h': usage(); exit(-1);
     }
   }

  ReadRecord(stdin);

  WallChart(stdout,PLAYERS,ROUNDS,PairingCards);

  exit(0);
 }

