/*
   File: framebuffer.h
   Authors: Tony DeRose,
            K.R. Sloan
   Last Modified: 12 October 1989
   Purpose: simple framebuffer abstraction using X11
            this is a binary display, with the origin at the lower left  

            Rectangles are specified as: Left, Top, Right, Bottom

            It is assumes (BUT NOT CHECKED!) that:
                   Left   <= Right
                   Bottom <= Top

            This version adds mouse tracking and button pushes.
*/

#ifndef min
#define min(a,b)        (((a)<(b))?(a):(b))
#define max(a,b)        (((a)<(b))?(b):(a))
#endif

#ifndef TRUE
#define TRUE  (1)
#define FALSE (0)
#endif

/* Error Codes */
#define FB_ERROR        (-1)
#define FB_SUCCESS      (0)

/* Predefined Colors */
#define FB_WHITE           (0)
#define FB_BLACK           (1)

/* Color type (just an int for now) */
typedef int FB_COLOR;

/* External definitions */
/*
  fb_open(&Left, &Bottom, &Right, &Top)
  creates the framebuffer window, displays it on the screen,
  and returns the range of its device coordinates.
 */
extern int fb_open();

/*
  fb_close() destroys the framebuffer window
 */
extern int fb_close();

/*
  fb_writePixel(x, y, color) writes a pixel. 
    Left <= x <= Right
    Bottom <= x <= Top
    Color = {FB_BLACK | FB_WHITE}
 */
extern int fb_writePixel();

/*
 fb_writeRectangle(Left, Bottom, Right, Top, color) fills a rectangle
 */
extern int fb_writeRectangle();

/*
 fb_drawLine(x1, y1 ,x2, y2, color)
 draws a line
 */
extern int fb_drawLine();

/*
 fb_text(x, y, str, color) draws text, starting at x,y, in the specified color
 */
extern int draw_text();

/*
 fb_flush() flushes all buffers
 */
extern int fb_flush();

/*
  fb_error_message points at an explanation of your error
 */
extern char *fb_error_message;

/*
 fb_pick(&x,&y,&buttons ) returns the location of the mouse, and
 the status of the buttons
 */

extern int fb_pick();
