/*
  File: SGP.h
  Author: K.R. Sloan
  Last Modified: 12 October 1989
  Purpose: definitions for a Simple Graphics Package
 */

typedef struct sgpP { double x, y; } sgpPointType;
typedef struct sgpR { double Left, Bottom, Right, Top; } sgpRectangleType;
typedef enum sgpD  
              {
               DebugDisplay,
               ColorDisplay,
               MonochromeDisplay
              } sgpDisplayType; 
typedef struct sgpC { double r, g, b; } sgpColorType;
#define sgpGrayType double
typedef struct sgpS
 {
  sgpDisplayType Display;
  sgpRectangleType Window, Viewport, Normalized, Physical;
  sgpColorType Color;
 } sgpStateType;

extern void sgpInit();         /* sgpInit(UseDisplay)
                                   sgpDisplayType UseDisplay;               */
extern void sgpQuit();

extern void sgpColor();        /* sgpColor(NewColor)
                                   sgpColorType NewColor;                   */
extern void sgpGrayLevel();    /* sgpGrayLevel(NewLevel)
                                   sgpGrayType NewLevel                     */
extern void sgpInquire();      /* sgpInquire(State)
                                   sgpStateType *State;                     */
extern void sgpSetWindow();    /* sgpSetWindow(NewWindow) 
                                   sgpRectangleType NewWindow;              */
extern void sgpSetViewPort();  /* sgpSetViewport(NewViewport);
                                   sgpRectangleType NewViewport;            */
extern void sgpWorldToScreen();/* sgpWorldToScreen(World, Screen)
                                   sgpPointType World, *Screen;             */
extern void sgpScreenToWorld();/* sgpScreenToWorld(Screen, World)
                                   sgpPointType Screen, *World;             */
extern void sgpScreenToPhysical(); /* sgpScreenToPhysical(Screen, Physical)
                                        sgpPointType Screen, *Physical;     */
extern void sgpPhysicalToScreen(); /* sgpPhysicalToScreen(Physical, Screen)
                                       sgpPointType Physical, *Screen       */
extern void sgpClearScreen();  /* sgpClearScreen()                          */
extern void sgpPoint();        /* sgpPoint(Point)
                                   sgpPointType Point;                      */
extern void sgpDot();          /* sgpDot(Point, ScreenSize)
                                   sgpPointType Point; int ScreenSize       */
extern void sgpLine();         /* sgpLine(Point1, Point2)
                                   sgpPointType Point1, Point2;             */
extern void sgpPolyLine();     /* sgpPolyLine(n, Points)
                                   int n; sgpPointType *Points;             */
extern void sgpCurve();        /* sgpCurve(m, n, Points)
                                   int m, n; sgpPointType *Points;          */
extern void sgpRectangle();    /* sgpRectangle(Rectangle);
                                   sgpRectangleType Rectangle;              */
extern void sgpCircle();       /* sgpCircle(Center, Radius);
                                   sgpPointType Center;
                                   double Radius;                           */
extern void sgpDisc();         /* sgpDisc(Center, Radius);
                                   sgpPointType Center;
                                   double Radius;                           */
extern void sgpShadeTriangle();/* sgpShadeTriangle(Points, Colors)
                                   sgpPointType Pointss[3],
                                   sgpColorType Colors[3];                  */
extern void sgpSolidTriangle();/* sgpSolidTriangle(Points)
                                   sgpPointType Points[3];                 */
extern void sgpPick();         /* sgpPick(World, button)            
                                   sgpPointType *World;
                                   int *button;                             */

/* -30- */
